/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.teamscale.index.backup.AutoBackupOption;
import com.teamscale.index.backup.BackupInfo;
import com.teamscale.index.backup.BackupLocationInfo;
import com.teamscale.index.backup.IBackupTarget;
import java.io.IOException;
import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;

public class BackupCleaner {
    private final AutoBackupOption autoBackupOption;
    private final ZonedDateTime now;
    private final ZoneId zoneId;

    public BackupCleaner(AutoBackupOption autoBackupOption, ZonedDateTime now, ZoneId zoneId) {
        this.autoBackupOption = autoBackupOption;
        this.now = now;
        this.zoneId = zoneId;
    }

    public void cleanupBackups(BackupLocationInfo backupLocationInfo, IBackupTarget backupTarget) throws IOException {
        List<BackupInfo> backupsInSameLocation = backupTarget.getBackupsInSameLocation(backupLocationInfo);
        List<BackupInfo> backupsToDelete = this.determineBackupsToDelete(backupsInSameLocation);
        if (!backupsToDelete.isEmpty()) {
            backupTarget.deleteBackupsInSameLocation(backupsToDelete);
        }
    }

    private List<BackupInfo> determineBackupsToDelete(List<BackupInfo> backupInfos) {
        ArrayList<BackupInfo> backupInfosToDelete = new ArrayList<BackupInfo>(backupInfos);
        backupInfos.stream().max(BackupInfo::compareTo).ifPresent(backupInfosToDelete::remove);
        backupInfosToDelete.removeAll(this.getBackupsForKeepingAllBackups(backupInfos));
        backupInfosToDelete.removeAll(this.getWeeklyBackupsToKeep(backupInfos));
        backupInfosToDelete.removeAll(this.getMonthlyBackupsToKeep(backupInfos));
        return backupInfosToDelete;
    }

    private List<BackupInfo> getBackupsForKeepingAllBackups(List<BackupInfo> backupInfos) {
        if (this.autoBackupOption.daysToKeepAllBackups <= 0) {
            return Collections.emptyList();
        }
        ZonedDateTime beginningOfKeepingAllBackups = this.adjustToBeginningOfDay(this.now).minusDays(this.autoBackupOption.daysToKeepAllBackups);
        long timestampAfterWhichAllBackupsAreKept = BackupCleaner.getTimestampForDateTime(beginningOfKeepingAllBackups);
        return CollectionUtils.filter(backupInfos, backupInfo -> timestampAfterWhichAllBackupsAreKept <= backupInfo.getLastModifiedTimestamp());
    }

    private static long getTimestampForDateTime(ZonedDateTime beginningOfKeepingAllBackups) {
        return beginningOfKeepingAllBackups.toInstant().toEpochMilli();
    }

    private List<BackupInfo> getWeeklyBackupsToKeep(List<BackupInfo> backupInfos) {
        if (this.autoBackupOption.weeksToKeepWeeklyBackups <= 0) {
            return Collections.emptyList();
        }
        List<Pair<Long, Long>> weeklyTimeFrames = BackupCleaner.determineTimeFrames(this.now, timeFrameEnd -> this.adjustToBeginningOfDay((ZonedDateTime)timeFrameEnd).with(TemporalAdjusters.previous(DayOfWeek.SUNDAY)), this.autoBackupOption.weeksToKeepWeeklyBackups);
        return BackupCleaner.getBackupInfosToKeepForTimeFrames(backupInfos, weeklyTimeFrames);
    }

    private ZonedDateTime adjustToBeginningOfDay(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toLocalDate().atStartOfDay().atZone(this.zoneId);
    }

    private List<BackupInfo> getMonthlyBackupsToKeep(List<BackupInfo> backupInfos) {
        if (this.autoBackupOption.monthsToKeepMonthlyBackups <= 0) {
            return Collections.emptyList();
        }
        List<Pair<Long, Long>> monthlyTimeFrames = BackupCleaner.determineTimeFrames(this.now, timeFrameEnd -> {
            if (timeFrameEnd.equals(this.now)) {
                return this.adjustToBeginningOfDay((ZonedDateTime)timeFrameEnd).with(TemporalAdjusters.firstDayOfMonth());
            }
            return timeFrameEnd.minusMonths(1L);
        }, this.autoBackupOption.monthsToKeepMonthlyBackups);
        return BackupCleaner.getBackupInfosToKeepForTimeFrames(backupInfos, monthlyTimeFrames);
    }

    private static List<Pair<Long, Long>> determineTimeFrames(ZonedDateTime timeFramesEnd, Function<ZonedDateTime, ZonedDateTime> endOfTimeFrameAdjuster, int numberOfTimeFrames) {
        ArrayList<Pair<Long, Long>> timeFrames = new ArrayList<Pair<Long, Long>>();
        ZonedDateTime currentEndOfTimeFrame = timeFramesEnd;
        long endTimestamp = BackupCleaner.getTimestampForDateTime(currentEndOfTimeFrame);
        for (int i = 0; i < numberOfTimeFrames + 1; ++i) {
            currentEndOfTimeFrame = endOfTimeFrameAdjuster.apply(currentEndOfTimeFrame);
            long startTimestamp = BackupCleaner.getTimestampForDateTime(currentEndOfTimeFrame);
            timeFrames.add((Pair<Long, Long>)new Pair((Object)startTimestamp, (Object)endTimestamp));
            endTimestamp = startTimestamp;
        }
        return timeFrames;
    }

    private static List<BackupInfo> getBackupInfosToKeepForTimeFrames(List<BackupInfo> backupInfos, List<Pair<Long, Long>> timeFrames) {
        ListMap backupsByTimeFrames = new ListMap();
        for (BackupInfo backupInfo : backupInfos) {
            long lastModifiedTimestamp = backupInfo.getLastModifiedTimestamp();
            timeFrames.stream().filter(frame -> (Long)frame.getFirst() < lastModifiedTimestamp && (Long)frame.getSecond() >= lastModifiedTimestamp).findFirst().ifPresent(timeFrame -> backupsByTimeFrames.add(timeFrame, (Object)backupInfo));
        }
        ArrayList<BackupInfo> backupsToKeep = new ArrayList<BackupInfo>();
        for (Pair timeFrame2 : backupsByTimeFrames.getKeys()) {
            ((List)backupsByTimeFrames.getCollection((Object)timeFrame2)).stream().max(BackupInfo::compareTo).ifPresent(backupsToKeep::add);
        }
        return backupsToKeep;
    }
}

