/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.read;

import com.teamscale.core.authenticate.AuthenticationManager;
import com.teamscale.core.authenticate.SessionIndex;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.ISubject;
import com.teamscale.core.permissions.PermissionCache;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.PermissionUtils;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.UserPermissionsProvider;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;

public class UserAndGroupHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IMessageBroker messageBroker;
    private final UserGroupIndex backupGroupIndex;
    private final UserGroupIndex currentGroupIndex;
    private final UserIndex backupUserIndex;
    private final UserIndex currentUserIndex;
    private final SessionIndex backupSessionIndex;
    private final ServerOptionIndex backupServerOptionIndex;
    private final PermissionIndex backupPermissionIndex;
    private final ProjectIndex backupProjectIndex;
    private final UserPermissionsProvider userPermissionsProvider;
    private final boolean backupContainsUserIndex;
    private boolean deletedAdminAccount = false;

    public UserAndGroupHandler(IndexLayer currentIndexLayer, IndexLayer transactionalMigrationIndexLayer, boolean backupContainsUserIndex) throws StorageException {
        this.backupGroupIndex = (UserGroupIndex)transactionalMigrationIndexLayer.openGlobalIndex(UserGroupIndex.class);
        this.currentGroupIndex = (UserGroupIndex)currentIndexLayer.openGlobalIndex(UserGroupIndex.class);
        this.backupUserIndex = (UserIndex)transactionalMigrationIndexLayer.openGlobalIndex(UserIndex.class);
        this.currentUserIndex = (UserIndex)currentIndexLayer.openGlobalIndex(UserIndex.class);
        this.messageBroker = currentIndexLayer.getMessageBroker();
        this.backupSessionIndex = (SessionIndex)transactionalMigrationIndexLayer.openGlobalIndex(SessionIndex.class);
        this.backupServerOptionIndex = (ServerOptionIndex)transactionalMigrationIndexLayer.openGlobalIndex(ServerOptionIndex.class);
        this.backupPermissionIndex = (PermissionIndex)transactionalMigrationIndexLayer.openGlobalIndex(PermissionIndex.class);
        this.backupProjectIndex = (ProjectIndex)transactionalMigrationIndexLayer.openGlobalIndex(ProjectIndex.class);
        SynchronizedCacheAccess permissionCacheAccess = transactionalMigrationIndexLayer.getStorageCacheProvider().getCacheProvider("__global__").getCacheAccess(PermissionCache.class);
        this.userPermissionsProvider = new UserPermissionsProvider(this.backupGroupIndex, this.backupPermissionIndex, permissionCacheAccess);
        this.backupContainsUserIndex = backupContainsUserIndex;
    }

    void preImport() throws StorageException {
        if (this.backupContainsUserIndex) {
            this.deleteAdminAccount();
        }
    }

    void postImport() throws StorageException {
        Set<String> usersWithOutdatedAuthenticator = this.mergeGroupsForUsers();
        this.invalidateAuthenticationSessions(usersWithOutdatedAuthenticator);
        this.mergeUsersForGroups();
        this.invalidateUserIndexMetadata();
        this.restoreAdminPermissions();
    }

    private Set<String> mergeGroupsForUsers() throws StorageException {
        HashSet<String> usersWithOutdatedAuthenticator = new HashSet<String>();
        Map currentUsersAsMap = this.currentUserIndex.getAllEntries().toMap();
        ArrayList<User> usersToUpdate = new ArrayList<User>();
        for (Pair userInBackup : this.backupUserIndex.getAllEntries()) {
            User backupUser = (User)userInBackup.getSecond();
            User existingUser = (User)currentUsersAsMap.get(userInBackup.getFirst());
            if (existingUser == null) continue;
            if (!Objects.equals(existingUser.getAuthenticator(), backupUser.getAuthenticator()) || "HashedStored".equals(existingUser.getAuthenticator())) {
                usersWithOutdatedAuthenticator.add(existingUser.getUsername());
            }
            if (!backupUser.addGroupIds(existingUser.getGroupIds())) continue;
            usersToUpdate.add(backupUser);
        }
        this.backupUserIndex.setUsers(usersToUpdate, this.messageBroker);
        return usersWithOutdatedAuthenticator;
    }

    private void mergeUsersForGroups() throws StorageException {
        Map currentUserGroupsAsMap = this.currentGroupIndex.getAllUserGroups().toMap();
        for (Pair groupInBackup : this.backupGroupIndex.getAllUserGroups()) {
            UserGroup backupGroup = (UserGroup)groupInBackup.getSecond();
            UserGroup currentGroup = (UserGroup)currentUserGroupsAsMap.get(groupInBackup.getFirst());
            if (currentGroup == null || !backupGroup.addUserNames((Set)currentGroup.getUserNames())) continue;
            this.backupGroupIndex.setGroup(backupGroup);
        }
    }

    private void invalidateUserIndexMetadata() throws StorageException {
        this.backupUserIndex.deleteEnabledUserCount();
        this.currentUserIndex.deleteEnabledUserCount();
    }

    private void restoreAdminPermissions() throws StorageException {
        UserGroup admins = new UserGroup("Administrators");
        PermissionUtils.assignAdminPermissions((ISubject)admins, (PermissionIndex)this.backupPermissionIndex);
    }

    private void invalidateAuthenticationSessions(Set<String> userNames) throws StorageException {
        if (!this.defaultAdminExists() && this.deletedAdminAccount) {
            LOGGER.info("Deleted default admin account. Set the system property \"{}\" to restore the default admin account. For more information, visit: https://docs.teamscale.com/reference/administration-ts-installation/#jvm-settings-%E2%80%93-jvm-properties", (Object)TeamscaleSystemProperties.FORCE_ADMIN_CREATION.getName());
            userNames.add("admin");
        }
        this.backupSessionIndex.removeTokensForUsers(userNames);
    }

    private boolean defaultAdminExists() throws StorageException {
        User adminUser = (User)UserUtils.wipeAfterUse((char[])"admin".toCharArray(), passwordBytes -> AuthenticationManager.getInstance().authenticate("admin", passwordBytes, this.backupUserIndex, this.backupServerOptionIndex, false));
        if (adminUser != null) {
            return this.hasAdminRights(adminUser);
        }
        return false;
    }

    private void deleteAdminAccount() throws StorageException {
        if (this.defaultAdminExists()) {
            this.deletedAdminAccount = true;
            this.backupUserIndex.removeUser("admin", this.messageBroker);
        }
    }

    private boolean hasAdminRights(User user) throws StorageException {
        return new ServicePermissions(this.userPermissionsProvider.getUserPermissions(user), null, this.backupProjectIndex, this.backupPermissionIndex).createPermissionSummary().isAdmin();
    }
}

