/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.blacklisting.EFindingBlacklistUpdateType;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class FindingBlacklistEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FINDING_ID_PROPERTY = "findingId";
    private static final String FINDING_MESSAGE_PROPERTY = "findingMessage";
    private static final String USER_PROPERTY = "user";
    private static final String TYPE_PROPERTY = "type";
    private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
    private static final String BLACKLIST_INFO_PROPERTY = "blacklistInfo";
    @JsonProperty(value="findingId")
    private final String findingId;
    @JsonProperty(value="findingMessage")
    private final @Nullable String findingMessage;
    @JsonProperty(value="user")
    private final String user;
    @JsonProperty(value="type")
    private final EFindingBlacklistUpdateType type;
    @JsonProperty(value="uniformPath")
    private final String uniformPath;
    @JsonProperty(value="blacklistInfo")
    private final @Nullable FindingBlacklistInfo blacklistInfo;

    @JsonCreator
    private FindingBlacklistEvent(@JsonProperty(value="findingId") String findingId, @JsonProperty(value="findingMessage") @Nullable String findingMessage, @JsonProperty(value="type") EFindingBlacklistUpdateType type, @JsonProperty(value="user") String user, @JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="blacklistInfo") @Nullable FindingBlacklistInfo blacklistInfo) {
        this.findingId = findingId;
        this.findingMessage = findingMessage;
        this.type = type;
        this.user = user;
        this.uniformPath = uniformPath;
        this.blacklistInfo = blacklistInfo;
    }

    public static FindingBlacklistEvent createRemovedEvent(String blacklistedFindingId, String findingMessage, String user, String uniformPath, FindingBlacklistInfo blacklistInfo) {
        return new FindingBlacklistEvent(blacklistedFindingId, findingMessage, EFindingBlacklistUpdateType.REMOVE, user, uniformPath, blacklistInfo);
    }

    public static FindingBlacklistEvent createAddedEvent(String blacklistedFindingId, String findingMessage, String user, String uniformPath, FindingBlacklistInfo blacklistInfo) {
        CCSMAssert.isNotNull((Object)blacklistInfo);
        return new FindingBlacklistEvent(blacklistedFindingId, findingMessage, EFindingBlacklistUpdateType.ADD, user, uniformPath, blacklistInfo);
    }

    public static FindingBlacklistEvent fromString(String serialized) throws StorageException {
        try {
            return (FindingBlacklistEvent)JsonUtils.deserializeFromJsonWithNullCheck((String)serialized, FindingBlacklistEvent.class);
        }
        catch (ConQATException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public String serialize() {
        return JsonUtils.serializeToJSON((Object)this);
    }

    public String getFindingId() {
        return this.findingId;
    }

    public @Nullable String getFindingMessage() {
        return this.findingMessage;
    }

    public EFindingBlacklistUpdateType getType() {
        return this.type;
    }

    public String getUser() {
        return this.user;
    }

    public Optional<FindingBlacklistInfo> getBlacklistInfo() {
        return Optional.ofNullable(this.blacklistInfo);
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public String toString() {
        return this.getCommitMessage();
    }

    private String getFindingInfoForCommitMessages() {
        return Optional.ofNullable(this.getFindingMessage()).orElseGet(this::getFindingId);
    }

    public String getCommitMessage() {
        EFindingBlacklistType blacklistType = this.getBlacklistInfo().map(FindingBlacklistInfo::getType).orElse(EFindingBlacklistType.TOLERATION);
        String blacklistInfoTypeName = blacklistType.getReadableName();
        String suffix = ": " + this.getFindingInfoForCommitMessages();
        return switch (this.getExtendedType().ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> "Finding added to pending " + blacklistInfoTypeName + "s" + suffix + this.getBlacklistInfo().map(FindingBlacklistInfo::getRationale).filter(Predicate.not(StringUtils::isEmpty)).map(rationale -> ": " + rationale).orElse("");
            case 0 -> "Finding added to " + blacklistInfoTypeName + "s" + suffix + this.getBlacklistInfo().map(FindingBlacklistInfo::getRationale).filter(Predicate.not(StringUtils::isEmpty)).map(rationale -> ": " + rationale).orElse("");
            case 2 -> this.getPendingExclusionResolvedCommitMessage(blacklistType, suffix, true);
            case 3 -> this.getPendingExclusionResolvedCommitMessage(blacklistType, suffix, false);
            case 4 -> "Finding removed from " + blacklistInfoTypeName + "s" + suffix;
        };
    }

    private String getPendingExclusionResolvedCommitMessage(EFindingBlacklistType blacklistType, String suffix, boolean approved) {
        String prefix = switch (blacklistType) {
            default -> throw new MatchException(null, null);
            case EFindingBlacklistType.TOLERATION -> "Pending finding Toleration ";
            case EFindingBlacklistType.FALSE_POSITIVE -> "Pending finding exclusion as False Positive ";
        };
        String operation = approved ? "approved" : "rejected";
        String rationaleSuffix = this.getBlacklistInfo().map(FindingBlacklistInfo::getApprovalState).map(FindingBlacklistInfo.IApprovalState.IResolvedState.class::cast).map(FindingBlacklistInfo.IApprovalState.IResolvedState::rationale).filter(Predicate.not(StringUtils::isEmpty)).map(rationale -> ": " + rationale).orElse("");
        return prefix + operation + suffix + rationaleSuffix;
    }

    @JsonGetter(value="extendedType")
    public EExtendedBlacklistChangeType getExtendedType() {
        EExtendedBlacklistChangeType eExtendedBlacklistChangeType;
        if (this.type == EFindingBlacklistUpdateType.REMOVE) {
            if (this.blacklistInfo != null && this.blacklistInfo.getApprovalState() instanceof FindingBlacklistInfo.IApprovalState.Rejected) {
                return EExtendedBlacklistChangeType.REJECTION;
            }
            return EExtendedBlacklistChangeType.REMOVAL;
        }
        if (this.blacklistInfo == null) {
            return EExtendedBlacklistChangeType.EXCLUSION;
        }
        FindingBlacklistInfo.IApprovalState iApprovalState = this.blacklistInfo.getApprovalState();
        Objects.requireNonNull(iApprovalState);
        FindingBlacklistInfo.IApprovalState iApprovalState2 = iApprovalState;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FindingBlacklistInfo.IApprovalState.Pending.class, FindingBlacklistInfo.IApprovalState.Rejected.class, FindingBlacklistInfo.IApprovalState.Approved.class, FindingBlacklistInfo.IApprovalState.Approved.class}, (FindingBlacklistInfo.IApprovalState)iApprovalState2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    FindingBlacklistInfo.IApprovalState.Pending ignored = (FindingBlacklistInfo.IApprovalState.Pending)iApprovalState2;
                    eExtendedBlacklistChangeType = EExtendedBlacklistChangeType.PENDING_EXCLUSION;
                    break block6;
                }
                case 1: {
                    FindingBlacklistInfo.IApprovalState.Rejected ignored = (FindingBlacklistInfo.IApprovalState.Rejected)iApprovalState2;
                    eExtendedBlacklistChangeType = EExtendedBlacklistChangeType.REJECTION;
                    break block6;
                }
                case 2: {
                    FindingBlacklistInfo.IApprovalState.Approved approved = (FindingBlacklistInfo.IApprovalState.Approved)iApprovalState2;
                    if (approved.at() != this.blacklistInfo.getTimestamp()) {
                        n = 3;
                        continue block6;
                    }
                    eExtendedBlacklistChangeType = EExtendedBlacklistChangeType.EXCLUSION;
                    break block6;
                }
                case 3: {
                    FindingBlacklistInfo.IApprovalState.Approved ignored = (FindingBlacklistInfo.IApprovalState.Approved)iApprovalState2;
                    eExtendedBlacklistChangeType = EExtendedBlacklistChangeType.APPROVAL;
                    break block6;
                }
            }
            break;
        }
        return eExtendedBlacklistChangeType;
    }

    @ExportToTypeScript
    @IndexValueClass(containedInBackup=true)
    public static enum EExtendedBlacklistChangeType {
        EXCLUSION("Exclusion"){

            @Override
            public String getRationale(FindingBlacklistInfo info) {
                return info.getRationale();
            }
        }
        ,
        PENDING_EXCLUSION("Pending Exclusion"){

            @Override
            public String getRationale(FindingBlacklistInfo info) {
                return info.getRationale();
            }
        }
        ,
        APPROVAL("Approval"){

            @Override
            public String getRationale(FindingBlacklistInfo info) {
                return ((FindingBlacklistInfo.IApprovalState.Approved)info.getApprovalState()).rationale();
            }
        }
        ,
        REJECTION("Rejection"){

            @Override
            public String getRationale(FindingBlacklistInfo info) {
                return ((FindingBlacklistInfo.IApprovalState.Rejected)info.getApprovalState()).rationale();
            }
        }
        ,
        REMOVAL("Removal"){

            @Override
            public String getRationale(FindingBlacklistInfo info) {
                return "";
            }
        };

        private final String humanReadable;

        private EExtendedBlacklistChangeType(String humanReadable) {
            this.humanReadable = humanReadable;
        }

        public String getHumanReadable() {
            return this.humanReadable;
        }

        public abstract String getRationale(FindingBlacklistInfo var1);
    }
}

