/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.check;

import com.teamscale.index.check.CheckPhaseResultDependencyIndex;
import com.teamscale.index.check.CheckPhaseResultIndex;
import com.teamscale.index.check.InvertedCheckPhaseResultIndex;
import com.teamscale.index.check.TokenElementContext;
import com.teamscale.index.resource.element_details.PartOfTestCodeDetail;
import eu.cqse.check.framework.core.CheckFindingBuilderBase;
import eu.cqse.check.framework.core.CheckInfo;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.LocationBuilderBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ListMap;

public class CheckContext
extends TokenElementContext
implements ICheckContext {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ListMap<String, IndexFinding> uniformPathToFindings = new ListMap();
    private CheckInfo checkInfo = null;
    private final CheckPhaseResultIndex resultIndex;
    private final InvertedCheckPhaseResultIndex invertedResultIndex;
    private final Map<Class<? extends IGlobalExtractionPhase<?, ?>>, Set<String>> queriedOtherUniformPaths = new HashMap();
    private final Map<Class<? extends IGlobalExtractionPhase<?, ?>>, Set<String>> queriedValues = new HashMap();

    public CheckContext(CheckPhaseResultIndex resultIndex, InvertedCheckPhaseResultIndex invertedResultIndex) {
        this.resultIndex = resultIndex;
        this.invertedResultIndex = invertedResultIndex;
    }

    public void setCheckInfo(CheckInfo checkInfo) {
        this.checkInfo = Objects.requireNonNull(checkInfo);
    }

    public String getCheckId() {
        if (this.checkInfo != null) {
            return this.checkInfo.getId();
        }
        return null;
    }

    private void storeFinding(IndexFinding finding) {
        CCSMAssert.isTrue((boolean)finding.getLocation().getUniformPath().equals(this.getUniformPath()), (String)("Check " + this.checkInfo.getId() + " is executed for " + this.getUniformPath() + " but tries to generate finding for " + finding.getLocation().getUniformPath()));
        this.uniformPathToFindings.add((Object)this.getUniformPath(), (Object)finding);
    }

    public void createFindingForOffsets(String message, int startOffset, int endOffset, ECodeViewOption.ETextViewOption view) {
        Optional location = this.buildLocation().betweenOffsets(startOffset, endOffset, view);
        this.buildFinding(message, location.orElse(null)).createAndStore();
    }

    public ListMap<String, IndexFinding> getUniformPathToFindings() {
        return this.uniformPathToFindings;
    }

    public <T extends IExtractedValue<D>, D extends Serializable> Function<String, List<T>> accessPhaseResult(Class<? extends IGlobalExtractionPhase<T, D>> phaseClass) {
        return uniformPath -> this.readPhaseValues(phaseClass, (String)uniformPath);
    }

    private <T extends IExtractedValue<D>, D extends Serializable> List<T> readPhaseValues(Class<? extends IGlobalExtractionPhase<T, D>> phaseClass, String uniformPath) {
        if (!this.getUniformPath().equals(uniformPath)) {
            this.queriedOtherUniformPaths.computeIfAbsent(phaseClass, x -> new HashSet()).add(uniformPath);
        }
        try {
            return this.resultIndex.getValuesCached(phaseClass, uniformPath);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to read phase values for " + phaseClass.getSimpleName() + " and " + uniformPath, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public <T extends IExtractedValue<D>, D extends Serializable> Function<String, List<T>> accessPhaseInvertedResult(Class<? extends IGlobalExtractionPhase<T, D>> phaseClass) {
        return value -> this.readInvertedPhaseValues(phaseClass, (String)value);
    }

    private <T extends IExtractedValue<D>, D extends Serializable> List<T> readInvertedPhaseValues(Class<? extends IGlobalExtractionPhase<T, D>> phaseClass, String value) {
        this.queriedValues.computeIfAbsent(phaseClass, x -> new HashSet()).add(value);
        try {
            return this.invertedResultIndex.getValuesCached(phaseClass, value);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to read inverted phase values for " + phaseClass.getSimpleName() + " and " + value, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public <T extends IExtractedValue<D>, D extends Serializable> List<String> listAllPhaseValues(Class<? extends IGlobalExtractionPhase<T, D>> phaseClass) {
        try {
            List<String> allKeys = this.invertedResultIndex.getAllKeysCached(phaseClass);
            this.queriedValues.computeIfAbsent(phaseClass, x -> new HashSet()).addAll(allKeys);
            return allKeys;
        }
        catch (StorageException e) {
            LOGGER.error("Failed to read all phase values for " + phaseClass.getSimpleName(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    void persistAndResetPhaseQueryInformation(CheckPhaseResultDependencyIndex phaseResultDependencyIndex) throws StorageException {
        phaseResultDependencyIndex.updateDependencies(this.getUniformPath(), this.queriedOtherUniformPaths, this.queriedValues);
        this.queriedOtherUniformPaths.clear();
        this.queriedValues.clear();
    }

    public CheckFindingBuilderBase buildFinding(String message, ElementLocation location) {
        CheckFindingBuilderBase findingBuilder = new CheckFindingBuilderBase(this, this.checkInfo.getId(), this.checkInfo.getGroupName(), message, location){
            final /* synthetic */ CheckContext this$0;
            {
                CheckContext checkContext = this$0;
                Objects.requireNonNull(checkContext);
                this.this$0 = checkContext;
                super(checkId, category, message, location);
            }

            public void storeFinding(IndexFinding finding) {
                this.this$0.storeFinding(finding);
            }
        };
        FindingPropertyList findingPropertyList = new FindingPropertyList();
        findingBuilder.addFindingProperties(findingPropertyList);
        findingBuilder.setGuidelineMapping(this.checkInfo.getGuidelineMappingForLanguage(this.getLanguage()));
        return findingBuilder;
    }

    public LocationBuilderBase buildLocation() {
        return new LocationBuilderBase(this.getUniformPath(), this.offsetTransformer, this.unfilteredLineOffsetConverter, this.filteredLineOffsetConverter, this.getLanguage());
    }

    public boolean isTestCode() {
        return this.getBasicTokenElement().getFirstDetailOfType(PartOfTestCodeDetail.class).isPresent();
    }
}

