/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.check;

import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.IndexBasedAnalysisConstants;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.check.TokenElementContext;
import com.teamscale.index.dependencies.simulink.DataDictionaryLoader;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.ContentIndexInputAnalysisStepBase;
import com.teamscale.index.resource.PreprocessorExpansionsIndex;
import com.teamscale.index.resource.SimulinkDataDictionaryIndex;
import com.teamscale.index.resource.SimulinkSignalLabelIndex;
import com.teamscale.index.simulink.signal_type.SimulinkOutputDataTypeIndex;
import com.teamscale.index.simulink.signal_type.dimensions.SimulinkDimensionalityIndex;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.WiaUtils;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.util.SimulinkCheckUtils;
import eu.cqse.check.util.clang.ClangUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkDataDictionaryParser;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.SimulinkResolvedDimensions;
import org.conqat.lib.simulink.util.SimulinkUtils;

public abstract class CheckProcessorBase
extends ContentIndexInputAnalysisStepBase {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected BinaryElementIndex binaryElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected SimulinkOutputDataTypeIndex simulinkOutputDataTypeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected SimulinkDimensionalityIndex simulinkDimensionalityIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected SimulinkSignalLabelIndex simulinkSignalLabelIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected SimulinkDataDictionaryIndex simulinkDataDictionaryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected PreprocessorExpansionsIndex preprocessorExpansionsIndex;
    @DeltaSource(value=PreprocessorExpansionsIndex.class)
    protected KeyDelta preprocessorExpansionsIndexDelta;

    protected Set<String> determineTokenElementsToAnalyze(EnumSet<ECheckParameter> parameters) throws StorageException {
        HashSet<String> uniformPathsToAnalyze = new HashSet<String>(this.contentDelta.getAddedOrChangedKeysAsStrings());
        if (parameters.contains(ECheckParameter.PREPROCESSOR_EXPANSIONS)) {
            uniformPathsToAnalyze.addAll(this.preprocessorExpansionsIndexDelta.getAddedOrChangedKeysAsStrings());
            HashSet existingFilesWhoseExpansionsAreRemoved = CollectionUtils.differenceSet((Collection)this.preprocessorExpansionsIndexDelta.getDeletedKeysAsStrings(), (Collection[])new Collection[]{this.contentDelta.getDeletedKeysAsStrings()});
            uniformPathsToAnalyze.addAll(existingFilesWhoseExpansionsAreRemoved);
        }
        return uniformPathsToAnalyze;
    }

    protected List<String> determineDeletedElements() {
        return this.contentDelta.getDeletedKeysAsStrings();
    }

    protected void prepareContext(TokenElementContext context, Set<ECheckParameter> requiredParameters) throws ConQATException {
        if (requiredParameters.contains(ECheckParameter.ABSTRACT_SYNTAX_TREE)) {
            context.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED);
        }
        if (requiredParameters.contains(ECheckParameter.TYPE_RESOLUTION)) {
            context.getTypeResolution(ECodeViewOption.FILTERED_PREPROCESSED);
        }
        if (requiredParameters.contains(ECheckParameter.CLANG) && ClangUtils.CLANG_ENABLED_LANGUAGES.contains(context.getLanguage()) && !EFeatureToggle.DISABLE_CLANG_JNI_CHECKS.isEnabled()) {
            context.ensureClangTranslationUnitWrapperInitialized();
        }
        if (context.getLanguage() == ELanguage.SIMULINK) {
            this.createSimulinkModel(context, this.binaryElementIndex.getContent(context.getUniformPath()));
            CheckProcessorBase.createSimulinkDataDictionary(context, this.binaryElementIndex.getContent(context.getUniformPath()));
        }
        if (WiaUtils.isWiaEnabledLanguage((ELanguage)context.getLanguage())) {
            this.prepareWiaContext(context);
        }
        if (requiredParameters.contains(ECheckParameter.PREPROCESSOR_EXPANSIONS)) {
            CheckProcessorBase.loadPreprocessorExpansions(this.preprocessorExpansionsIndex, context);
        }
    }

    private static void loadPreprocessorExpansions(PreprocessorExpansionsIndex preprocessorExpansionsIndex, TokenElementContext context) throws StorageException {
        String uniformPath = context.getUniformPath();
        List<PreprocessorTokenReplacement> expansions = preprocessorExpansionsIndex.getExpansionsForUniformPath(uniformPath);
        context.setPreprocessorExpansions(expansions);
    }

    private void prepareWiaContext(TokenElementContext context) {
        if (!context.hasWorkItemAccessor()) {
            context.setWorkItemAccessor(this::getWorkItem);
        }
    }

    private TeamscaleIssue getWorkItem(UniformPath uniformPath) throws CheckException {
        try {
            return (TeamscaleIssue)StorageUtils.deserialize((byte[])this.binaryElementIndex.getContent(uniformPath));
        }
        catch (StorageException e) {
            throw new CheckException("Unable to load TeamscaleIssue for uniform path: " + String.valueOf(uniformPath), (Exception)((Object)e));
        }
    }

    private static void createSimulinkDataDictionary(TokenElementContext context, byte[] value) throws ConQATException {
        Preconditions.checkArgument((context.getLanguage() == ELanguage.SIMULINK ? 1 : 0) != 0);
        if (context.getSimulinkContext().getSimulinkDataDictionaryForDictionaryFile().isPresent()) {
            return;
        }
        String uniformPath = context.getUniformPath();
        try {
            if (SimulinkUtils.isSimulinkDataDictionary((String)uniformPath)) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(value);
                SimulinkDataDictionaryParser parser = new SimulinkDataDictionaryParser((InputStream)inputStream, uniformPath);
                SimulinkDataDictionary dataDictionary = parser.parse();
                context.setSimulinkDataDictionary(dataDictionary);
            }
        }
        catch (IOException | SimulinkModelBuildingException e) {
            throw new ConQATException("Could not parse data dictionary " + uniformPath + ": " + e.getMessage(), e);
        }
    }

    private void createSimulinkModel(TokenElementContext context, byte[] binaryContent) throws ConQATException {
        Preconditions.checkArgument((context.getLanguage() == ELanguage.SIMULINK ? 1 : 0) != 0);
        if (context.getSimulinkContext().getSimulinkModelForModelFile().isPresent()) {
            return;
        }
        String uniformPath = context.getUniformPath();
        try {
            if (SimulinkUtils.isSimulinkModelPath((String)uniformPath)) {
                SimulinkModel simulinkModel = SimulinkCheckUtils.parseModelFromByteArrayWithoutRelatedModels((String)uniformPath, (byte[])binaryContent);
                context.setSimulinkModel(simulinkModel);
                DataDictionaryLoader dictionaryLoader = new DataDictionaryLoader(this.binaryElementIndex, this.simulinkDataDictionaryIndex);
                context.setReferencedSimulinkDataDictionaries(dictionaryLoader.getReferencedDataDictionariesSorted(simulinkModel));
                SimulinkResolvedDataTypes dataTypes = this.simulinkOutputDataTypeIndex.getResolvedDataTypes(uniformPath);
                context.setSimulinkOutputDataTypes(dataTypes);
                SimulinkResolvedDimensions dimensions = this.simulinkDimensionalityIndex.getSignalDimensions(uniformPath);
                context.setSimulinkDimensions(dimensions);
                SimulinkPropagatedSignalLabels signalLabels = this.simulinkSignalLabelIndex.getSignalLabels(uniformPath);
                context.setSimulinkSignalLabels(signalLabels);
            }
        }
        catch (IOException | SimulinkModelBuildingException e) {
            throw new ConQATException("Could not parse model " + uniformPath + ": " + e.getMessage(), e);
        }
    }

    protected static boolean elementIsHandledByCheckFramework(BasicTokenElementInfo element) {
        String uniformPath = element.getUniformPath();
        if (UniformPathUtils.isArchitectureFile((String)uniformPath)) {
            return false;
        }
        ELanguage language = element.getLanguage();
        return IndexBasedAnalysisConstants.containsCodeLanguage(Collections.singleton(language)) || language == ELanguage.SIMULINK || WiaUtils.isWiaEnabledLanguage((ELanguage)language);
    }

    protected static boolean clangParserInitializationFailed(Set<ECheckParameter> checkParameters, TokenElementContext context) {
        return checkParameters.contains(ECheckParameter.CLANG) && ClangUtils.CLANG_ENABLED_LANGUAGES.contains(context.getLanguage()) && !context.clangTranslationUnitWrapperIsInitialized();
    }
}

