/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change;

import com.google.common.base.Preconditions;
import com.teamscale.index.code_change.MatchRegion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.Nullable;

public class MatchRegionCloneStore {
    private static final String KEY_SEPARATOR = "-_##-##_-";
    private static final int MAX_DISTANCE_THRESHOLD = 4;
    private final Map<String, List<RegionWithFrequency>> regionsStore = new HashMap<String, List<RegionWithFrequency>>();

    public void insertRegions(String branch, String parentBranch, List<MatchRegion> regions) {
        Preconditions.checkState((boolean)regions.stream().allMatch(MatchRegion::hasContent), (Object)"All added regions must have content!");
        List indexAccessors = CollectionUtils.map(regions, region -> new IndexAccessor(this, branch, parentBranch, (MatchRegion)((Object)region)));
        List<String> keys = indexAccessors.stream().flatMap(indexAccessor -> indexAccessor.keysToLoad.stream().distinct()).collect(Collectors.toList());
        Map<String, List<RegionWithFrequency>> regionFrequencyCache = this.loadValuesAsMap(keys);
        PairList allKeysAndValues = new PairList();
        for (IndexAccessor indexAccessor2 : indexAccessors) {
            allKeysAndValues.addAll(indexAccessor2.extendFrequencyCache(regionFrequencyCache));
        }
        allKeysAndValues.forEach(this.regionsStore::put);
    }

    private List<List<RegionWithFrequency>> loadValues(List<String> keysToLoad) {
        return keysToLoad.stream().map(this.regionsStore::get).toList();
    }

    private Map<String, List<RegionWithFrequency>> loadValuesAsMap(List<String> keysToLoad) {
        List<List<RegionWithFrequency>> regionsWithFrequencies = this.loadValues(keysToLoad);
        return CollectionUtils.zipAsMap(keysToLoad, regionsWithFrequencies);
    }

    public void removeRegion(String branch, String parentBranch, MatchRegion region) {
        Preconditions.checkState((boolean)region.hasContent(), (Object)"Region must have content!");
        new IndexAccessor(this, branch, parentBranch, region).remove();
    }

    public String getBestMatchingRegionName(String branch, String parentBranch, MatchRegion region, Map<String, MatchRegion> oldRegionsByQualifiedId) {
        Preconditions.checkState((boolean)region.hasContent(), (Object)"Region must have content!");
        return new IndexAccessor(this, branch, parentBranch, region).getBestMatchingRegionName(oldRegionsByQualifiedId);
    }

    private static String makeKey(String branchName, String dataSpecificKey) {
        return branchName + KEY_SEPARATOR + dataSpecificKey;
    }

    private class IndexAccessor {
        private final int startOffset;
        private final int endOffset;
        private final String simpleName;
        private final CounterSet<Long> statementHashFrequencies;
        private final List<Long> statementHashes;
        private final List<String> keysToLoad;
        private final String qualifiedId;
        private final String uniformPath;
        final /* synthetic */ MatchRegionCloneStore this$0;

        private IndexAccessor(MatchRegionCloneStore matchRegionCloneStore, String branch, String parentBranch, MatchRegion region) {
            MatchRegionCloneStore matchRegionCloneStore2 = matchRegionCloneStore;
            Objects.requireNonNull(matchRegionCloneStore2);
            this.this$0 = matchRegionCloneStore2;
            this.simpleName = region.getSimpleName();
            this.statementHashFrequencies = region.getContent().getStatementHashes();
            this.startOffset = region.getStart();
            this.endOffset = region.getEnd();
            this.statementHashes = new ArrayList<Long>((Collection<Long>)this.statementHashFrequencies.getKeys());
            this.keysToLoad = IndexAccessor.getKeysToLoad(branch, parentBranch, this.statementHashes);
            this.qualifiedId = region.getQualifiedId();
            this.uniformPath = region.getUniformPath();
        }

        private static boolean setRegionWithFrequency(RegionWithFrequency newRegionWithFrequency, List<RegionWithFrequency> regionsWithFrequencies) {
            int index = Collections.binarySearch(regionsWithFrequencies, newRegionWithFrequency);
            if (index >= 0) {
                RegionWithFrequency oldRegionWithFrequency = regionsWithFrequencies.set(index, newRegionWithFrequency);
                return newRegionWithFrequency.statementFrequency != oldRegionWithFrequency.statementFrequency;
            }
            int insertionPoint = -index - 1;
            regionsWithFrequencies.add(insertionPoint, newRegionWithFrequency);
            return true;
        }

        private static String buildBranchPrefix(String branch, String parentBranch) {
            return MatchRegionCloneStore.makeKey(branch, parentBranch);
        }

        private static List<String> getKeysToLoad(String branch, String parentBranch, List<Long> statementHashes) {
            String branchPrefix = IndexAccessor.buildBranchPrefix(branch, parentBranch);
            return CollectionUtils.map(statementHashes, statementHash -> branchPrefix + Long.toHexString(statementHash));
        }

        private PairList<String, List<RegionWithFrequency>> extendFrequencyCache(Map<String, List<RegionWithFrequency>> regionFrequencyCache) {
            PairList newKeysAndValues = new PairList(this.keysToLoad.size());
            List values = CollectionUtils.map(this.keysToLoad, regionFrequencyCache::get);
            for (int i = 0; i < this.statementHashes.size(); ++i) {
                RegionWithFrequency regionWithFrequency;
                Long statementHash = this.statementHashes.get(i);
                String key = this.keysToLoad.get(i);
                int statementFrequency = this.statementHashFrequencies.getValue((Object)statementHash);
                ArrayList<RegionWithFrequency> regionsWithFrequencies = (ArrayList<RegionWithFrequency>)values.get(i);
                if (regionsWithFrequencies == null) {
                    regionsWithFrequencies = new ArrayList<RegionWithFrequency>();
                }
                if (!IndexAccessor.setRegionWithFrequency(regionWithFrequency = new RegionWithFrequency(this.qualifiedId, statementFrequency), regionsWithFrequencies)) continue;
                newKeysAndValues.add((Object)key, regionsWithFrequencies);
                regionFrequencyCache.put(key, regionsWithFrequencies);
            }
            return newKeysAndValues;
        }

        private void remove() {
            ArrayList<String> keysToRemove = new ArrayList<String>();
            PairList newKeysAndValues = new PairList(this.keysToLoad.size());
            List<List<RegionWithFrequency>> values = this.this$0.loadValues(this.keysToLoad);
            for (int i = 0; i < this.statementHashes.size(); ++i) {
                List<RegionWithFrequency> newRegionsWithFrequencies = values.get(i);
                if (newRegionsWithFrequencies == null) continue;
                String key = this.keysToLoad.get(i);
                int index = Collections.binarySearch(newRegionsWithFrequencies, new RegionWithFrequency(this.qualifiedId, 0));
                if (index < 0) continue;
                newRegionsWithFrequencies.remove(index);
                if (newRegionsWithFrequencies.isEmpty()) {
                    keysToRemove.add(key);
                    continue;
                }
                newKeysAndValues.add((Object)key, newRegionsWithFrequencies);
            }
            newKeysAndValues.forEach(this.this$0.regionsStore::put);
            keysToRemove.forEach(this.this$0.regionsStore::remove);
        }

        private @Nullable String getBestMatchingRegionName(Map<String, MatchRegion> oldRegionsByQualifiedId) {
            List<List<RegionWithFrequency>> values = this.this$0.loadValues(this.keysToLoad);
            PenaltyCalculator penaltyCalculator = new PenaltyCalculator();
            int accumulatedPenalty = 0;
            for (int i = 0; i < this.statementHashes.size(); ++i) {
                Long statementHashKey = this.statementHashes.get(i);
                int expectedFrequency = this.statementHashFrequencies.getValue((Object)statementHashKey);
                penaltyCalculator.setParameters(expectedFrequency, accumulatedPenalty);
                accumulatedPenalty += expectedFrequency;
                List<RegionWithFrequency> newRegionsWithFrequencies = values.get(i);
                if (newRegionsWithFrequencies != null) {
                    newRegionsWithFrequencies.forEach(penaltyCalculator::consume);
                }
                penaltyCalculator.updatePenaltiesAndReset();
            }
            penaltyCalculator.incrementPenalties();
            penaltyCalculator.applyLengthDifferencePenalty(this.statementHashFrequencies.getKeys().size(), this.simpleName, this.uniformPath, oldRegionsByQualifiedId);
            List<String> bestMatchingOldRegions = penaltyCalculator.getBestValidMatches(this.statementHashFrequencies.getKeys().size());
            return this.selectBestCandidate(oldRegionsByQualifiedId, bestMatchingOldRegions);
        }

        private @Nullable String selectBestCandidate(Map<String, MatchRegion> oldRegionsByQualifiedId, List<String> bestMatchingOldRegions) {
            if (bestMatchingOldRegions.size() == 1) {
                return bestMatchingOldRegions.getFirst();
            }
            String bestMatchingOldRegion = null;
            int bestCandidateValue = 0;
            for (String possibleBest : bestMatchingOldRegions) {
                int currentCandidateValue = 0;
                MatchRegion oldRegion = oldRegionsByQualifiedId.get(possibleBest);
                if (oldRegion == null) continue;
                if (oldRegion.getStart() == this.startOffset && oldRegion.getEnd() == this.endOffset) {
                    ++currentCandidateValue;
                }
                if (oldRegion.getSimpleName().equalsIgnoreCase(this.simpleName)) {
                    ++currentCandidateValue;
                }
                if (currentCandidateValue <= bestCandidateValue) continue;
                bestCandidateValue = currentCandidateValue;
                bestMatchingOldRegion = possibleBest;
            }
            return bestMatchingOldRegion;
        }
    }

    private static class PenaltyCalculator {
        private static final Logger LOGGER = LogManager.getLogger();
        private final CounterSet<String> penalty = new CounterSet();
        private int expectedFrequency;
        private int accumulatedPenalty;
        private final Map<String, Integer> accumulatedPenaltyPerCloneCandidate = new HashMap<String, Integer>();
        private final Map<String, Boolean> callFlagPerCloneCandidate = new HashMap<String, Boolean>();

        private PenaltyCalculator() {
        }

        public void setParameters(int expectedFrequency, int accumulatedPenalty) {
            this.expectedFrequency = expectedFrequency;
            this.accumulatedPenalty = accumulatedPenalty;
        }

        public void consume(RegionWithFrequency regionWithFrequency) {
            String name = regionWithFrequency.qualifiedRegionId;
            int error = Math.abs(regionWithFrequency.statementFrequency - this.expectedFrequency);
            if (this.penalty.contains((Object)name)) {
                this.penalty.inc((Object)name, this.accumulatedPenaltyPerCloneCandidate.get(name).intValue());
                this.accumulatedPenaltyPerCloneCandidate.put(name, 0);
                this.callFlagPerCloneCandidate.put(name, true);
            } else if ((error += this.accumulatedPenalty) <= 4) {
                this.penalty.inc((Object)name, error);
                this.accumulatedPenaltyPerCloneCandidate.put(name, 0);
                this.callFlagPerCloneCandidate.put(name, true);
            }
        }

        public List<String> getBestValidMatches(int regionStatementCount) {
            String key;
            ArrayList<String> bestNames = new ArrayList<String>();
            int penaltyThreshold = regionStatementCount < 2 ? 1 : regionStatementCount / 2;
            List keysByPenaltyAscending = this.penalty.getKeysByValueAscending();
            if (keysByPenaltyAscending.isEmpty()) {
                return bestNames;
            }
            int bestPenalty = this.penalty.getValue((Object)((String)keysByPenaltyAscending.getFirst()));
            if (bestPenalty >= penaltyThreshold) {
                return bestNames;
            }
            Iterator iterator = keysByPenaltyAscending.iterator();
            while (iterator.hasNext() && this.penalty.getValue((Object)(key = (String)iterator.next())) <= bestPenalty) {
                bestNames.add(key);
            }
            return bestNames;
        }

        public void incrementPenalties() {
            this.accumulatedPenaltyPerCloneCandidate.keySet().forEach(candidate -> this.penalty.inc(candidate, this.accumulatedPenaltyPerCloneCandidate.get(candidate).intValue()));
        }

        public void applyLengthDifferencePenalty(int newRegionStatementCount, String newRegionSimpleName, String newRegionUniformPath, Map<String, MatchRegion> oldRegionsByQualifiedId) {
            for (String candidateId : this.penalty.getKeys()) {
                int oldRegionStatementCount;
                int lengthDifference;
                MatchRegion oldRegion = oldRegionsByQualifiedId.get(candidateId);
                if (oldRegion == null || !oldRegion.hasContent() || oldRegion.getSimpleName().equals(newRegionSimpleName) || oldRegion.getUniformPath().equals(newRegionUniformPath) || (lengthDifference = Math.abs((oldRegionStatementCount = oldRegion.getContent().getStatementHashes().getKeys().size()) - newRegionStatementCount)) <= 0) continue;
                LOGGER.debug("Applying length difference ({} statements) penalty for new method '{}' and old method '{}'. The methods won't be matched based on similarity.", (Object)lengthDifference, (Object)(newRegionUniformPath + "/" + newRegionSimpleName), (Object)(oldRegion.getUniformPath() + "/" + oldRegion.getSimpleName()));
                this.penalty.inc((Object)candidateId, 0x3FFFFFFF);
            }
        }

        public void updatePenaltiesAndReset() {
            this.callFlagPerCloneCandidate.entrySet().forEach(entry -> {
                if (!((Boolean)entry.getValue()).booleanValue()) {
                    this.accumulatedPenaltyPerCloneCandidate.put((String)entry.getKey(), this.accumulatedPenaltyPerCloneCandidate.get(entry.getKey()) + this.expectedFrequency);
                }
                entry.setValue(false);
            });
        }
    }

    private record RegionWithFrequency(String qualifiedRegionId, int statementFrequency) implements Serializable,
    Comparable<RegionWithFrequency>
    {
        private static final long serialVersionUID = 1L;

        @Override
        public int compareTo(RegionWithFrequency other) {
            return this.qualifiedRegionId.compareTo(other.qualifiedRegionId);
        }
    }
}

