/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change;

import com.google.common.collect.Iterables;
import com.teamscale.index.code_change.MatchRegion;
import com.teamscale.index.code_change.MatchRegionCloneStore;
import com.teamscale.index.code_change.MethodMatchRegion;
import com.teamscale.index.code_change.MethodRegionMatching;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;

class RegionMatcher {
    private final MethodRegionMatching methodMatching;

    public RegionMatcher(MethodRegionMatching methodMatching) {
        this.methodMatching = methodMatching;
    }

    public void performMatching(MatchRegionCloneStore matchRegionCloneStore, String currentBranch, String parentBranch) throws StorageException {
        this.matchRegionsByQualifiedID();
        this.matchRegionsByContentHash();
        this.matchRegionsBySimilarity(matchRegionCloneStore, currentBranch, parentBranch);
        this.matchRegionsByQualifiedSimpleName();
    }

    private void matchRegionsByQualifiedID() {
        HashMap<String, MatchRegion> newRegionsByQualifiedId = new HashMap<String, MatchRegion>();
        HashMap<String, MatchRegion> newRegionsByQualifiedOriginId = new HashMap<String, MatchRegion>();
        for (MatchRegion newRegion : this.methodMatching.newRegions) {
            if (newRegion.isMatched()) continue;
            newRegionsByQualifiedId.put(newRegion.getQualifiedId(), newRegion);
            if (!newRegion.hasOriginInformation()) continue;
            newRegionsByQualifiedOriginId.put(newRegion.getOriginQualifiedId(), newRegion);
        }
        for (MatchRegion oldRegion : this.methodMatching.oldRegions) {
            RegionMatcher.matchOldRegion(oldRegion, newRegionsByQualifiedId, newRegionsByQualifiedOriginId);
        }
    }

    private static void matchOldRegion(MatchRegion oldRegion, Map<String, MatchRegion> newRegionsByQualifiedId, Map<String, MatchRegion> newRegionsByQualifiedOriginId) {
        if (oldRegion == null || oldRegion.isMatched()) {
            return;
        }
        if (RegionMatcher.matchRegion(newRegionsByQualifiedId, oldRegion, MatchRegion::getQualifiedId)) {
            return;
        }
        RegionMatcher.matchRegion(newRegionsByQualifiedOriginId, oldRegion, MatchRegion::getQualifiedId);
    }

    private static boolean matchRegion(Map<String, MatchRegion> newRegionsByProperty, MatchRegion region, Function<MatchRegion, String> propertyFunction) {
        MatchRegion potentialMatch = newRegionsByProperty.get(propertyFunction.apply(region));
        if (RegionMatcher.shouldMatch(region, potentialMatch)) {
            region.match(potentialMatch);
            return true;
        }
        return false;
    }

    private void matchRegionsByQualifiedSimpleName() {
        SetMap newRegionsByName = new SetMap();
        for (MatchRegion newRegion : this.methodMatching.newRegions) {
            if (newRegion.isMatched()) continue;
            newRegionsByName.add((Object)newRegion.getQualifiedSimpleName(), (Object)newRegion);
        }
        for (MatchRegion oldRegion : this.methodMatching.oldRegions) {
            if (oldRegion == null || oldRegion.isMatched()) continue;
            RegionMatcher.matchRegionByQualifiedSimpleName((SetMap<String, MatchRegion>)newRegionsByName, oldRegion);
        }
    }

    private static void matchRegionByQualifiedSimpleName(SetMap<String, MatchRegion> newRegionsByQualifiedSimpleName, MatchRegion region) {
        Set potentialMatches = (Set)newRegionsByQualifiedSimpleName.getCollectionOrEmpty((Object)region.getQualifiedSimpleName());
        if (potentialMatches.size() != 1) {
            return;
        }
        MatchRegion potentialMatch = (MatchRegion)((Object)Iterables.getOnlyElement((Iterable)potentialMatches));
        if (RegionMatcher.shouldMatch(region, potentialMatch)) {
            region.match(potentialMatch);
        }
    }

    private void matchRegionsByContentHash() {
        ListMap newRegionsByContentHash = new ListMap();
        for (MatchRegion newRegion : this.methodMatching.newRegions) {
            if (newRegion.isMatched()) continue;
            newRegionsByContentHash.add((Object)newRegion.getContentHash(), (Object)newRegion);
        }
        for (MatchRegion oldRegion : this.methodMatching.oldRegions) {
            MatchRegion potentialMatch;
            List potentialMatches;
            if (oldRegion.isMatched() || (potentialMatches = (List)newRegionsByContentHash.getCollection((Object)oldRegion.getContentHash())) == null || !RegionMatcher.shouldMatch(oldRegion, potentialMatch = potentialMatches.size() == 1 ? (MatchRegion)((Object)potentialMatches.getFirst()) : RegionMatcher.determineBestMatchByIdEditDistance(oldRegion, potentialMatches))) continue;
            oldRegion.match(potentialMatch);
        }
    }

    private static MatchRegion determineBestMatchByIdEditDistance(MatchRegion oldRegion, List<MatchRegion> potentialMatches) {
        MatchRegion potentialMatch = null;
        int bestDistance = Integer.MAX_VALUE;
        for (MatchRegion newRegion : potentialMatches) {
            int editDistance = StringUtils.editDistance((String)oldRegion.getId(), (String)newRegion.getId());
            if (editDistance >= bestDistance) continue;
            potentialMatch = newRegion;
            bestDistance = editDistance;
        }
        return potentialMatch;
    }

    private void matchRegionsBySimilarity(MatchRegionCloneStore matchRegionCloneStore, String currentBranch, String parentBranch) {
        if (this.methodMatching.newRegions.stream().allMatch(MatchRegion::isMatched)) {
            return;
        }
        List<MatchRegion> unmatchedOldRegions = this.methodMatching.oldRegions.stream().filter(oldRegion -> !oldRegion.isMatched() && oldRegion.hasContent()).collect(Collectors.toList());
        if (unmatchedOldRegions.isEmpty()) {
            return;
        }
        HashMap<String, MatchRegion> oldRegionsByQualifiedId = new HashMap<String, MatchRegion>();
        for (MatchRegion oldRegion2 : unmatchedOldRegions) {
            oldRegionsByQualifiedId.put(oldRegion2.getQualifiedId(), oldRegion2);
        }
        matchRegionCloneStore.insertRegions(currentBranch, parentBranch, unmatchedOldRegions);
        this.processNewRegions(matchRegionCloneStore, currentBranch, parentBranch, oldRegionsByQualifiedId);
        RegionMatcher.deleteMatchedRegions(matchRegionCloneStore, currentBranch, parentBranch, unmatchedOldRegions);
    }

    private void processNewRegions(MatchRegionCloneStore matchRegionCloneStore, String currentBranch, String parentBranch, Map<String, MatchRegion> oldRegionsByQualifiedId) {
        for (MatchRegion newRegion : this.methodMatching.newRegions) {
            MatchRegion potentialMatch;
            String oldRegionName;
            if (newRegion.isMatched() || (oldRegionName = matchRegionCloneStore.getBestMatchingRegionName(currentBranch, parentBranch, newRegion, oldRegionsByQualifiedId)) == null || !RegionMatcher.shouldMatch(newRegion, potentialMatch = oldRegionsByQualifiedId.get(oldRegionName))) continue;
            newRegion.match(potentialMatch);
        }
    }

    private static void deleteMatchedRegions(MatchRegionCloneStore matchRegionCloneStore, String currentBranch, String parentBranch, List<MatchRegion> regions) {
        for (MatchRegion region : regions) {
            if (!region.isMatched()) continue;
            matchRegionCloneStore.removeRegion(currentBranch, parentBranch, region);
        }
    }

    private static boolean shouldMatch(MatchRegion region, MatchRegion potentialMatch) {
        return potentialMatch != null && !potentialMatch.isMatched() && region.getLanguage() == potentialMatch.getLanguage() && region instanceof MethodMatchRegion == potentialMatch instanceof MethodMatchRegion;
    }
}

