/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.constraint;

import java.util.Collection;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

final class UnitListDelta {
    private int equals = 0;
    private int renames = 0;
    private int differences = 0;
    private double termEquality = 0.0;

    UnitListDelta() {
    }

    public int getEquals() {
        return this.equals;
    }

    public int getRenames() {
        return this.renames;
    }

    public int getDifferences() {
        return this.differences;
    }

    public int getMatches() {
        return this.getEquals() + this.getRenames();
    }

    public double getSimilarity() {
        return this.normalizeBySize(this.getMatches());
    }

    public double getEquality() {
        return this.normalizeBySize(this.getEquals());
    }

    private double normalizeBySize(int value) {
        int size = this.getSize();
        if (size == 0) {
            return 1.0;
        }
        return (double)value / (double)size;
    }

    public double getTermEquality() {
        return this.termEquality;
    }

    public int getSize() {
        return this.equals + this.renames + this.differences;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Similarity: " + this.getSimilarity() + StringUtils.LINE_SEPARATOR);
        result.append("Equality: " + this.getEquality() + StringUtils.LINE_SEPARATOR);
        result.append("Term equality: " + this.getTermEquality() + StringUtils.LINE_SEPARATOR);
        result.append("\tEquals: " + this.getEquals() + StringUtils.LINE_SEPARATOR);
        result.append("\tMatches: " + this.getMatches() + StringUtils.LINE_SEPARATOR);
        result.append("\tDifferences: " + this.getDifferences() + StringUtils.LINE_SEPARATOR);
        return result.toString();
    }

    void incEquals(int inc) {
        CCSMAssert.isTrue((inc > 0 ? 1 : 0) != 0, (String)"Increment must be positive!");
        this.equals += inc;
    }

    void incRenames(int inc) {
        CCSMAssert.isTrue((inc > 0 ? 1 : 0) != 0, (String)"Increment must be positive!");
        this.renames += inc;
    }

    void incDifferences(int inc) {
        CCSMAssert.isTrue((inc > 0 ? 1 : 0) != 0, (String)"Increment must be positive!");
        this.differences += inc;
    }

    void calculateAndSetTermEquality(Set<String> terms1, Set<String> terms2) {
        int intersectionSize = CollectionUtils.intersectionSet(terms1, (Collection[])new Collection[]{terms2}).size();
        int unionSize = terms1.size() + terms2.size() - intersectionSize;
        this.termEquality = unionSize == 0 ? 1.0 : (double)intersectionSize / (double)unionSize;
    }
}

