/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.CommentClassificationAnalysisBase;
import eu.cqse.check.framework.scanner.IToken;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocationUtils;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.LineOffsetConverter;

public abstract class CommentFindingAnalysisBase
extends CommentClassificationAnalysisBase {
    public static final String FINDING_CATEGORY = "Comments";
    private final String findingGroup;
    private final ListMap<String, IndexFinding> findings = new ListMap();

    protected CommentFindingAnalysisBase(String findingGroup) {
        this.findingGroup = findingGroup;
    }

    private TextRegionLocation createTextRegionLocation(Comment comment) {
        int position = comment.getTokenIndex();
        IToken token = (IToken)comment.getTokens().get(position);
        int startOffset = token.getOffset();
        int endOffset = token.getEndOffset();
        return TextRegionLocationUtils.createTextRegionLocationForFilteredOffsets((String)comment.getElementUniformPath(), (int)startOffset, (int)endOffset, (StringOffsetTransformer)this.offsetTransformer, (LineOffsetConverter)this.rawLineOffsetConverter);
    }

    private TextRegionLocation createTextLineLocation(Comment comment, int line) {
        TextRegionLocation regionLocation = this.createTextRegionLocation(comment);
        String[] commentLines = comment.getRawCommentText().split("\n");
        int lineOffset = 0;
        for (int i = 0; i < line; ++i) {
            lineOffset += commentLines[i].length() + 1;
        }
        int rawStartOffset = regionLocation.getRawStartOffset() + lineOffset;
        int rawLine = this.rawLineOffsetConverter.getLine(rawStartOffset);
        return new TextRegionLocation(comment.getElementUniformPath(), rawStartOffset, rawStartOffset + commentLines[line].length(), rawLine, rawLine);
    }

    private IndexFinding createFinding(Comment comment, String message, TextRegionLocation location) {
        IndexFinding finding = new IndexFinding(this.findingGroup, FINDING_CATEGORY, message, (ElementLocation)location);
        this.findings.add((Object)comment.getElementUniformPath(), (Object)finding);
        return finding;
    }

    protected IndexFinding createFindingForComment(Comment comment, String message) {
        return this.createFinding(comment, message, this.createTextRegionLocation(comment));
    }

    protected IndexFinding createFindingForComment(Comment comment, String message, int line) {
        return this.createFinding(comment, message, this.createTextLineLocation(comment, line));
    }

    public ListMap<String, IndexFinding> getFindings() {
        return this.findings;
    }
}

