/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis.classification;

import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.classification.CodeCharacteristicsChecker;
import com.teamscale.index.comment_analysis.classification.CodeRecognizer;
import com.teamscale.index.comment_analysis.classification.CoherenceUtils;
import com.teamscale.index.comment_analysis.identifier.EStopWords;
import com.teamscale.index.comment_analysis.utils.CommentTaggingUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public enum ECommentClassificationFeature {
    COPYRIGHT(true){

        @Override
        public Object extractFromComment(Comment comment) {
            return COPYRIGHT_PATTERN.matcher(comment.getText()).find();
        }
    }
    ,
    FOLLOWED_BY_TYPE(true){

        @Override
        public Object extractFromComment(Comment comment) {
            List<IToken> nextTokens = comment.getNextTokens(comment.getTokenIndex(), 10);
            return TokenStreamUtils.containsAny(nextTokens, (ETokenType[])TYPE_KEYWORD);
        }
    }
    ,
    DOC_COMMENT(true){

        @Override
        public Object extractFromComment(Comment comment) {
            return comment.getToken().getType() == ETokenType.DOCUMENTATION_COMMENT;
        }
    }
    ,
    CONTAINS_DOC_TAGS(true){

        @Override
        public Object extractFromComment(Comment comment) {
            return DOC_TAG_PATTERN.matcher(comment.getText()).find();
        }
    }
    ,
    AST_DEPTH(false){

        @Override
        public Object extractFromComment(Comment comment) {
            return (double)comment.getAstPosition().ordinal();
        }
    }
    ,
    DECLARATION_DISTANCE(false){

        @Override
        public Object extractFromComment(Comment comment) {
            return (double)comment.getMethodFinder().getDistanceToNextDefinition(comment.getTokenIndex());
        }
    }
    ,
    COMMENTED_CODE(false){

        @Override
        public Object extractFromComment(Comment comment) {
            ELanguage language = comment.getLanguage();
            String commentText = comment.getTextWithoutLinePrefix();
            if (language == ELanguage.JAVA || LanguageGroups.C_AND_DERIVATIVES.contains(language)) {
                commentText = AT_SEE_TAG_PATTERN.matcher(commentText).replaceAll("");
            }
            List lines = StringUtils.splitLinesAsList((String)commentText);
            int countCodeLines = 0;
            int overallCount = 0;
            for (String line : lines) {
                if (StringUtils.isEmpty((String)line)) continue;
                ++overallCount;
                if (!CodeRecognizer.isCodeLine(line, language)) continue;
                ++countCodeLines;
            }
            if (overallCount == 0 || COMMENTED_CODE_IGNORE_PATTERN.matcher(commentText).matches()) {
                return 0.0;
            }
            return (double)countCodeLines / (double)overallCount;
        }
    }
    ,
    DOUBLE_OPERATOR_COUNT(false){

        @Override
        public Object extractFromComment(Comment comment) {
            int count = 0;
            Matcher matcher = DOUBLE_OPERATOR_PATTERN.matcher(comment.getTextWithoutLinePrefix());
            while (matcher.find()) {
                ++count;
            }
            return (double)count;
        }
    }
    ,
    KEYWORD_COUNT(false){

        @Override
        public Object extractFromComment(Comment comment) {
            ELanguage language = comment.getToken().getLanguage();
            int count = 0;
            for (IToken token : ScannerUtils.getTokens((String)CommentTaggingUtils.removeCodeTagsFromComment(comment.getText()), (ELanguage)language, (String)comment.getToken().getOriginId())) {
                if (token.getType().getTokenClass() != ETokenType.ETokenClass.KEYWORD || EStopWords.ENGLISH.isStopWord(token.getText()) || CodeCharacteristicsChecker.COMMON_NL_TOKENS.contains(token.getType())) continue;
                ++count;
            }
            return (double)count;
        }
    }
    ,
    PUNCTATION_CHARACTERS(false){
        private static final Pattern NON_SPECIAL_CHARACTERS = Pattern.compile("[^!\"#$%&'()*+,\\-./;<=>?@\\[\\]^_`{|}~]");

        @Override
        public Object extractFromComment(Comment comment) {
            String commentString = StringUtils.removeWhitespace((String)comment.getText());
            double allCharacters = commentString.length();
            double specialCharacters = StringUtils.replaceAll((String)commentString, (Pattern)NON_SPECIAL_CHARACTERS, (String)"").length();
            return specialCharacters / allCharacters;
        }
    }
    ,
    CAMEL_CASED_WORDS(false){

        @Override
        public Object extractFromComment(Comment comment) {
            int count = 0;
            for (String word : CoherenceUtils.getCommentWords(comment.getText(), comment.getLanguage())) {
                if (!CAMEL_CASE_PATTERN.matcher(word).find()) continue;
                ++count;
            }
            return (double)count;
        }
    }
    ,
    CONTEXT_CORRELATION(true){

        @Override
        public Object extractFromComment(Comment comment) {
            return CoherenceUtils.hasContextCorrelation(comment);
        }
    }
    ,
    CHARACTER_REPETITION(false){

        @Override
        public Object extractFromComment(Comment comment) {
            char previous = '\u0000';
            int sameCount = 0;
            int maxSameCount = 0;
            for (char c : comment.getText().toCharArray()) {
                sameCount = c == previous ? ++sameCount : 1;
                previous = c;
                maxSameCount = Math.max(sameCount, maxSameCount);
            }
            return (double)maxSameCount;
        }
    }
    ,
    LENGTH(false){

        @Override
        public Object extractFromComment(Comment comment) {
            return (double)StringUtils.countLines((String)comment.getText());
        }
    }
    ,
    FOLLOWED_BY_COMMENT(true){

        @Override
        public Object extractFromComment(Comment comment) {
            List<IToken> nextTokens = comment.getNextTokens(comment.getTokenIndex(), 3);
            for (IToken token : nextTokens) {
                if (token.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT) continue;
                return true;
            }
            return false;
        }
    }
    ,
    IS_FIRST(true){

        @Override
        public Object extractFromComment(Comment comment) {
            for (int i = 0; i < comment.getTokenIndex(); ++i) {
                if (((IToken)comment.getTokens().get(i)).getType().getTokenClass() != ETokenType.ETokenClass.COMMENT) continue;
                return false;
            }
            return true;
        }
    }
    ,
    SECTION_LIKE(true){

        @Override
        public Object extractFromComment(Comment comment) {
            List<String> words = CoherenceUtils.getCommentWords(comment.getText(), comment.getLanguage());
            return words.isEmpty() || words.size() <= 3 && SECTION_END_WORDS.contains(((String)CollectionUtils.getLast(words)).toLowerCase()) || words.size() > 2 && SECTION_START_WORDS.contains(words.get(0).toLowerCase()) && words.get(1).equalsIgnoreCase("of");
        }
    };

    private static final Pattern COPYRIGHT_PATTERN;
    private static final Pattern DOC_TAG_PATTERN;
    private static final Pattern AT_SEE_TAG_PATTERN;
    private static final ETokenType[] TYPE_KEYWORD;
    private static final Pattern DOUBLE_OPERATOR_PATTERN;
    private static final Pattern CAMEL_CASE_PATTERN;
    private static final Pattern COMMENTED_CODE_IGNORE_PATTERN;
    private static final Set<String> SECTION_START_WORDS;
    private static final Set<String> SECTION_END_WORDS;
    private final boolean isBooleanFeature;

    private ECommentClassificationFeature(boolean isBooleanFeature) {
        this.isBooleanFeature = isBooleanFeature;
    }

    public boolean isBooleanFeature() {
        return this.isBooleanFeature;
    }

    public abstract Object extractFromComment(Comment var1);

    static {
        COPYRIGHT_PATTERN = Pattern.compile("copyright|license", 2);
        DOC_TAG_PATTERN = Pattern.compile("[@\\<](param|return|link|throw|inherit)");
        AT_SEE_TAG_PATTERN = Pattern.compile("@see.*", 32);
        TYPE_KEYWORD = new ETokenType[]{ETokenType.CLASS, ETokenType.INTERFACE, ETokenType.ENUM, ETokenType.STRUCT};
        DOUBLE_OPERATOR_PATTERN = Pattern.compile("(^|[^\\p{Punct}])[\\p{Punct}&&[^.]]{2}($|[^\\p{Punct}])");
        CAMEL_CASE_PATTERN = Pattern.compile("[a-z][A-Z]");
        COMMENTED_CODE_IGNORE_PATTERN = Pattern.compile("\\s*\\w+\\s+\\([\\w-]+\\).?\\s*", 8);
        SECTION_START_WORDS = new HashSet<String>(Arrays.asList("begin", "start", "end"));
        SECTION_END_WORDS = new HashSet<String>(Arrays.asList("classes", "variables", "attributes", "constructors", "methods", "events", "listeners", "handlers", "ctors", "fields", "properties", "implementation"));
    }
}

