/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.commit_alert.clone;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.commit_alert.CommitAlert;
import com.teamscale.index.commit_alert.CommitAlertIndex;
import com.teamscale.index.commit_alert.CommitAlerts;
import com.teamscale.index.commit_alert.clone.InconsistentCloneChangeContext;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.utils.DiffUtils;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.index.tracking.algorithm.UpdateableTokenListLookahead;
import com.teamscale.index.tracking.index.FindingChurnListIndex;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IStatementOracle;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageProperties;
import eu.cqse.check.framework.scanner.ScannerUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.LocationAdjuster;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ILookahead;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class InconsistentCloneChangeAlerter
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<ETokenType.ETokenClass> IGNORED_TOKEN_CLASSES = EnumSet.of(ETokenType.ETokenClass.COMMENT, ETokenType.ETokenClass.SYNTHETIC);
    private static final int MAX_ABSOLUTE_STATEMENT_CHANGE_SIZE = 5;
    private static final double MAX_RELATIVE_STATEMENT_CHANGE_SIZE = 0.5;
    private static final Duration AGE_THRESHOLD = Duration.ofDays(7L);
    private static final String CHECK_NAME = "clone change";
    private static final Set<String> CLONE_TYPE_IDS = Set.of(InconsistentCloneChangeAlerter.getCloneFindingTypeId("Clones"), InconsistentCloneChangeAlerter.getCloneFindingTypeId("Cross Component Clones"), InconsistentCloneChangeAlerter.getCloneFindingTypeId("Intra Component Clones"));
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="content")
    private TokenElementIndex contentIndex;
    @IndexAccess.Named(mode=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, name="content")
    private TokenElementIndex prevContentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CommitAlertIndex commitAlertIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingChurnListIndex findingChurnListIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private TrackedFindingsByIdIndex previousTrackedFindingsByIdIndex;
    @DeltaSource(value=FindingChurnListIndex.class)
    private KeyDelta unusedFindingChurnListDelta;
    private TokenElementIndexCache previousCache;
    private TokenElementIndexCache currentCache;
    private final Map<String, LocationAdjuster> locationAdjusters = new HashMap<String, LocationAdjuster>();

    public void execute() throws StorageException {
        CommitAlerts alerts = (CommitAlerts)this.commitAlertIndex.getEntry(this.getSchedulingCommit());
        if (alerts == null) {
            alerts = new CommitAlerts(this.getSchedulingCommit());
        }
        if (!alerts.hasBeenExecuted(CHECK_NAME)) {
            alerts.setExecuted(CHECK_NAME);
            this.runAnalysis(alerts);
            this.commitAlertIndex.setEntry(alerts);
        }
    }

    private void runAnalysis(CommitAlerts alerts) throws StorageException {
        FindingChurnList churnList = (FindingChurnList)this.findingChurnListIndex.getEntry(this.getSchedulingCommit());
        if (churnList == null) {
            return;
        }
        this.prepareCaches(churnList);
        for (TrackedFinding removedFinding : InconsistentCloneChangeAlerter.getCloneFindings(churnList.getRemovedFindings())) {
            this.checkForInconsistentClone(removedFinding, alerts);
        }
        Collection<TrackedFinding> changedCloneFindings = InconsistentCloneChangeAlerter.getCloneFindings(churnList.getFindingsInChangedCode());
        Set changedFindingsLocations = CollectionUtils.mapToSet(changedCloneFindings, finding -> finding.getLocation().toLocationString());
        for (TrackedFinding changedFinding : changedCloneFindings) {
            if (InconsistentCloneChangeAlerter.allSiblingsChanged(changedFinding, changedFindingsLocations)) continue;
            TrackedFinding previousCloneFinding = this.previousTrackedFindingsByIdIndex.getFinding(changedFinding.getId());
            this.checkForInconsistentClone(previousCloneFinding, alerts);
        }
    }

    private static boolean allSiblingsChanged(TrackedFinding changedFinding, Set<String> changedFindingsByLocation) {
        return changedFinding.getSiblingLocations().stream().allMatch(siblingLocation -> changedFindingsByLocation.contains(siblingLocation.toLocationString()));
    }

    private static Collection<TrackedFinding> getCloneFindings(Collection<TrackedFinding> findings) {
        return CollectionUtils.filter(findings, InconsistentCloneChangeAlerter::isCloneFinding);
    }

    private static boolean isCloneFinding(TrackedFinding finding) {
        return CLONE_TYPE_IDS.contains(finding.getTypeId());
    }

    private void prepareCaches(FindingChurnList churnList) throws StorageException {
        HashSet<String> preloadPaths = new HashSet<String>();
        for (TrackedFinding removed : churnList.getRemovedFindings()) {
            if (!InconsistentCloneChangeAlerter.isCloneFinding(removed)) continue;
            preloadPaths.add(removed.getLocation().getUniformPath());
        }
        List uniformPathsToPreload = UniformPathCompatibilityUtil.convertCollection(preloadPaths);
        this.previousCache = new TokenElementIndexCache(this.prevContentIndex, uniformPathsToPreload);
        this.currentCache = new TokenElementIndexCache(this.contentIndex, uniformPathsToPreload);
    }

    private void checkForInconsistentClone(@Nullable TrackedFinding cloneFinding, CommitAlerts alerts) throws StorageException {
        if (cloneFinding == null || !InconsistentCloneChangeAlerter.hasTextRegionLocation(cloneFinding) || this.isStillYoung(cloneFinding)) {
            return;
        }
        TextRegionLocation cloneLocation = (TextRegionLocation)CCSMAssert.checkedCast((Object)cloneFinding.getLocation(), TextRegionLocation.class);
        String locationUniformPath = cloneLocation.getUniformPath();
        TokenElementInfo newElement = this.currentCache.getValue(locationUniformPath);
        if (newElement == null) {
            return;
        }
        TokenElementInfo oldElement = this.getPreviousElementForLocation(locationUniformPath);
        TextRegionLocation expectedLocation = this.getAdjustedLocation(cloneLocation, oldElement, newElement);
        if (expectedLocation == null) {
            return;
        }
        if (InconsistentCloneChangeAlerter.isInconsistentChange(cloneLocation, oldElement, newElement, expectedLocation)) {
            this.createAlert(alerts, cloneFinding, cloneLocation, expectedLocation);
        }
    }

    private TokenElementInfo getPreviousElementForLocation(String uniformPath) throws StorageException {
        TokenElementInfo oldElement = this.previousCache.getValue(uniformPath);
        CCSMAssert.isTrue((oldElement != null ? 1 : 0) != 0, (String)("Expect element'" + uniformPath + "' to exist in previous version."));
        return oldElement;
    }

    private TextRegionLocation getAdjustedLocation(TextRegionLocation location, TokenElementInfo oldElement, TokenElementInfo newElement) {
        return this.locationAdjusters.computeIfAbsent(oldElement.getUniformPath(), uniformPath -> new LocationAdjuster(oldElement.getText(), newElement.getText())).adjustLocation(location);
    }

    private static boolean hasTextRegionLocation(TrackedFinding finding) {
        return finding.getLocation() instanceof TextRegionLocation;
    }

    private void createAlert(CommitAlerts alerts, TrackedFinding removedClone, TextRegionLocation cloneLocation, @NonNull TextRegionLocation expectedLocation) throws StorageException {
        CCSMAssert.isFalse((boolean)removedClone.getSiblingLocations().isEmpty(), (String)"Expect clone to have siblings!");
        TextRegionLocation sibling = (TextRegionLocation)CCSMAssert.checkedCast(removedClone.getSiblingLocations().get(0), TextRegionLocation.class);
        String siblingUniformPath = sibling.getUniformPath();
        TokenElementInfo newSiblingElement = this.currentCache.getValue(siblingUniformPath);
        if (newSiblingElement == null) {
            return;
        }
        TokenElementInfo oldSiblingElement = this.getPreviousElementForLocation(siblingUniformPath);
        TextRegionLocation expectedSiblingLocation = this.getAdjustedLocation(sibling, oldSiblingElement, newSiblingElement);
        try {
            if (expectedSiblingLocation != null && !DiffUtils.isChanged(expectedSiblingLocation, oldSiblingElement, newSiblingElement)) {
                String message = "Found potential inconsistent clone change in " + UniformPathUtils.getElementName((String)cloneLocation.getUniformPath());
                alerts.addAlert(new CommitAlert(message, new InconsistentCloneChangeContext(removedClone.getId(), cloneLocation, expectedLocation, expectedSiblingLocation)));
            }
        }
        catch (DiffUtils.DiffComputationLanguageException e) {
            LOGGER.warn("Unable to determine if clone sibling changed: " + e.getMessage(), (Throwable)e);
        }
        catch (DiffUtils.DiffComputationException e) {
            LOGGER.error("Unable to determine if clone sibling changed: " + e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isInconsistentChange(TextRegionLocation oldLocation, TokenElementInfo oldElement, TokenElementInfo newElement, TextRegionLocation newLocation) {
        List<String> oldStatements = InconsistentCloneChangeAlerter.extractCloneStatements(oldElement, oldLocation, "old");
        List<String> newStatements = InconsistentCloneChangeAlerter.extractCloneStatements(newElement, newLocation, "new");
        if (oldStatements.isEmpty() || newStatements.isEmpty()) {
            return false;
        }
        int absoluteChangeSize = Math.abs(oldStatements.size() - newStatements.size());
        double relativeChangeSize = (double)absoluteChangeSize / (double)Math.min(oldStatements.size(), newStatements.size());
        if (relativeChangeSize > 0.5 || absoluteChangeSize > 5) {
            return false;
        }
        int diffSize = Diff.computeDelta(oldStatements, newStatements).getSize();
        return diffSize != 0 && diffSize <= 5;
    }

    private boolean isStillYoung(TrackedFinding removedClone) {
        long age = this.getSchedulingCommit().getTimestamp() - removedClone.getBirthCommit().getTimestamp();
        return age < AGE_THRESHOLD.toMillis();
    }

    private static List<String> extractCloneStatements(TokenElementInfo element, TextRegionLocation location, String locationDescription) {
        int startOffset = location.getRawStartOffset();
        int endOffset = location.getRawEndOffset() + 1;
        String elementText = element.getText();
        if (endOffset <= startOffset || endOffset > elementText.length()) {
            LOGGER.warn("Received invalid offsets [" + startOffset + "-" + endOffset + "] for " + locationDescription + " element " + element.getUniformPath() + ", which has length " + elementText.length());
            return Collections.emptyList();
        }
        String textContent = elementText.substring(startOffset, endOffset);
        List tokens = ScannerUtils.getTokens((String)textContent, (ELanguage)element.getLanguage(), (String)element.getUniformPath());
        IStatementOracle statementOracle = LanguageProperties.of((ELanguage)element.getLanguage()).getStatementOracle();
        return InconsistentCloneChangeAlerter.getCloneStatementFromTokens(tokens, statementOracle);
    }

    private static List<String> getCloneStatementFromTokens(List<IToken> tokens, IStatementOracle statementOracle) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentStatement = new StringBuilder();
        UpdateableTokenListLookahead lookahead = new UpdateableTokenListLookahead(tokens, 0);
        for (int i = 0; i < tokens.size(); ++i) {
            IToken token = tokens.get(i);
            ETokenType.ETokenClass tokenClass = token.getType().getTokenClass();
            if (IGNORED_TOKEN_CLASSES.contains(tokenClass)) continue;
            lookahead.setCurrentIndex(i);
            if (statementOracle.isEndOfStatementToken(token.getType(), (ILookahead)lookahead)) {
                if (currentStatement.length() <= 0) continue;
                result.add(currentStatement.toString());
                currentStatement.setLength(0);
                continue;
            }
            currentStatement.append(token.getText());
        }
        return result;
    }

    private static String getCloneFindingTypeId(String findingGroup) {
        return "Redundancy/" + findingGroup;
    }
}

