/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.CodeScopeAwareObjectBuilder;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionLanguages;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.configuration.DataflowAnalysisTransformationPatterns;
import com.teamscale.index.dataflow.DataFlowFindingsSynchronizer;
import com.teamscale.index.dataflow.DataflowConfigurationParameters;
import com.teamscale.index.dataflow.EDataflowAnalysis;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class DataflowAnalysisConfiguration
extends AnalysisConfigurationBase {
    private static final EnumSet<ELanguage> CFG_ENABLED_LANGUAGES = EnumSet.of(ELanguage.CS, ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C);
    public static final EnumSet<ELanguage> DIVISION_BY_ZERO_ANALYSIS_ENABLED_LANGUAGES = EnumSet.of(ELanguage.CS, ELanguage.JAVA);
    private static final Map<EDataflowAnalysis, String> ENABLEMENT_TRIGGER_PARAMETERS = new HashMap<EDataflowAnalysis, String>();
    @ConfigExposed(name="Only analyze parameters of static and private methods", description="If this is enabled, unused parameters are only reported for private and static methods. Disable this only if the system consistently uses Java's @Override or the C# `override` keyword. Without such consistency, the analysis will produce too many false positives.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    public CodeScopeAware<Boolean> reportUnusedStaticAndPrivateMethodParameters = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    @ConfigExposed(name="Ignore parameters of protected methods", description="Protected methods are often intended to be overwritten and the base implementation may not use every parameter in the method signature.\n", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    public CodeScopeAware<Boolean> ignoreProtectedMethods = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="Ignore all assignments in declaration statements", description="If this option is enabled, the analysis will not report dead-store findings on initial-value assignments in declaration statements (e.g., on `int x=5; x=6;`). Note: initial-value assignments with the language-default value (e.g., `int x=0;`) or a trivial value (see option 'Ignore assignments of trivial values') are always ignored.\n", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    public CodeScopeAware<Boolean> ignoreAssignmentInDeclaration = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="Ignore assignments of trivial values", description="If a variable is not read after a value specified here gets assigned, it will not be reported as dead store.\nPossible values are, for example:\n\t- Integer:\t0\n\t- String:\t\"\", String.Empty, string.Empty\n\t- Any:\t\tnull.\nValues should be entered as a comma-separated list.\nFor example:\t String.Empty,\"\",null,0.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    public CodeScopeAware<List<String>> trivialValues = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    @ConfigExposed(name="Custom assert methods", description="The names of methods that provide assertTrue-like functionality. Separated by a comma. Works only for C# and Java.\n", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    @ConfigOptionLanguages(languages={ELanguage.JAVA, ELanguage.CS})
    public CodeScopeAware<List<String>> customAsserts = CodeScopeAware.defaultCodeScopeWithValue(List.of("assert"));
    @ConfigExposed(name="Token stream transformations", description="Transformations that are applied to the token stream before parsing. This option can be used to handle, e.g. custom null-checks or assert methods. Transformations are separated by '##'. Each transformation must be of the form 'language#searchPattern#replacementPattern'. Patterns may contain variables that start with '$'. The tokens matched to that variable in the search will be included in the appropriate places of the replacement pattern. Variables can match one or more tokens, but if their name ends with a number, they are restricted to matching exactly that number of tokens. Example: 'CS#assertNotNull($a1);#{if($a1 == null){ throw new AssertFailedException(); }}'. If the search patterns of multiple transformations match to the same location in the code, only the first one is applied (the order of the transformations is relevant). For C#, a block `{}` around the replacement pattern is removed when this matches an `out Type Identifier` variable introduction to avoid scoping issues. For C/C++ please use the option \"Predefined Preprocessor Marcos\" in the advanced options of the analysis profile, e.g. `#define assertNotNull(x) { if(!(x)){exit(1);} }`.\n", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    @ConfigOptionLanguages(languages={ELanguage.JAVA, ELanguage.CS})
    public CodeScopeAware<String> transformations = CodeScopeAware.defaultCodeScopeWithValue((Object)"CS#assertNotNull($a);#{if($a == null){ throw new AssertFailedException(); }}##JAVA#assertNotNull($a);#{if($a == null){ throw new java.lang.AssertionError(); }}");
    @ConfigExposed(name="Identifier-based null pointer finding filters", description="The names of identifiers that should cause all null pointer problems to be filtered out for a method. Separated by a comma.\n", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    public CodeScopeAware<List<String>> identifierBasedFilters = CodeScopeAware.defaultCodeScopeWithValue((Object)CollectionUtils.emptyList());
    @ConfigExposed(name="Methods callable on 'null'", description="The names of methods (comma-separated) that can be called on null and thus should not cause null-pointer de-reference findings. Example: A C# extension method `isNullOrEmpty`\n", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    public CodeScopeAware<List<String>> nullSafeMethodsFilters = CodeScopeAware.defaultCodeScopeWithValue((Object)CollectionUtils.emptyList());
    @ConfigExposed(name="Java: JUnit asserts", dependentOptions={"JUnit: version"}, description="Enables support for JUnit assert statements.\n")
    @ConfigOptionLanguages(languages={ELanguage.JAVA})
    public CodeScopeAware<Boolean> usingJUnitAsserts = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="Java: JUnit version", validator=JUnitVersionValidator.class, description="Specifies the version of JUnit. Supported values are 4 and 5.\n")
    @ConfigOptionLanguages(languages={ELanguage.JAVA})
    public CodeScopeAware<Integer> jUnitVersion = CodeScopeAware.defaultCodeScopeWithValue((Object)5);
    @ConfigExposed(name="C#: NUnit/xUnit.NET/MSTest asserts", description="Enables support for NUnit, xUnit.NET and MSTest assert statements.\n")
    @ConfigOptionLanguages(languages={ELanguage.CS})
    public CodeScopeAware<Boolean> usingCSAsserts = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="Ignore null-pointer dereference for pointers assigned by malloc", description="When enabled, this option prevents the creation of null-pointer dereference findings for pointers assigned by `malloc`, unless followed by an explicit null-check.")
    @ConfigOptionLanguages(languages={ELanguage.C, ELanguage.CPP, ELanguage.CPP_MS_CLI})
    public CodeScopeAware<Boolean> ignoreMallocAssignments = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    private final CodeScopeAware<FindingDescriptor> unusedVariablesFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)DataflowAnalysisConfiguration.createFinding("Unused variable or parameter", (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-unused-variables.md").orElseThrow(), EFindingEnablement.YELLOW, CFG_ENABLED_LANGUAGES));
    private final CodeScopeAware<FindingDescriptor> nullPointerFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)DataflowAnalysisConfiguration.createFinding("Null pointer dereference", (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-null-pointer.md").orElseThrow(), EFindingEnablement.RED, CFG_ENABLED_LANGUAGES));
    private final CodeScopeAware<FindingDescriptor> divisionByZeroFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)DataflowAnalysisConfiguration.createFinding("Possible division by zero", (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-division-by-zero-dataflow.md").orElseThrow(), EFindingEnablement.RED, DIVISION_BY_ZERO_ANALYSIS_ENABLED_LANGUAGES));

    private static FindingDescriptor createFinding(String name, String description, EFindingEnablement enablement, EnumSet<ELanguage> languages) {
        return new FindingDescriptor(name, EAnalysisTool.TEAMSCALE, languages, enablement, description);
    }

    protected void configureProjectInternal(ProjectCreationProxy projectCreationProxy) throws ProjectConfigurationException {
        CodeScopeAware configuredLanguagesPerCodeScope;
        List codeScopeNames = projectCreationProxy.getCodeScopeNames();
        List<CodeScopeName> relevantCodeScopeNames = DataflowAnalysisConfiguration.filterCodeScopeNamesWithCfgEnabledLanguages(codeScopeNames, (CodeScopeAware<Set<ELanguage>>)(configuredLanguagesPerCodeScope = projectCreationProxy.getConfiguredLanguages()));
        if (relevantCodeScopeNames.isEmpty() || this.allAnalysesDisabled(relevantCodeScopeNames)) {
            return;
        }
        this.registerFindingSchemas(projectCreationProxy, relevantCodeScopeNames, (CodeScopeAware<Set<ELanguage>>)configuredLanguagesPerCodeScope);
        TriggerBuilder triggerBuilder = new TriggerBuilder(DataFlowFindingsSynchronizer.class, ETriggerConcurrency.PARALLEL);
        this.setAnalysisParameters(triggerBuilder, relevantCodeScopeNames, (CodeScopeAware<Set<ELanguage>>)configuredLanguagesPerCodeScope);
        projectCreationProxy.createTrigger(triggerBuilder);
    }

    private void setAnalysisParameters(TriggerBuilder triggerBuilder, List<CodeScopeName> relevantCodeScopeNames, CodeScopeAware<Set<ELanguage>> configuredLanguagesPerCodeScope) {
        CodeScopeAware<DataflowConfigurationParameters> parametersBuilder = this.buildDataflowConfigurationParametersCodeScopeAware(relevantCodeScopeNames, configuredLanguagesPerCodeScope);
        triggerBuilder.setTriggerParameter("dataflow-analysis-configuration-parameters", parametersBuilder);
        DataflowAnalysisConfiguration.disableAnalysisIfAllFindingsAreDisabled(triggerBuilder, EDataflowAnalysis.NULL_POINTER, this.nullPointerFinding, relevantCodeScopeNames);
        DataflowAnalysisConfiguration.disableAnalysisIfAllFindingsAreDisabled(triggerBuilder, EDataflowAnalysis.DEAD_STORE, this.unusedVariablesFinding, relevantCodeScopeNames);
        DataflowAnalysisConfiguration.disableAnalysisIfAllFindingsAreDisabled(triggerBuilder, EDataflowAnalysis.DIVISION_BY_ZERO, this.divisionByZeroFinding, relevantCodeScopeNames);
    }

    private CodeScopeAware<DataflowConfigurationParameters> buildDataflowConfigurationParametersCodeScopeAware(List<CodeScopeName> relevantCodeScopeNames, CodeScopeAware<Set<ELanguage>> configuredLanguagesPerCodeScope) {
        CodeScopeAwareObjectBuilder parametersBuilder = new CodeScopeAwareObjectBuilder(null);
        for (CodeScopeName codeScopeName : relevantCodeScopeNames) {
            parametersBuilder.setContents(codeScopeName, (Object)this.buildParametersForCodeScope(codeScopeName, (Set)configuredLanguagesPerCodeScope.getValue(codeScopeName)));
        }
        return parametersBuilder.build();
    }

    private void registerFindingSchemas(ProjectCreationProxy projectCreationProxy, List<CodeScopeName> relevantCodeScopeNames, CodeScopeAware<Set<ELanguage>> configuredLanguagesPerCodeScope) {
        for (CodeScopeName codeScopeName : relevantCodeScopeNames) {
            Set profileLanguages = (Set)configuredLanguagesPerCodeScope.getValue(codeScopeName);
            projectCreationProxy.addFindingsSchemaEntry("Dataflow", ((FindingDescriptor)this.nullPointerFinding.getValue(codeScopeName)).getName(), (FindingDescriptor)this.nullPointerFinding.getValue(codeScopeName), codeScopeName);
            projectCreationProxy.addFindingsSchemaEntry("Dataflow", ((FindingDescriptor)this.unusedVariablesFinding.getValue(codeScopeName)).getName(), (FindingDescriptor)this.unusedVariablesFinding.getValue(codeScopeName), codeScopeName);
            if (!profileLanguages.contains(ELanguage.JAVA) && !profileLanguages.contains(ELanguage.CS)) continue;
            projectCreationProxy.addFindingsSchemaEntry("Dataflow", ((FindingDescriptor)this.divisionByZeroFinding.getValue(codeScopeName)).getName(), (FindingDescriptor)this.divisionByZeroFinding.getValue(codeScopeName), codeScopeName);
        }
    }

    private DataflowConfigurationParameters buildParametersForCodeScope(CodeScopeName codeScopeName, Set<ELanguage> codeScopeLanguages) {
        DataflowConfigurationParameters parameters = new DataflowConfigurationParameters();
        parameters.addTokenTransformations(this.buildConfigurableTransformationPatterns(codeScopeName, codeScopeLanguages));
        parameters.setReportUnusedStaticAndPrivateMethodParameters((Boolean)this.reportUnusedStaticAndPrivateMethodParameters.getValue(codeScopeName));
        parameters.setIgnoreProtectedMethods((Boolean)this.ignoreProtectedMethods.getValue(codeScopeName));
        parameters.setIgnoreAssignmentInDeclaration((Boolean)this.ignoreAssignmentInDeclaration.getValue(codeScopeName));
        if (LanguageGroups.C_CPP_AND_MS_CLI.stream().anyMatch(codeScopeLanguages::contains)) {
            parameters.setIgnoreMallocAssignments((Boolean)this.ignoreMallocAssignments.getValue(codeScopeName));
        }
        parameters.addTrivialValues((Collection)this.trivialValues.getValue(codeScopeName));
        parameters.addIdentifierBasedFilters((Collection)this.identifierBasedFilters.getValue(codeScopeName));
        parameters.addNullSafeMethodFilters((Collection)this.nullSafeMethodsFilters.getValue(codeScopeName));
        return parameters;
    }

    private static List<CodeScopeName> filterCodeScopeNamesWithCfgEnabledLanguages(List<CodeScopeName> codeScopeNames, CodeScopeAware<Set<ELanguage>> configuredLanguagesPerCodeScope) {
        ArrayList<CodeScopeName> relevantCodeScopeNames = new ArrayList<CodeScopeName>();
        for (CodeScopeName codeScopeName : codeScopeNames) {
            Set profileLanguages = (Set)configuredLanguagesPerCodeScope.getValue(codeScopeName);
            if (!CFG_ENABLED_LANGUAGES.stream().anyMatch(profileLanguages::contains)) continue;
            relevantCodeScopeNames.add(codeScopeName);
        }
        return relevantCodeScopeNames;
    }

    private boolean allAnalysesDisabled(List<CodeScopeName> codeScopeNames) {
        for (CodeScopeName codeScopeName : codeScopeNames) {
            if (((FindingDescriptor)this.nullPointerFinding.getValue(codeScopeName)).getEnablement().isEnabled()) {
                return false;
            }
            if (((FindingDescriptor)this.unusedVariablesFinding.getValue(codeScopeName)).getEnablement().isEnabled()) {
                return false;
            }
            if (!((FindingDescriptor)this.divisionByZeroFinding.getValue(codeScopeName)).getEnablement().isEnabled()) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public List<String> buildConfigurableTransformationPatterns(CodeScopeName codeScopeName, Set<ELanguage> profileLanguages) {
        ArrayList<String> transformationPatterns = new ArrayList<String>();
        if (profileLanguages.contains(ELanguage.CS)) {
            transformationPatterns.addAll(DataflowAnalysisTransformationPatterns.buildCsTransformations((List)this.customAsserts.getValue(codeScopeName), (Boolean)this.usingCSAsserts.getValue(codeScopeName)));
        }
        if (profileLanguages.contains(ELanguage.JAVA)) {
            transformationPatterns.addAll(DataflowAnalysisTransformationPatterns.buildJavaTransformations((List)this.customAsserts.getValue(codeScopeName), (Boolean)this.usingJUnitAsserts.getValue(codeScopeName), (Integer)this.jUnitVersion.getValue(codeScopeName)));
        }
        if (profileLanguages.contains(ELanguage.CS) || profileLanguages.contains(ELanguage.JAVA)) {
            transformationPatterns.addAll(DataflowAnalysisTransformationPatterns.parseUserDefinedTransformations((String)this.transformations.getValue(codeScopeName)));
        }
        return transformationPatterns;
    }

    private static void disableAnalysisIfAllFindingsAreDisabled(TriggerBuilder triggerBuilder, EDataflowAnalysis analysis, CodeScopeAware<FindingDescriptor> descriptorsPerCodeScope, List<CodeScopeName> codeScopeNames) {
        CodeScopeAwareObjectBuilder builder = new CodeScopeAwareObjectBuilder((Object)false);
        for (CodeScopeName codeScopeName : codeScopeNames) {
            FindingDescriptor findingDescriptorInCodeScope = (FindingDescriptor)descriptorsPerCodeScope.getValueOrNull(codeScopeName);
            boolean isEnabledInCodeScope = findingDescriptorInCodeScope != null && findingDescriptorInCodeScope.getEnablement().isEnabled();
            builder.setContents(codeScopeName, (Object)isEnabledInCodeScope);
        }
        triggerBuilder.setTriggerParameter(ENABLEMENT_TRIGGER_PARAMETERS.get((Object)analysis), (ITriggerParameter)builder.build());
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (CollectionUtils.intersectionSet(languages, (Collection[])new Collection[]{CFG_ENABLED_LANGUAGES}).isEmpty()) {
            return;
        }
        CodeScopeName codeScopeName = template.getCodeScope();
        super.autoExpose(codeScopeName, languages);
        template.registerConfiguration((AnalysisConfigurationBase)this);
        LinkedHashSet<Object> nullPointerGroupItems = new LinkedHashSet<Object>();
        nullPointerGroupItems.add((ConfigurationItemBase)this.nullPointerFinding.getValueWithDefault(codeScopeName));
        nullPointerGroupItems.add(this.getOptionForField("identifierBasedFilters", codeScopeName));
        nullPointerGroupItems.add(this.getOptionForField("nullSafeMethodsFilters", codeScopeName));
        if (languages.contains(ELanguage.JAVA) || languages.contains(ELanguage.CS)) {
            nullPointerGroupItems.add(this.getOptionForField("customAsserts", codeScopeName));
            nullPointerGroupItems.add(this.getOptionForField("transformations", codeScopeName));
        }
        if (languages.contains(ELanguage.JAVA)) {
            nullPointerGroupItems.add(this.getOptionForField("usingJUnitAsserts", codeScopeName));
            nullPointerGroupItems.add(this.getOptionForField("jUnitVersion", codeScopeName));
        }
        if (languages.contains(ELanguage.CS)) {
            nullPointerGroupItems.add(this.getOptionForField("usingCSAsserts", codeScopeName));
        }
        if (LanguageGroups.C_CPP_AND_MS_CLI.stream().anyMatch(languages::contains)) {
            nullPointerGroupItems.add(this.getOptionForField("ignoreMallocAssignments", codeScopeName));
        }
        template.registerConfigurationItemsCodeScopeAware("Possible Bugs", "Correctness", nullPointerGroupItems);
        ArrayList<Object> unusedVariablesGroupItems = new ArrayList<Object>();
        unusedVariablesGroupItems.add((ConfigurationItemBase)this.unusedVariablesFinding.getValueWithDefault(codeScopeName));
        unusedVariablesGroupItems.add(this.getOptionForField("reportUnusedStaticAndPrivateMethodParameters", codeScopeName));
        unusedVariablesGroupItems.add(this.getOptionForField("ignoreAssignmentInDeclaration", codeScopeName));
        unusedVariablesGroupItems.add(this.getOptionForField("ignoreProtectedMethods", codeScopeName));
        unusedVariablesGroupItems.add(this.getOptionForField("trivialValues", codeScopeName));
        template.registerConfigurationItemsCodeScopeAware("Unused Code", "Comprehensibility", unusedVariablesGroupItems);
        if (languages.contains(ELanguage.JAVA) || languages.contains(ELanguage.CS)) {
            template.registerConfigurationItemsCodeScopeAware("Possible Bugs", "Correctness", List.of((ConfigurationItemBase)this.divisionByZeroFinding.getValueWithDefault(codeScopeName)));
        }
    }

    static {
        ENABLEMENT_TRIGGER_PARAMETERS.put(EDataflowAnalysis.DEAD_STORE, "enable-dead-store");
        ENABLEMENT_TRIGGER_PARAMETERS.put(EDataflowAnalysis.NULL_POINTER, "enable-null-pointer");
        ENABLEMENT_TRIGGER_PARAMETERS.put(EDataflowAnalysis.DIVISION_BY_ZERO, "enable-division-by-zero");
    }

    public static class JUnitVersionValidator
    implements ConfigExposed.IOptionValueValidator {
        private static final Collection<String> SUPPORTED_VERSIONS = Set.of("4", "5");

        public void validate(String value) throws ProjectConfigurationException {
            if (!SUPPORTED_VERSIONS.contains(value)) {
                throw new ProjectConfigurationException("Unsupported JUnit version: " + value);
            }
        }
    }
}

