/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryIndexSynchronizer;
import com.teamscale.core.metrics.directory.MetricTrendIndex;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.jspecify.annotations.NonNull;

public class WorkItemCoreConfiguration
extends AnalysisConfigurationBase {
    public static final String METRICS_SCHEMA_INDEX_NAME = MetricSchemaIndex.EMetricSchemaType.WORK_ITEM.getIndexName();
    public static final String METRICS_DIRECTORY_INDEX_NAME = "work-item-metrics-directory";
    public static final String METRICS_TREND_INDEX_NAME = "work-item-metrics-trend";
    public static final String METRICS_INDEX_NAME = "work-item-metrics";

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        WorkItemCoreConfiguration.createIndices(proxy);
        WorkItemCoreConfiguration.createTrigger(proxy);
    }

    private static void createTrigger(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createTrigger(WorkItemCoreConfiguration.createMetricDirectoryIndexSynchronizer(), "work-item");
    }

    private static @NonNull TriggerBuilder createMetricDirectoryIndexSynchronizer() {
        TriggerBuilder trigger = new TriggerBuilder(MetricDirectoryIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED);
        trigger.resolveIndexNamePlaceholder("metrics-placeholder", METRICS_INDEX_NAME);
        trigger.resolveIndexNamePlaceholder("metric-directory-placeholder", METRICS_DIRECTORY_INDEX_NAME);
        trigger.resolveIndexNamePlaceholder("metric-trend-placeholder", METRICS_TREND_INDEX_NAME);
        trigger.resolveIndexNamePlaceholder("metric-schema-placeholder", METRICS_SCHEMA_INDEX_NAME);
        trigger.setTriggerParameter("use-hidden-metrics-index", false);
        trigger.setCost(ETriggerCost.CHEAP);
        return trigger;
    }

    private static void createIndices(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(MetricSchemaIndex.class, METRICS_SCHEMA_INDEX_NAME);
        proxy.createProjectIndex(MetricDirectoryIndex.class, METRICS_DIRECTORY_INDEX_NAME);
        proxy.createProjectIndex(MetricTrendIndex.class, METRICS_TREND_INDEX_NAME);
        proxy.createProjectIndex(MetricsIndex.class, METRICS_INDEX_NAME);
    }

    public boolean isCoreConfiguration() {
        return true;
    }
}

