/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.index.findings.golangcilint.GoLangCILintException;
import com.teamscale.index.findings.golangcilint.GoLangCILintRunner;
import com.teamscale.index.findings.golangcilint.GoLangCILintSynchronizer;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

public class GoLangCILintConfiguration
extends ToolConfigurationBase {
    public static final String FINDING_CATEGORY = "golangci-lint";
    private static final String DESCRIPTIONS_PATH = "golangci-lint";
    public static final String CHECK_MAPPINGS_TSV = "golangci-lint/check-mappings.tsv";
    public static final String CHECK_OPTIONS_TSV = "golangci-lint/check-options.tsv";

    public GoLangCILintConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.GOLANG_CI_LINT, "golangci-lint", "golangci-lint", CHECK_MAPPINGS_TSV, CHECK_OPTIONS_TSV, null);
        this.declareCodeScopeAware();
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (!tools.contains(EAnalysisTool.GOLANG_CI_LINT)) {
            return;
        }
        template.registerConfiguration((AnalysisConfigurationBase)this);
        super.registerQualityIndicators(template, languages, tools);
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware activeChecksPerCodeScope = this.getActiveCheckPerCodeScope(proxy.getCodeScopeNames());
        if (activeChecksPerCodeScope == null) {
            return;
        }
        TriggerBuilder triggerBuilder = new TriggerBuilder(GoLangCILintSynchronizer.class, ETriggerConcurrency.PARALLEL);
        triggerBuilder.setCost(ETriggerCost.EXPENSIVE);
        triggerBuilder.setTriggerParameter("checks", (ITriggerParameter)activeChecksPerCodeScope);
        CodeScopeAware checkOptionsPerCodeScope = CodeScopeAware.empty();
        CodeScopeAware checkOptionsTypesPerCodeScope = CodeScopeAware.empty();
        CodeScopeAware checkOptionsValuesPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : activeChecksPerCodeScope.getCodeScopeNames()) {
            ArrayList<String> selectedOptions = new ArrayList<String>();
            ArrayList<String> checkOptionTypes = new ArrayList<String>();
            ArrayList<String> checkOptionValues = new ArrayList<String>();
            for (String selectedCheckInCodeScope : (Collection)activeChecksPerCodeScope.getValue(codeScopeName)) {
                UnmodifiableSet options = ((FindingDescriptor)((Map)this.findingDescriptorsByFindingTypeId.getValue(codeScopeName)).get(selectedCheckInCodeScope)).getReferencedOptions();
                GoLangCILintConfiguration.collectOptionsTypesAndValues(codeScopeName, (Set<ConfigOptionDescriptorBase>)options, selectedOptions, checkOptionTypes, checkOptionValues);
            }
            checkOptionsPerCodeScope.setValue(codeScopeName, selectedOptions);
            checkOptionsTypesPerCodeScope.setValue(codeScopeName, checkOptionTypes);
            checkOptionsValuesPerCodeScope.setValue(codeScopeName, checkOptionValues);
        }
        triggerBuilder.setTriggerParameter("check-options", (ITriggerParameter)checkOptionsPerCodeScope);
        triggerBuilder.setTriggerParameter("check-option-types", (ITriggerParameter)checkOptionsTypesPerCodeScope);
        triggerBuilder.setTriggerParameter("check-option-values", (ITriggerParameter)checkOptionsValuesPerCodeScope);
        proxy.createTrigger(triggerBuilder);
        super.configureProjectInternal(proxy);
    }

    private static void collectOptionsTypesAndValues(CodeScopeName codeScopeName, Set<ConfigOptionDescriptorBase> options, List<String> selectedOptions, List<String> checkOptionTypes, List<String> checkOptionValues) {
        for (ConfigOptionDescriptorBase option : options) {
            String value = option.retrieveValueAsString(codeScopeName);
            if (StringUtils.isEmpty((String)value)) continue;
            selectedOptions.add(option.getName());
            checkOptionTypes.add(option.getType());
            checkOptionValues.add(value);
        }
    }

    public void validateTools() throws ProjectConfigurationException {
        try {
            GoLangCILintRunner.verifyLinterInstallation();
        }
        catch (GoLangCILintException e) {
            throw new ProjectConfigurationException("Could not validate GoLangCILint configuration", (Throwable)e);
        }
    }
}

