/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics;

import com.teamscale.index.dataflow.controlflowgraph.Condition;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDataFlowHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.IShallowEntityMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;

public abstract class DataflowHeuristicBase
implements IDataFlowHeuristic {
    private static final String ASSUME_NON_NULL_VALUE = "assume non-null";
    private final PairList<IShallowEntityMatcher, IControlFlowRule> rules;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MAX_NUM_CONTROL_FLOW_NODES_PER_GRAPH_VM_OPTION = "com.teamscale.dataflow.max_num_cfg_nodes_per_graph";
    private static final int MAX_NUM_CONTROL_FLOW_NODES_PER_GRAPH_DEFAULT = 1000;
    private static final int WEIGH_FACTOR_CONDITIONAL_NODES = 3;
    private final int maxNumWeighedNodesPerGraph = Integer.getInteger("com.teamscale.dataflow.max_num_cfg_nodes_per_graph", 1000);

    protected DataflowHeuristicBase() {
        this.rules = this.getRules();
    }

    protected abstract PairList<IShallowEntityMatcher, IControlFlowRule> getRules();

    @Override
    public Optional<ControlFlowGraph> createControlFlow(List<ShallowEntity> methodEntities, String methodName, DataFlowContext context) throws ConQATException {
        long numNonConditionalNodes;
        ControlFlowGraph graph = this.createCfgRecursive(methodEntities, methodName, context);
        long numConditionalNodes = graph.listDepthFirst().stream().filter(DataflowHeuristicBase::isConditionalNode).count();
        long numWeighedNodes = numConditionalNodes * 3L + (numNonConditionalNodes = (long)graph.listDepthFirst().size() - numConditionalNodes);
        if (numWeighedNodes > (long)this.maxNumWeighedNodesPerGraph) {
            LOGGER.warn("The CFG for {} has more than the maximum of {} (weighed) control flow nodes, as it might exceed resource limitations.", (Object)methodName, (Object)this.maxNumWeighedNodesPerGraph);
            return Optional.empty();
        }
        DataflowHeuristicBase.setIds(graph);
        return Optional.of(graph);
    }

    private static boolean isConditionalNode(@NonNull ControlFlowNode node) {
        return node.getSuccessors().size() > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ControlFlowGraph createCfgRecursive(List<ShallowEntity> methodEntities, String methodName, DataFlowContext context) throws ConQATException {
        IControlFlowRule.Result result;
        context.saveAllCurrentContextNodes();
        try {
            ControlFlowCreator creator = new ControlFlowCreator(context, this.rules);
            result = creator.transform(methodEntities);
        }
        finally {
            context.restoreAllPreviousContextNodes();
        }
        CCSMAssert.isTrue((result.getExitNodes().size() == 1 ? 1 : 0) != 0, (String)("The CFG for " + methodName + " has more than one (or no) exit node. MethodRuleBase.transform should ensure that there is exactly one exit node."));
        ControlFlowNode exitNode = (ControlFlowNode)CollectionUtils.getAny(result.getExitNodes());
        if (!exitNode.isSynthetic()) {
            ControlFlowNode syntheticExitNode = context.createSyntheticNode();
            ControlFlowNode.link(exitNode, syntheticExitNode);
            exitNode = syntheticExitNode;
        }
        ControlFlowGraph graph = new ControlFlowGraph(result.getEntryNode(), exitNode, methodName, methodEntities, result.isInitializerCode());
        if (result.isInitializerCode()) {
            graph.getDefinedGlobalVariables().addAll(context.getDefUseHeuristic().getDefinitionsInFileScope());
            graph.getDefinedGlobalVariables().addAll(context.getDefUseHeuristic().getDefinitionsInLocalScope());
        }
        HashSet usedGlobalVariables = CollectionUtils.intersectionSet(graph.getUsedVariables(), (Collection[])new Collection[]{context.getDefUseHeuristic().getDefinitionsInFileScope().stream().map(VariableWrite::getChangedVariable).collect(Collectors.toSet())});
        graph.getUsedGlobalVariables().addAll(usedGlobalVariables);
        DataflowHeuristicBase.createAssumeNodes(graph);
        this.discoverAndAttachNestedNamedCfgs(graph, methodEntities, context);
        return graph;
    }

    private void discoverAndAttachNestedNamedCfgs(ControlFlowGraph parentGraph, List<ShallowEntity> methodEntities, DataFlowContext context) throws ConQATException {
        List childMethods = CollectionUtils.filter((Collection)ShallowEntityTraversalUtils.selectEntities(methodEntities, entity -> entity.getType() == EShallowEntityType.METHOD && entity.getSubtype().equals("local function") && this.hasEntityParentSameNameAsParentGraph((ShallowEntity)entity, parentGraph)), Predicate.not(methodEntities::contains));
        this.addParentVariablesToScope(parentGraph, context);
        for (ShallowEntity childMethod : childMethods) {
            ControlFlowGraph innerCFG = this.createCfgRecursive(Collections.singletonList(childMethod), childMethod.getName(), context);
            for (ControlFlowNode parentGraphNode : parentGraph.listDepthFirst()) {
                if (!this.methodIsCalledInTokens(innerCFG, parentGraphNode)) continue;
                parentGraphNode.attachLambdaOrNestedFunction(innerCFG);
            }
        }
    }

    private void addParentVariablesToScope(ControlFlowGraph parentGraph, DataFlowContext context) {
        for (String variableInOuterScope : parentGraph.getDefinedVariables()) {
            context.getDefUseHeuristic().addToScope(variableInOuterScope);
        }
    }

    private boolean hasEntityParentSameNameAsParentGraph(ShallowEntity entity, ControlFlowGraph parentGraph) {
        Optional parentMethod = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entity, parent -> parent.getType() == EShallowEntityType.METHOD);
        if (parentMethod.isPresent()) {
            if (((ShallowEntity)parentMethod.get()).getName() != null) {
                return ((ShallowEntity)parentMethod.get()).getName().equals(parentGraph.getMethodName());
            }
            return false;
        }
        LOGGER.error("No parent method found for function `" + entity.getName() + "`.");
        return false;
    }

    private boolean methodIsCalledInTokens(ControlFlowGraph innerCFG, ControlFlowNode parentGraphNode) {
        List<IToken> parentGraphNodeTokens = parentGraphNode.getTokens();
        Set nestedLambdaTokens = parentGraphNode.getLambdas().stream().flatMap(lambda -> lambda.listDepthFirst().stream()).flatMap(node -> node.getTokens().stream()).collect(Collectors.toSet());
        List<Integer> callNameIndices = this.getCallIndices(innerCFG, parentGraphNodeTokens);
        return callNameIndices.stream().anyMatch(index -> {
            IToken token = (IToken)parentGraphNodeTokens.get((int)index);
            if (!nestedLambdaTokens.contains(token) && token.getText().equals(innerCFG.getMethodName())) {
                return index <= 0 || !((IToken)parentGraphNodeTokens.get(index - 1)).getText().equals(".");
            }
            return false;
        });
    }

    private List<Integer> getCallIndices(ControlFlowGraph innerCFG, List<IToken> parentGraphNodeTokens) {
        if (parentGraphNodeTokens.isEmpty()) {
            return Collections.emptyList();
        }
        int graphCharOffset = innerCFG.getEntities().get(0).getStartOffset();
        if (parentGraphNodeTokens.get(0).getOffset() < graphCharOffset && graphCharOffset < ((IToken)CollectionUtils.getLast(parentGraphNodeTokens)).getOffset()) {
            return Collections.emptyList();
        }
        return TokenStreamUtils.allStartingIndicesOfTypeSequence(parentGraphNodeTokens, (int)0, (int)parentGraphNodeTokens.size(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN});
    }

    private static void setIds(ControlFlowGraph graph) {
        int currentId = 1;
        List<ControlFlowNode> listDepthFirstIncludingLambdas = graph.listDepthFirstIncludingLambdas();
        try {
            for (ControlFlowNode node : listDepthFirstIncludingLambdas) {
                node.setId(currentId++);
            }
        }
        catch (IllegalStateException e) {
            CCSMAssert.fail((String)("Failed to set node IDs for " + listDepthFirstIncludingLambdas.size() + " nodes: " + e.getMessage() + ", graph: " + String.valueOf(graph)));
        }
    }

    private static void createAssumeNodes(ControlFlowGraph graph) {
        for (ControlFlowNode node : graph.listDepthFirst()) {
            Condition condition = node.getCondition();
            if (condition == null || node.getSuccessors().size() < 2) continue;
            ControlFlowNode yesBranch = node.getYesBranch();
            ControlFlowNode noBranch = node.getNoBranch();
            DataflowHeuristicBase.createAssumeNode(node, yesBranch, condition.getYesBranchInfo());
            DataflowHeuristicBase.createAssumeNode(node, noBranch, condition.getNoBranchInfo());
        }
    }

    private static void createAssumeNode(ControlFlowNode node, ControlFlowNode branch, PairList<String, Boolean> branchInfo) {
        if (branchInfo.isEmpty()) {
            return;
        }
        VariableReadWriteInfo info = new VariableReadWriteInfo();
        for (int i = 0; i < branchInfo.size(); ++i) {
            VariableWrite write = new VariableWrite((String)branchInfo.getFirst(i));
            if (((Boolean)branchInfo.getSecond(i)).booleanValue()) {
                write.setNull();
            } else {
                write.setValue(ASSUME_NON_NULL_VALUE);
            }
            info.getAssignments().add(write);
        }
        ControlFlowNode assumeNode = new ControlFlowNode(info);
        ControlFlowNode.weaveBetween(node, branch, assumeNode);
    }
}

