/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.java;

import com.teamscale.index.dataflow.controlflowgraph.heuristics.clike.CLikeDataFlowHeuristicBase;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.java.rules.JavaCaseLabelRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.java.rules.MethodRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.java.rules.YieldRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.AnonymousBlockRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.ForRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.ReturnRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.SimpleStatementRule;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ExitStatementEntityMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.IShallowEntityMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityAndMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityOrMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityTokenPatternMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityTypeMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.SubTypeMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.filter.JavaSuppressWarningsUnusedEntityFilter;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

public class JavaDataFlowHeuristic
extends CLikeDataFlowHeuristicBase {
    public static final IShallowEntityMatcher OVERRIDE_ANNOTATION_MATCHER = new AnnotationEntityMatcher("Override", "java.lang.Override");
    public static final IShallowEntityMatcher SUPPRESS_WARNINGS_ANNOTATION_MATCHER = new AnnotationEntityMatcher(JavaSuppressWarningsUnusedEntityFilter.SUPPRESS_WARNINGS_ANNOTATIONS);
    public static final IShallowEntityMatcher ANNOTATION_MATCHER = new AnnotationEntityMatcher(new String[0]);
    private static final IShallowEntityMatcher ALL_ARROW_CASE_LABELS = new ShallowEntityAndMatcher(ALL_CASE_LABELS, new ShallowEntityTokenPatternMatcher(new TokenPattern().skipTo(new Object[]{ETokenType.ARROW}).endOfStream()));
    private static final ShallowEntityOrMatcher YIELD_OR_BREAK = new ShallowEntityOrMatcher(YIELD_SUBTYPE, BREAK_SUBTYPE);
    private static final PairList<IShallowEntityMatcher, IControlFlowRule> RULES = new PairList();

    @Override
    public PairList<String, List<ShallowEntity>> extractExecutables(String uniformPath, List<ShallowEntity> entities) {
        PairList executables = new PairList();
        this.recursivelyAddAllExecutables(entities, (PairList<String, List<ShallowEntity>>)executables);
        return executables;
    }

    private void recursivelyAddAllExecutables(List<ShallowEntity> entities, PairList<String, List<ShallowEntity>> executables) {
        for (int i = 0; i < entities.size(); ++i) {
            ShallowEntity entity = entities.get(i);
            if (ShallowEntityTypeMatcher.METHOD_MATCHER.matches(entity) && this.hasMethodBody(entity) && JavaDataFlowHeuristic.isEntrypoint(entity)) {
                ArrayList<ShallowEntity> executableEntities = new ArrayList<ShallowEntity>();
                JavaDataFlowHeuristic.addMethodAnnotations(entities, i, executableEntities);
                executableEntities.add(entity);
                executables.add((Object)entity.getName(), executableEntities);
            }
            if (!entity.hasChildren()) continue;
            this.recursivelyAddAllExecutables((List<ShallowEntity>)entity.getChildren(), executables);
        }
    }

    private static void addMethodAnnotations(List<ShallowEntity> entities, int i, List<ShallowEntity> executableEntities) {
        ShallowEntity annotationEntity;
        for (int k = i - 1; k >= 0 && ANNOTATION_MATCHER.matches(annotationEntity = entities.get(k)); --k) {
            executableEntities.add(0, annotationEntity);
        }
    }

    @Override
    protected PairList<IShallowEntityMatcher, IControlFlowRule> getRules() {
        PairList rules = new PairList(RULES);
        JavaDataFlowHeuristic.addDefaultRules((PairList<IShallowEntityMatcher, IControlFlowRule>)rules);
        return rules;
    }

    static {
        RULES.add((Object)new SubTypeMatcher("lambda"), (Object)new MethodRule());
        RULES.add((Object)new SubTypeMatcher("lambda expression"), (Object)new SimpleStatementRule(false));
        RULES.add((Object)new ExitStatementEntityMatcher("System.exit", "exit"), (Object)new ReturnRule());
        RULES.add((Object)new ExitStatementEntityMatcher("Assert.fail", "Fail.fail", "Fail.shouldHaveThrown", "Fail.failBecauseExceptionWasNotThrown", "Fail.shouldHaveThrown", "fail", "failBecauseExceptionWasNotThrown"), (Object)new ReturnRule());
        RULES.add((Object)new SubTypeMatcher("synchronized"), (Object)new AnonymousBlockRule());
        RULES.add((Object)FOR_SUBTYPE, (Object)new ForRule(ETokenType.COLON));
        RULES.add((Object)ShallowEntityTypeMatcher.METHOD_MATCHER, (Object)new MethodRule());
        RULES.add((Object)new SubTypeMatcher("class"), (Object)new SimpleStatementRule(false));
        RULES.add((Object)YIELD_SUBTYPE, (Object)new YieldRule());
        RULES.add((Object)ALL_ARROW_CASE_LABELS, (Object)JavaCaseLabelRule.ofArrowSwitch(CASE_SUBTYPE_BELOW_SWITCH, DEFAULT_SUBTYPE_BELOW_SWITCH, YIELD_OR_BREAK, RETURN_OR_THROW_STATEMENTS, "case"));
        RULES.add((Object)ALL_CASE_LABELS, (Object)JavaCaseLabelRule.ofColonSwitch(CASE_SUBTYPE_BELOW_SWITCH, DEFAULT_SUBTYPE_BELOW_SWITCH, YIELD_OR_BREAK, RETURN_OR_THROW_STATEMENTS, "case"));
    }

    public static class AnnotationEntityMatcher
    implements IShallowEntityMatcher {
        private final Set<String> names;

        public AnnotationEntityMatcher(String ... names) {
            this.names = CollectionUtils.asHashSet((Object[])names);
        }

        public AnnotationEntityMatcher(Collection<String> names) {
            this.names = new HashSet<String>(names);
        }

        @Override
        public boolean matches(ShallowEntity entity) {
            if (entity.getType() == EShallowEntityType.META && entity.getSubtype().equals("annotation")) {
                return this.names.isEmpty() || this.names.contains(entity.getName());
            }
            return false;
        }

        public String toString() {
            return "AnnotationEntityMatcher";
        }
    }
}

