/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.utils;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class StaticBooleanExpressionEvaluator {
    private static final int OPERATOR_GROUP_INDEX = 0;
    private static final int NOT_GROUP_INDEX = 1;
    private static final int SUBEXPRESSION_GROUP_INDEX = 2;
    private static final int FIRST_EXPRESSION_GROUP_INDEX = 3;
    private static final TokenPattern ATOMIC_PATTERN = new TokenPattern().alternative(new Object[]{ETokenType.BOOLEAN_LITERAL, new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER})});
    private static final TokenPattern GROUPED_PATTERN = new TokenPattern().skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false);
    private static final TokenPattern SUBEXPRESSION_PATTERN = new TokenPattern().alternative(new Object[]{ATOMIC_PATTERN, GROUPED_PATTERN});
    private static final Set<ETokenType> BOOLEAN_OPERATOR = Set.of(ETokenType.AND, ETokenType.ANDAND, ETokenType.OR, ETokenType.OROR, ETokenType.XOR);
    private static final TokenPattern NEXT_OPERAND_EXPRESSION_PATTERN = new TokenPattern().optional(new Object[]{BOOLEAN_OPERATOR}).group(0).optional(new Object[]{ETokenType.NOT}).group(1).sequence(new Object[]{SUBEXPRESSION_PATTERN}).group(2);
    private static final TokenPattern EXPRESSION_PATTERN = new TokenPattern().optional(new Object[]{ETokenType.NOT}).group(1).sequence(new Object[]{SUBEXPRESSION_PATTERN}).group(3).repeated(new Object[]{new TokenPattern().sequence(new Object[]{new TokenPattern().optional(new Object[]{BOOLEAN_OPERATOR}).optional(new Object[]{ETokenType.NOT}).sequence(new Object[]{SUBEXPRESSION_PATTERN})}).group(2)});

    public static Result evaluate(List<IToken> expression) {
        TokenPatternMatch match = EXPRESSION_PATTERN.matchFully(expression);
        if (match == null) {
            return Result.INVALID;
        }
        List firstOperand = match.getMatchGroup(3);
        if (firstOperand.size() != 1) {
            return Result.INVALID;
        }
        Result firstOperandResult = StaticBooleanExpressionEvaluator.parseExpression(((MatchGroupElement)firstOperand.getFirst()).getTokens());
        ArrayList<ETokenType> operators = new ArrayList<ETokenType>();
        ArrayList<Result> subexpressionResult = new ArrayList<Result>();
        boolean firstOperandNegated = !match.getMatchGroup(1).isEmpty();
        StaticBooleanExpressionEvaluator.evaluateNegation(firstOperandResult, firstOperandNegated, subexpressionResult);
        for (MatchGroupElement element : match.getMatchGroup(2)) {
            if (StaticBooleanExpressionEvaluator.parseOperatorAndOperand(element, operators, subexpressionResult)) continue;
            return Result.INVALID;
        }
        return StaticBooleanExpressionEvaluator.evaluateTopLevelExpression(operators, subexpressionResult);
    }

    private static Result parseExpression(List<IToken> tokens) {
        if (TokenStreamUtils.startsWithToken(tokens, (ETokenType[])new ETokenType[]{ETokenType.LPAREN})) {
            return StaticBooleanExpressionEvaluator.parseGroupedExpression(tokens);
        }
        TokenPatternMatch atomic = ATOMIC_PATTERN.matchFully(tokens);
        if (atomic == null) {
            return Result.INVALID;
        }
        if (new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).matchFully(tokens) != null) {
            return Result.UNKNOWN;
        }
        TokenPatternMatch literal = new TokenPattern().sequence(new Object[]{ETokenType.BOOLEAN_LITERAL}).matchFully(tokens);
        if (literal == null) {
            return Result.INVALID;
        }
        if (tokens.getFirst().getText().equals("true")) {
            return Result.ALWAYS_TRUE;
        }
        if (tokens.getFirst().getText().equals("false")) {
            return Result.ALWAYS_FALSE;
        }
        return Result.UNKNOWN;
    }

    private static Result parseGroupedExpression(List<IToken> tokens) {
        TokenPatternMatch match = GROUPED_PATTERN.matchFully(tokens);
        if (match == null) {
            return Result.INVALID;
        }
        tokens = tokens.subList(1, tokens.size() - 1);
        return StaticBooleanExpressionEvaluator.evaluate(tokens);
    }

    private static boolean parseOperatorAndOperand(MatchGroupElement element, List<ETokenType> operators, List<Result> subexpressionResult) {
        TokenPatternMatch nextOperand = NEXT_OPERAND_EXPRESSION_PATTERN.matchFully(element.getTokens());
        if (nextOperand == null) {
            return false;
        }
        List operator = nextOperand.getMatchGroup(0);
        if (operator.size() != 1) {
            return false;
        }
        operators.add(((IToken)((MatchGroupElement)operator.getFirst()).getTokens().getFirst()).getType());
        List subexpression = nextOperand.getMatchGroup(2);
        if (subexpression.isEmpty()) {
            return false;
        }
        Result operandResult = StaticBooleanExpressionEvaluator.parseExpression(((MatchGroupElement)subexpression.getFirst()).getTokens());
        boolean operandNegated = !nextOperand.getMatchGroup(1).isEmpty();
        StaticBooleanExpressionEvaluator.evaluateNegation(operandResult, operandNegated, subexpressionResult);
        return true;
    }

    private static void evaluateNegation(Result operandResult, boolean operandNegated, List<Result> subexpressionResult) {
        if (operandNegated && operandResult == Result.ALWAYS_TRUE) {
            subexpressionResult.add(Result.ALWAYS_FALSE);
        } else if (operandNegated && operandResult == Result.ALWAYS_FALSE) {
            subexpressionResult.add(Result.ALWAYS_TRUE);
        } else {
            subexpressionResult.add(operandResult);
        }
    }

    private static Result evaluateTopLevelExpression(List<ETokenType> operators, List<Result> subexpressionResult) {
        StaticBooleanExpressionEvaluator.evaluateTopLevelExpression(operators, subexpressionResult, ETokenType.AND);
        if (operators.isEmpty() && subexpressionResult.size() == 1) {
            return subexpressionResult.getFirst();
        }
        StaticBooleanExpressionEvaluator.evaluateTopLevelExpression(operators, subexpressionResult, ETokenType.XOR);
        if (operators.isEmpty() && subexpressionResult.size() == 1) {
            return subexpressionResult.getFirst();
        }
        StaticBooleanExpressionEvaluator.evaluateTopLevelExpression(operators, subexpressionResult, ETokenType.OR);
        if (operators.isEmpty() && subexpressionResult.size() == 1) {
            return subexpressionResult.getFirst();
        }
        StaticBooleanExpressionEvaluator.evaluateTopLevelExpression(operators, subexpressionResult, ETokenType.ANDAND);
        if (operators.isEmpty() && subexpressionResult.size() == 1) {
            return subexpressionResult.getFirst();
        }
        StaticBooleanExpressionEvaluator.evaluateTopLevelExpression(operators, subexpressionResult, ETokenType.OROR);
        if (!operators.isEmpty() && subexpressionResult.size() != 1) {
            return Result.INVALID;
        }
        if (subexpressionResult.size() != 1) {
            return Result.INVALID;
        }
        return subexpressionResult.getFirst();
    }

    private static void evaluateTopLevelExpression(List<ETokenType> operators, List<Result> subexpressionResult, ETokenType operator) {
        int operatorIndex = 0;
        while (operatorIndex < operators.size()) {
            if (operators.get(operatorIndex) == operator) {
                Result result = StaticBooleanExpressionEvaluator.evaluateBinaryBooleanEOperator(subexpressionResult.get(operatorIndex), subexpressionResult.get(operatorIndex + 1), operator);
                operators.remove(operatorIndex);
                subexpressionResult.set(operatorIndex, result);
                subexpressionResult.remove(operatorIndex + 1);
                operatorIndex = 0;
                continue;
            }
            ++operatorIndex;
        }
    }

    private static Result evaluateBinaryBooleanEOperator(Result a, Result b, ETokenType operator) {
        if (operator == ETokenType.OR || operator == ETokenType.OROR) {
            if (StaticBooleanExpressionEvaluator.isOrAlwaysTrue(a, b)) {
                return Result.ALWAYS_TRUE;
            }
            if (StaticBooleanExpressionEvaluator.isOrAlwaysFalse(a, b)) {
                return Result.ALWAYS_FALSE;
            }
            return Result.UNKNOWN;
        }
        if (operator == ETokenType.AND || operator == ETokenType.ANDAND) {
            if (StaticBooleanExpressionEvaluator.isAndAlwaysTrue(a, b)) {
                return Result.ALWAYS_TRUE;
            }
            if (StaticBooleanExpressionEvaluator.isAndAlwaysFalse(a, b)) {
                return Result.ALWAYS_FALSE;
            }
            return Result.UNKNOWN;
        }
        if (operator == ETokenType.XOR) {
            if (StaticBooleanExpressionEvaluator.isXorAlwaysFalse(a, b)) {
                return Result.ALWAYS_FALSE;
            }
            if (StaticBooleanExpressionEvaluator.isXorAlwaysTrue(a, b)) {
                return Result.ALWAYS_TRUE;
            }
            return Result.UNKNOWN;
        }
        return Result.INVALID;
    }

    private static boolean isOrAlwaysTrue(Result a, Result b) {
        return a == Result.ALWAYS_TRUE || b == Result.ALWAYS_TRUE;
    }

    private static boolean isOrAlwaysFalse(Result a, Result b) {
        return a == Result.ALWAYS_FALSE && b == Result.ALWAYS_FALSE;
    }

    private static boolean isAndAlwaysTrue(Result a, Result b) {
        return a == Result.ALWAYS_TRUE && b == Result.ALWAYS_TRUE;
    }

    private static boolean isAndAlwaysFalse(Result a, Result b) {
        return a == Result.ALWAYS_FALSE || b == Result.ALWAYS_FALSE;
    }

    private static boolean isXorAlwaysTrue(Result a, Result b) {
        return a == Result.ALWAYS_FALSE && b == Result.ALWAYS_TRUE || a == Result.ALWAYS_TRUE && b == Result.ALWAYS_FALSE;
    }

    private static boolean isXorAlwaysFalse(Result a, Result b) {
        return StaticBooleanExpressionEvaluator.isAndAlwaysTrue(a, b) || StaticBooleanExpressionEvaluator.isOrAlwaysFalse(a, b);
    }

    public static enum Result {
        UNKNOWN,
        ALWAYS_TRUE,
        ALWAYS_FALSE,
        INVALID;

    }
}

