/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph;

import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class TaintGraphParameter
extends TaintGraphReferenceBase {
    private static final long serialVersionUID = 1L;
    private final int parameterIndex;
    private final EnumSet<EParameterModifier> modifiers;
    private boolean isOptional;

    public TaintGraphParameter(String formalName, int parameterIndex, boolean isOptional, String ssaIndex, ElementLocation location, String referenceContainerMethodId, EParameterModifier ... modifiers) {
        this(formalName, parameterIndex, isOptional, ssaIndex, Arrays.asList(modifiers), location, referenceContainerMethodId);
    }

    public TaintGraphParameter(String formalName, int parameterIndex, boolean isOptional, String ssaIndex, List<EParameterModifier> modifiers, ElementLocation location, String referenceContainerMethodId) {
        super(formalName, ssaIndex, location, referenceContainerMethodId);
        this.parameterIndex = parameterIndex;
        this.isOptional = isOptional;
        this.modifiers = modifiers.isEmpty() ? EnumSet.noneOf(EParameterModifier.class) : EnumSet.copyOf(modifiers);
    }

    private TaintGraphParameter(String formalName, Integer parameterIndex, String ssaIndex, EnumSet<EParameterModifier> modifiers, ElementLocation location, String referenceContainerMethodId) {
        super(formalName, ssaIndex, location, referenceContainerMethodId);
        this.parameterIndex = parameterIndex;
        this.modifiers = modifiers;
    }

    @Override
    public TaintGraphReferenceBase.EReferenceType getType() {
        return TaintGraphReferenceBase.EReferenceType.PARAMETER;
    }

    public String toString() {
        return "P_" + this.parameterIndex + "_" + this.getReferenceName() + "^" + this.getSsaIndex();
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return ((TaintGraphParameter)obj).parameterIndex == this.parameterIndex && ((TaintGraphParameter)obj).modifiers.equals(this.modifiers);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCodeCache == null) {
            this.hashCodeCache = Objects.hash(super.hashCode(), this.parameterIndex, this.modifiers);
        }
        return this.hashCodeCache;
    }

    @Override
    public TaintGraphReferenceBase cloneWithNewSSA(String newSSAindex, ElementLocation location) {
        return new TaintGraphParameter(this.getReferenceName(), this.parameterIndex, newSSAindex, this.modifiers, location, this.referenceContainerMethodId);
    }

    public Set<EParameterModifier> getModifiers() {
        return Collections.unmodifiableSet(this.modifiers);
    }

    public boolean hasAnyModifierOf(EParameterModifier ... modifiers) {
        for (EParameterModifier modifier : modifiers) {
            if (!this.modifiers.contains((Object)modifier)) continue;
            return true;
        }
        return false;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    @Override
    public String toFindingDescription() {
        return "Possibly tainted parameter `" + this.getReferenceName() + "`";
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    @IndexValueClass
    public static enum EParameterModifier {
        CHANGING,
        USING,
        IMPORTING,
        EXPORTING,
        VALUE,
        TABLES;

    }
}

