/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import com.teamscale.index.dependencies.ITypeLookupEnvironment;
import com.teamscale.index.dependencies.TypeInfo;
import com.teamscale.index.dependencies.type.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.lib.commons.collections.CaseInsensitiveMap;

public class TypeLookupEnvironment
implements ITypeLookupEnvironment {
    private final Map<String, Type> knownTypes;
    private final Map<String, Boolean> prefixCache;
    private final Map<String, Optional<String>> suffixCache;
    private final Set<String> unresolvedTypes = new HashSet<String>();

    public TypeLookupEnvironment(Collection<TypeInfo> typeInfos, boolean caseInsensitive) {
        if (caseInsensitive) {
            this.knownTypes = new CaseInsensitiveMap();
            this.prefixCache = new CaseInsensitiveMap();
            this.suffixCache = new CaseInsensitiveMap();
        } else {
            this.knownTypes = new HashMap<String, Type>();
            this.prefixCache = new HashMap<String, Boolean>();
            this.suffixCache = new HashMap<String, Optional<String>>();
        }
        for (TypeInfo typeInfo : typeInfos) {
            List<Type> types = typeInfo.getTypes();
            for (Type type : types) {
                this.knownTypes.merge(type.getName(), type, (type1, type2) -> type1.merge((Type)type2, caseInsensitive));
            }
        }
    }

    @Override
    public boolean isKnownType(String fullQualifiedName) {
        return this.knownTypes.containsKey(fullQualifiedName);
    }

    @Override
    public boolean hasTypeWithPrefix(String prefix) {
        return this.cachedTypeLookupFunction(this.prefixCache, prefix, type -> type.startsWith(prefix), result -> true, false);
    }

    @Override
    public Optional<String> getTypeWithSuffixOverlap(String suffix) {
        return this.cachedTypeLookupFunction(this.suffixCache, suffix, type -> type.endsWith(suffix) || suffix.endsWith((String)type), Optional::of, Optional.empty());
    }

    private <K> K cachedTypeLookupFunction(Map<String, K> cache, String lookupKey, Predicate<String> knownTypePredicate, Function<String, K> ifContainedResult, K ifNotContainedResult) {
        if (cache.containsKey(lookupKey)) {
            return cache.get(lookupKey);
        }
        for (String knownType : this.knownTypes.keySet()) {
            if (!knownTypePredicate.test(knownType)) continue;
            K result = ifContainedResult.apply(knownType);
            cache.put(lookupKey, (String)result);
            return result;
        }
        cache.put(lookupKey, (String)ifNotContainedResult);
        return ifNotContainedResult;
    }

    @Override
    public Type lookupType(String fullQualifiedName) {
        return this.knownTypes.get(fullQualifiedName);
    }

    @Override
    public void registerUnresolvedType(String fullQualifiedName) {
        this.unresolvedTypes.add(fullQualifiedName);
    }

    @Override
    public Set<String> getUnresolvedTypes() {
        return this.unresolvedTypes;
    }

    @Override
    public void clearUnresolvedTypes() {
        this.unresolvedTypes.clear();
    }
}

