/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import com.teamscale.index.dependencies.ITypeIndex;
import com.teamscale.index.dependencies.ITypeLookupEnvironment;
import com.teamscale.index.dependencies.ProjectModule;
import com.teamscale.index.dependencies.ProjectModuleIndex;
import com.teamscale.index.dependencies.TypeInfo;
import com.teamscale.index.dependencies.TypeLookupEnvironment;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CaseInsensitiveMap;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;

public class TypeLookupEnvironmentFactory {
    private final Map<String, TypeInfo> uniformPathToTypes = new CaseInsensitiveMap();
    private final SetMap<String, ProjectModule> sourceFileToProjectModules = new SetMap<String, ProjectModule>(this){
        private static final long serialVersionUID = 1L;
        final /* synthetic */ TypeLookupEnvironmentFactory this$0;
        {
            TypeLookupEnvironmentFactory typeLookupEnvironmentFactory = this$0;
            Objects.requireNonNull(typeLookupEnvironmentFactory);
            this.this$0 = typeLookupEnvironmentFactory;
        }

        protected Map<String, Set<ProjectModule>> createUnderlyingMap() {
            return new CaseInsensitiveMap();
        }
    };
    private final SetMap<String, String> projectModuleToSourceFiles = new SetMap<String, String>(this){
        private static final long serialVersionUID = 1L;
        final /* synthetic */ TypeLookupEnvironmentFactory this$0;
        {
            TypeLookupEnvironmentFactory typeLookupEnvironmentFactory = this$0;
            Objects.requireNonNull(typeLookupEnvironmentFactory);
            this.this$0 = typeLookupEnvironmentFactory;
        }

        protected Map<String, Set<String>> createUnderlyingMap() {
            return new CaseInsensitiveMap();
        }
    };
    private final CaseInsensitiveMap<ProjectModule> projectModulesByName = new CaseInsensitiveMap();
    private final Map<String, ITypeLookupEnvironment> lookupEnvironmentCache = new HashMap<String, ITypeLookupEnvironment>();
    private final Map<String, Set<String>> visibleFilesCache = new HashMap<String, Set<String>>();
    private TypeLookupEnvironment allTypesLookupEnvironment = null;

    public TypeLookupEnvironmentFactory(ITypeIndex typeIndexCache, ProjectModuleIndex projectModuleIndex) throws StorageException {
        PairList<String, ProjectModule> projectModules = projectModuleIndex.getAllProjectModules();
        for (int i = 0; i < projectModules.size(); ++i) {
            ProjectModule projectModule = (ProjectModule)projectModules.getSecond(i);
            this.projectModulesByName.put((String)projectModules.getFirst(i), (Object)projectModule);
            Set<String> sourceFiles = TypeLookupEnvironmentFactory.getSourceFiles(projectModule, typeIndexCache);
            for (String sourceFile : sourceFiles) {
                this.sourceFileToProjectModules.add((Object)sourceFile, (Object)projectModule);
            }
            this.projectModuleToSourceFiles.addAll((Object)projectModule.getName(), sourceFiles);
        }
        this.uniformPathToTypes.putAll(typeIndexCache.getUniformPathToTypesMap());
    }

    private static Set<String> getSourceFiles(ProjectModule projectModule, ITypeIndex typeIndex) throws StorageException {
        HashSet<String> sourceFiles = new HashSet<String>();
        if (projectModule.isIncludeAllSourcesFromContainingDirectory()) {
            String parentPath = UniformPathUtils.getParentPath((String)projectModule.getName());
            if (StringUtils.isEmpty((String)parentPath)) {
                sourceFiles.addAll(typeIndex.getAllFiles());
            } else {
                sourceFiles.addAll(typeIndex.getFilesWithPathPrefix(parentPath + "/"));
            }
        } else {
            sourceFiles.addAll(projectModule.getSourceFiles());
        }
        return sourceFiles;
    }

    public ITypeLookupEnvironment getLookupEnvironment(String uniformPath, ELanguage language) {
        Set sourceModules = (Set)this.sourceFileToProjectModules.getCollection((Object)uniformPath);
        if (sourceModules == null || sourceModules.isEmpty()) {
            if (this.allTypesLookupEnvironment == null) {
                this.allTypesLookupEnvironment = new TypeLookupEnvironment(this.uniformPathToTypes.values(), language == ELanguage.PHP);
            }
            return this.allTypesLookupEnvironment;
        }
        String cacheKey = TypeLookupEnvironmentFactory.makeCacheKey(sourceModules);
        if (this.lookupEnvironmentCache.containsKey(cacheKey)) {
            return this.lookupEnvironmentCache.get(cacheKey);
        }
        HashSet<TypeInfo> visibleTypes = new HashSet<TypeInfo>(this.getVisibleTypes(sourceModules));
        TypeLookupEnvironment lookupEnvironment = new TypeLookupEnvironment(visibleTypes, language == ELanguage.PHP);
        this.lookupEnvironmentCache.put(cacheKey, lookupEnvironment);
        return lookupEnvironment;
    }

    public Set<String> reduceToVisibleFiles(String fromUniformPath, Collection<String> toUniformPaths) {
        Set sourceModules = (Set)this.sourceFileToProjectModules.getCollection((Object)fromUniformPath);
        if (CollectionUtils.isNullOrEmpty((Collection)sourceModules)) {
            return new HashSet<String>(toUniformPaths);
        }
        String cacheKey = TypeLookupEnvironmentFactory.makeCacheKey(sourceModules);
        Set visibleFiles = this.visibleFilesCache.computeIfAbsent(cacheKey, key -> this.getVisibleFiles(sourceModules));
        return CollectionUtils.intersectionSet(toUniformPaths, (Collection[])new Collection[]{visibleFiles});
    }

    private Set<TypeInfo> getVisibleTypes(Set<ProjectModule> sourceModules) {
        return this.getTypesForFiles(this.getVisibleFiles(sourceModules));
    }

    private Set<String> getVisibleFiles(Set<ProjectModule> sourceModules) {
        Set<ProjectModule> visibleModules = this.getReferencedModules(sourceModules);
        HashSet<String> visibleFiles = new HashSet<String>(this.getContainedFiles(sourceModules));
        visibleFiles.addAll(this.getContainedFiles(visibleModules));
        return visibleFiles;
    }

    private Set<String> getContainedFiles(Set<ProjectModule> modules) {
        HashSet<String> visibleFiles = new HashSet<String>();
        for (ProjectModule module : modules) {
            visibleFiles.addAll(this.projectModuleToSourceFiles.getCollectionOrEmpty((Object)module.getName()));
        }
        return visibleFiles;
    }

    private Set<TypeInfo> getTypesForFiles(Set<String> files) {
        HashSet<TypeInfo> visibleTypes = new HashSet<TypeInfo>();
        for (String file : files) {
            TypeInfo typeInfo = this.uniformPathToTypes.get(file);
            if (typeInfo == null) continue;
            visibleTypes.add(typeInfo);
        }
        return visibleTypes;
    }

    private Set<ProjectModule> getReferencedModules(Set<ProjectModule> sourceModules) {
        HashSet<ProjectModule> referencedModules = new HashSet<ProjectModule>();
        IdentityHashSet seenModules = new IdentityHashSet();
        for (ProjectModule sourceModule : sourceModules) {
            referencedModules.addAll(this.getReferencedModules(sourceModule, (IdentityHashSet<ProjectModule>)seenModules));
        }
        return referencedModules;
    }

    private Set<ProjectModule> getReferencedModules(ProjectModule module, IdentityHashSet<ProjectModule> seenModules) {
        seenModules.add((Object)module);
        HashSet<ProjectModule> referencedModules = new HashSet<ProjectModule>();
        for (String moduleReference : module.getModuleReferences()) {
            ProjectModule resolvedModule = this.resolveModuleReference(moduleReference);
            if (resolvedModule == null) continue;
            referencedModules.add(resolvedModule);
            if (!module.isTransitiveReferences() || seenModules.contains((Object)resolvedModule)) continue;
            referencedModules.addAll(this.getReferencedModules(resolvedModule, seenModules));
        }
        return referencedModules;
    }

    private ProjectModule resolveModuleReference(String moduleReference) {
        if (this.projectModulesByName.containsKey((Object)moduleReference)) {
            return (ProjectModule)this.projectModulesByName.get((Object)moduleReference);
        }
        for (String moduleName : this.projectModulesByName.keySet()) {
            if (!StringUtils.endsWithIgnoreCase((String)moduleReference, (String)moduleName)) continue;
            return (ProjectModule)this.projectModulesByName.get((Object)moduleName);
        }
        return null;
    }

    private static String makeCacheKey(Collection<ProjectModule> projectModules) {
        return StringUtils.concat((Iterable)CollectionUtils.sort(projectModules));
    }
}

