/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.cs;

import com.teamscale.index.dependencies.ShallowEntityTypeExtractorBase;
import com.teamscale.index.dependencies.cs.CsTypeVisitorBase;
import com.teamscale.index.dependencies.type.AttributeDefinition;
import com.teamscale.index.dependencies.type.MethodSignature;
import com.teamscale.index.dependencies.type.Type;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class CsTypeExtractor
extends ShallowEntityTypeExtractorBase {
    @Override
    protected List<Type> extractTypes(List<ShallowEntity> entities) {
        final ArrayList<Type> types = new ArrayList<Type>();
        CsTypeVisitorBase visitor = new CsTypeVisitorBase(this, true){
            {
                Objects.requireNonNull(this$0);
                super(includeDelegates);
            }

            @Override
            protected void visitType(ShallowEntity entity) {
                Type type = new Type(1.toQualifiedName(this.getCurrentNamespace(), entity.getName()), CsTypeExtractor.getAttributes(entity), CsTypeExtractor.getSuperTypes(entity), CsTypeExtractor.getMethods(entity));
                types.add(type);
            }
        };
        ShallowEntity.traverse(entities, (IShallowEntityVisitor)visitor);
        return types;
    }

    private static List<String> getSuperTypes(ShallowEntity type) {
        ArrayList<String> superTypes = new ArrayList<String>();
        UnmodifiableList tokens = type.ownStartTokens();
        int index = TokenStreamUtils.firstTokenOfTypeSequence((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.COLON, ETokenType.IDENTIFIER});
        if (index != -1) {
            while (index + 1 < tokens.size() && ((IToken)tokens.get(index)).getType() != ETokenType.LBRACE) {
                if (((IToken)tokens.get(index)).getType() == ETokenType.IDENTIFIER) {
                    superTypes.add(((IToken)tokens.get(index)).getText());
                }
                ++index;
            }
        }
        return superTypes;
    }

    private static List<MethodSignature> getMethods(ShallowEntity type) {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)type.getChildren(), (EShallowEntityType)EShallowEntityType.METHOD);
        return new ArrayList<MethodSignature>(CollectionUtils.filterAndMap((Collection)methods, attribute -> !StringUtils.isEmpty((String)attribute.getName()), entity -> new MethodSignature(entity.getName())));
    }

    private static ArrayList<AttributeDefinition> getAttributes(ShallowEntity type) {
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)type.getChildren(), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        return new ArrayList<AttributeDefinition>(CollectionUtils.filterAndMap((Collection)attributes, attribute -> !StringUtils.isEmpty((String)attribute.getName()), entity -> new AttributeDefinition(entity.getName())));
    }
}

