/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.javascript;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.javascript.ContextAwareJavascriptDependencyExtractor;
import com.teamscale.index.dependencies.javascript.JavascriptDependencyExtractor;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ListMap;

public class ES6DependencyExtractor
extends ContextAwareJavascriptDependencyExtractor {
    private static final TokenPattern DYNAMIC_IMPORT = new TokenPattern().sequence(new Object[]{ETokenType.IMPORT, ETokenType.LPAREN}).group(0).sequence(new Object[]{ETokenType.STRING_LITERAL}).group(1).sequence(new Object[]{ETokenType.RPAREN}).group(0);

    public ES6DependencyExtractor(JavascriptDependencyExtractor extractorContext) {
        super(extractorContext);
    }

    @Override
    protected ListMap<String, ElementLocation> getDependenciesLocations(TokenElementInfo tokenElementInfo) {
        ListMap locations = new ListMap();
        for (ShallowEntity entity : tokenElementInfo.getShallowEntitiesWithoutPreprocessorTokens()) {
            if (entity.getType() == EShallowEntityType.META) {
                this.extractDependenciesFromImportStatements(entity, tokenElementInfo, (ListMap<String, ElementLocation>)locations);
                continue;
            }
            this.extractDependenciesFromDynamicImportStatement(entity, tokenElementInfo, (ListMap<String, ElementLocation>)locations);
        }
        return locations;
    }

    private void extractDependenciesFromDynamicImportStatement(ShallowEntity entity, TokenElementInfo tokenElementInfo, ListMap<String, ElementLocation> locations) {
        List dynamicImports = DYNAMIC_IMPORT.findAll((List)entity.includedTokens());
        for (TokenPatternMatch dynamicImport : dynamicImports) {
            String importedPath = dynamicImport.groupString(1);
            this.extractorContext.resolveStarDependency(importedPath).forEach(typeName -> locations.add(typeName, (Object)DependencyExtractorBase.createLocation(tokenElementInfo.getUniformPath(), dynamicImport.groupTokens(0))));
        }
    }

    private void extractDependenciesFromImportStatements(ShallowEntity entity, TokenElementInfo tokenElementInfo, ListMap<String, ElementLocation> locations) {
        switch (entity.getSubtype()) {
            case "import": {
                this.addImportStatementDependency(entity, tokenElementInfo, locations);
                break;
            }
            case "star import": {
                this.addStarImportStatementDependency(entity, tokenElementInfo, locations);
                break;
            }
            case "default export import": 
            case "object export import": {
                this.addObjectOrDefaultExportImportStatementDependency(entity, tokenElementInfo, locations);
                break;
            }
        }
    }

    private void addImportStatementDependency(ShallowEntity entity, TokenElementInfo tokenElementInfo, ListMap<String, ElementLocation> locations) {
        if (entity.ownStartTokens().size() < 2) {
            return;
        }
        List<String> allImportedTypes = TokenStreamUtils.split((List)entity.ownStartTokens().subList(2, entity.ownStartTokens().size()), (ETokenType[])new ETokenType[]{ETokenType.COMMA}).stream().map(tokens -> ((IToken)tokens.get(0)).getText()).collect(Collectors.toList());
        String[] parts = Objects.requireNonNull(entity.getName()).split(":#from#:");
        CCSMAssert.isFalse((parts.length < 2 ? 1 : 0) != 0, (String)"Expected import separator in entity name");
        String importString = parts[1].trim();
        TextRegionLocation dependencyLocation = JavascriptDependencyExtractor.createDependencyLocation(tokenElementInfo, entity);
        this.extractorContext.resolveMemberDependencies(importString, allImportedTypes).forEach(fullTypeName -> locations.add(fullTypeName, (Object)dependencyLocation));
    }

    private void addStarImportStatementDependency(ShallowEntity entity, TokenElementInfo tokenElementInfo, ListMap<String, ElementLocation> locations) {
        this.extractorContext.resolveStarDependency(entity.getName()).forEach(typeName -> locations.add(typeName, (Object)JavascriptDependencyExtractor.createDependencyLocation(tokenElementInfo, entity)));
    }

    private void addObjectOrDefaultExportImportStatementDependency(ShallowEntity entity, TokenElementInfo tokenElementInfo, ListMap<String, ElementLocation> locations) {
        String suffix = entity.getSubtype().equals("default export import") ? "defaultExport" : "objectExport";
        this.extractorContext.resolveSingleDependency(entity.getName(), suffix).forEach(typeName -> locations.add(typeName, (Object)JavascriptDependencyExtractor.createDependencyLocation(tokenElementInfo, entity)));
    }
}

