/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.event_announcement;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass(containedInBackup=true)
public record EventAnnouncement(@Parameter(description="The ID of the event") @JsonProperty(value="eventId") String eventId, @Parameter(description="The timestamp when the event starts") @JsonProperty(value="startIsoLocalDateTime") String startIsoLocalDateTime, @Parameter(description="The timestamp when the event ends") @JsonProperty(value="endIsoLocalDateTime") String endIsoLocalDateTime, @Parameter(description="The timezone of the event") @JsonProperty(value="timezone") String timezone, @Parameter(description="The headline of the event announcement") @JsonProperty(value="headline") String headline, @Parameter(description="The description/details text of the event announcement") @JsonProperty(value="description") String description, @Parameter(description="The URL to which the 'learn more' link should point") @JsonProperty(value="learnMoreUrl") String learnMoreUrl) implements Serializable,
Comparable<EventAnnouncement>
{
    private static final long serialVersionUID = 1L;

    public ZonedDateTime getStartTime() {
        return LocalDateTime.parse(this.startIsoLocalDateTime).atZone(ZoneId.of(this.timezone));
    }

    public ZonedDateTime getEndTime() {
        return LocalDateTime.parse(this.endIsoLocalDateTime).atZone(ZoneId.of(this.timezone));
    }

    @Override
    public int compareTo(@NonNull EventAnnouncement other) {
        return this.getStartTime().compareTo(other.getStartTime());
    }
}

