/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="external.session.retention", name="External Upload Open Session Retention", type=EOptionType.SERVER, category=EOptionCategory.LIMITS)
@IndexValueClass(containedInBackup=true)
public class ExternalUploadSessionRetentionOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "external.session.retention";
    public static final String OPTION_NAME = "External Upload Open Session Retention";
    private static final int DEFAULT_MAX_AGE_DAYS = 30;
    private static final int DISABLED_VALUE = 0;
    @JsonProperty(value="maxAge")
    @OptionFieldDescription(name="Open upload session age limit", description="Age threshold in days. Open external upload sessions older than this are automatically removed. Set to 0 to disable completely.")
    public int maxAgeDays = 30;

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (this.maxAgeDays < 0) {
            return "Maximum open session age must not be negative.";
        }
        return null;
    }

    public static int getMaxAgeDays(ServerOptionIndex serverOptionIndex) throws StorageException {
        ExternalUploadSessionRetentionOption uploadSessionRetentionOption = (ExternalUploadSessionRetentionOption)ServerOptionRegistry.getInstance().getServerOption(OPTION_ID, ExternalUploadSessionRetentionOption.class, serverOptionIndex);
        if (uploadSessionRetentionOption == null) {
            return 30;
        }
        return uploadSessionRetentionOption.maxAgeDays;
    }

    public static boolean isDisabled(ServerOptionIndex optionIndex) throws StorageException {
        int configuredMaxAge = ExternalUploadSessionRetentionOption.getMaxAgeDays(optionIndex);
        return configuredMaxAge == 0;
    }
}

