/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.index.external.input.SessionBasedExternalAnalysisResultsTriggerBase;
import com.teamscale.index.external.input.external_storage.EExternalStorageBackendProtocol;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.SessionUploader;
import com.teamscale.index.external.input.external_storage.migration.MigratedArchivePathsIndex;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.repository.artifact_store.ArtifactStoreUtils;
import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import com.teamscale.index.repository.artifact_store.s3.S3ArchiveIndex;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.collections.DurableSet;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.lang.ObjectUtils;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class StoreAnalysisResultsInExternalStorageTrigger
extends SessionBasedExternalAnalysisResultsTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static UnmodifiableList<Duration> retryDelays = CollectionUtils.asUnmodifiable(List.of(Duration.ofMinutes(1L), Duration.ofMinutes(8L), Duration.ofMinutes(32L)));

    @TestOnly
    public static AutoCloseable setRetryDelaysForTesting(List<Duration> delays) {
        UnmodifiableList<Duration> oldRetryDelays = retryDelays;
        retryDelays = CollectionUtils.asUnmodifiable(new ArrayList<Duration>(delays));
        return () -> {
            retryDelays = oldRetryDelays;
        };
    }

    public static synchronized void schedule(InternalProjectId projectId, IndexLayer indexLayer, String schedulingReason) throws StorageException {
        if (StoreAnalysisResultsInExternalStorageTrigger.isAlreadyScheduled(projectId, indexLayer)) {
            LOGGER.debug("Skipped scheduling {} since it was already scheduled.", (Object)StoreAnalysisResultsInExternalStorageTrigger.class.getSimpleName());
            return;
        }
        ISchedulerCommunicator.getInstance().scheduleExternalJob(indexLayer, JobDescriptor.forProject((InternalProjectId)projectId).withPrivilegedTrigger(StoreAnalysisResultsInExternalStorageTrigger.class).withSchedulingReason(schedulingReason).withParameter((Object)new JobParameter(projectId)).build());
    }

    private static boolean isAlreadyScheduled(InternalProjectId internalProjectId, IndexLayer indexLayer) throws StorageException {
        ProjectAnalysisProgressIndex projectProgressIndex = (ProjectAnalysisProgressIndex)indexLayer.openNonHistorizedProjectIndex(ProjectAnalysisProgressIndex.class, indexLayer.resolveProject((IProjectId)internalProjectId));
        DurableSet scheduledJobs = projectProgressIndex.createJobQueueSet();
        return scheduledJobs.stream().anyMatch(job -> StoreAnalysisResultsInExternalStorageTrigger.class.getName().equals(job.getTriggerName()));
    }

    public void execute() throws Exception {
        JobParameter parameter = (JobParameter)this.jobDescriptor.getParameterObject(JobParameter.class);
        GlobalStorageSystem globalStorage = this.indexLayer.openGlobalStorageSystem();
        CommitResolvingStorageSystem projectStorage = this.indexLayer.openProjectStorageSystem((IProjectId)parameter.projectId());
        this.uploadSessions((ExternalAnalysisImportSessionIndex)projectStorage.openProjectIndex(ExternalAnalysisImportSessionIndex.class, null), StoreAnalysisResultsInExternalStorageTrigger.getProjectConfiguration((ProjectStorageSystem)projectStorage), (SupplierWithException<S3ArchiveIndex, StorageException>)((SupplierWithException)() -> StoreAnalysisResultsInExternalStorageTrigger.lambda$execute$0((ProjectStorageSystem)projectStorage)), (IExternalCredentialsProvider)StoreAnalysisResultsInExternalStorageTrigger.openExternalCredentialsIndex(globalStorage), (ExternalAnalysisStatusIndex)projectStorage.openProjectIndex(ExternalAnalysisStatusIndex.class, null), (MigratedArchivePathsIndex)globalStorage.openGlobalIndex(MigratedArchivePathsIndex.class));
    }

    private static S3ArchiveIndex openS3ArchiveIndex(ProjectStorageSystem projectStorage) throws StorageException {
        return (S3ArchiveIndex)projectStorage.openProjectIndex(S3ArchiveIndex.class, S3ArchiveIndex.createIndexName("external-analysis-data"), null);
    }

    private void uploadSessions(ExternalAnalysisImportSessionIndex sessionIndex, ProjectConfiguration projectConfiguration, SupplierWithException<S3ArchiveIndex, StorageException> s3ArchiveIndexSupplier, IExternalCredentialsProvider externalCredentialsProvider, ExternalAnalysisStatusIndex statusIndex, MigratedArchivePathsIndex migratedArchivePathsIndex) throws RepositoryException, RescheduleRequestedException, StorageException {
        try (SessionUploader sessionUploader = new SessionUploader(sessionIndex, migratedArchivePathsIndex, projectConfiguration, s3ArchiveIndexSupplier, externalStorage -> this.getClientForProtocol(externalCredentialsProvider, externalStorage), (ConsumerWithException<EExternalStorageBackendProtocol, StorageException>)((ConsumerWithException)protocol -> this.scheduleChangeRetriever(projectConfiguration, (EExternalStorageBackendProtocol)((Object)protocol))), LOGGER);){
            for (ExternalAnalysisSessionInfo session : CollectionUtils.filter((Collection)sessionIndex.getAllSessionInfos().getSecondList(), Predicate.not(ExternalAnalysisSessionInfo::isOpen))) {
                boolean isSuccess = sessionUploader.processSession(session);
                this.storeProcessingStatus(isSuccess, session, session.getCommit(), statusIndex, Collections.emptySet());
            }
        }
        catch (RepositoryException e) {
            Duration retryDelay = this.getRetryDelay().orElseThrow(() -> e);
            LOGGER.atWarn().withThrowable((Throwable)e).log("Failed to upload session(s); Retrying in {} seconds.", (Object)retryDelay.toSeconds());
            throw new RescheduleRequestedException((Throwable)e, Instant.now().plus(retryDelay));
        }
    }

    private void scheduleChangeRetriever(ProjectConfiguration projectConfiguration, EExternalStorageBackendProtocol protocol) throws StorageException {
        ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(this.indexLayer, projectConfiguration.getInternalId(), protocol.getChangeRetrieverTriggerName());
    }

    private Optional<Duration> getRetryDelay() {
        if (this.getRetryCount() >= retryDelays.size()) {
            return Optional.empty();
        }
        return Optional.of((Duration)retryDelays.get(this.getRetryCount()));
    }

    private SimpleArtifactStoreClientBase<?> getClientForProtocol(IExternalCredentialsProvider externalCredentialsProvider, ExternalStorageBackend externalStorage) throws StorageException, RepositoryException, ProjectConfigurationException {
        return ArtifactStoreUtils.getClientForProtocol(externalStorage, externalCredentialsProvider.getExternalCredentials(externalStorage.credentialsName()), this.indexLayer);
    }

    private static ExternalCredentialsIndex openExternalCredentialsIndex(GlobalStorageSystem globalStorageSystem) throws StorageException {
        return (ExternalCredentialsIndex)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class);
    }

    private static ProjectConfiguration getProjectConfiguration(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return (ProjectConfiguration)ObjectUtils.requireNonNullElseThrow((Object)ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)projectStorageSystem), () -> new StorageException("Could not find project configuration in project storage system '%s'.".formatted(projectStorageSystem.getStorageSystemId())));
    }

    public Set<String> getCrossCommitBlockingWriteStores() {
        return CollectionUtils.asHashSet((Object[])new String[]{"external-analysis-results"});
    }

    public Set<String> getWriteStores() {
        return CollectionUtils.unionSet((Collection)super.getWriteStores(), (Collection[])new Collection[]{Set.of("external-analysis-results", "external-analysis-session", "_meta")});
    }

    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.MAINTENANCE;
    }

    private static /* synthetic */ S3ArchiveIndex lambda$execute$0(ProjectStorageSystem projectStorage) throws StorageException {
        return StoreAnalysisResultsInExternalStorageTrigger.openS3ArchiveIndex(projectStorage);
    }

    @VisibleForTesting
    record JobParameter(InternalProjectId projectId) {
    }
}

