/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.upload_sessions;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.input.UploadRejectedException;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionModifier;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.RevisionResolver;
import com.teamscale.index.utils.ExternalUploadUtils;
import jakarta.ws.rs.BadRequestException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.function.PredicateWithException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ExternalAnalysisImportSessionManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IndexLayer indexLayer;
    private final ProjectStorageSystem projectStorage;
    private final InternalProjectId projectId;
    private final PredicateWithException<CommitDescriptor, StorageException> shouldRejectUpload;
    private final ExternalAnalysisImportSessionIndex sessionIndex;
    private final ExternalAnalysisImportSessionModifier sessionModifier;
    private final ListMap<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> knownRevisionsByCommitDescriptor;
    private final boolean isMigrating;

    private ExternalAnalysisImportSessionManager(IndexLayer indexLayer, InternalProjectId projectId, boolean isMigrating, PredicateWithException<CommitDescriptor, StorageException> shouldRejectUpload) throws StorageException {
        this.indexLayer = indexLayer;
        this.projectId = projectId;
        this.isMigrating = isMigrating;
        this.shouldRejectUpload = shouldRejectUpload;
        this.projectStorage = indexLayer.openProjectStorageSystem((IProjectId)projectId);
        this.sessionIndex = (ExternalAnalysisImportSessionIndex)this.projectStorage.openProjectIndex(ExternalAnalysisImportSessionIndex.class, null);
        this.sessionModifier = new ExternalAnalysisImportSessionModifier(this.sessionIndex);
        this.knownRevisionsByCommitDescriptor = ExternalAnalysisImportSessionManager.readKnownRevisionsByCommitDescriptor((RepositoryRevisionIndex)this.projectStorage.openProjectIndex(RepositoryRevisionIndex.class, null));
    }

    public ExternalAnalysisImportSessionManager(IndexLayer indexLayer, InternalProjectId projectId, PredicateWithException<CommitDescriptor, StorageException> shouldRejectUpload) throws StorageException {
        this(indexLayer, projectId, false, shouldRejectUpload);
    }

    public ExternalAnalysisImportSessionManager(IndexLayer indexLayer, InternalProjectId projectId) throws StorageException {
        this(indexLayer, projectId, (PredicateWithException<CommitDescriptor, StorageException>)((PredicateWithException)commit -> false));
    }

    public static ExternalAnalysisImportSessionManager createMigrationSessionManager(IndexLayer indexLayer, InternalProjectId projectId) throws StorageException {
        return new ExternalAnalysisImportSessionManager(indexLayer, projectId, true, (PredicateWithException<CommitDescriptor, StorageException>)((PredicateWithException)commit -> false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitSession(String sessionId) throws StorageException {
        Class<ExternalAnalysisImportSessionIndex> clazz = ExternalAnalysisImportSessionIndex.class;
        synchronized (ExternalAnalysisImportSessionIndex.class) {
            ExternalAnalysisSessionInfo session = this.sessionIndex.getSessionInfo(sessionId).orElseThrow(() -> new StorageException("Attempted to commit session '{}' but no session with this ID was found."));
            session.setCommitted();
            this.sessionIndex.storeSessionInfo(session);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ExternalAnalysisSessionInfo createSession(SessionCreationParameters parameters) throws BadRequestException, StorageException, UploadRejectedException {
        LOGGER.traceEntry("createSession({})", new Object[]{parameters});
        boolean targetsExternalStorage = parameters.targetStorage() != null;
        CommitDescriptor resolvedSessionCommit = this.resolveSessionCommit(parameters.commit(), parameters.userGivenRevision(), parameters.userGivenConnectorId(), parameters.username(), targetsExternalStorage);
        if (this.shouldRejectUpload.test((Object)resolvedSessionCommit)) {
            throw (UploadRejectedException)LOGGER.throwing(Level.TRACE, (Throwable)new UploadRejectedException(resolvedSessionCommit));
        }
        ExternalAnalysisImportSessionManager.checkBranchExists(resolvedSessionCommit.getBranchName(), this.indexLayer, this.projectId, targetsExternalStorage);
        Optional<RepositoryRevisionIndex.RevisionAndRepository> resolvedRevisionAndRepository = this.resolveRevisionAndRepository(parameters.userGivenConnectorId(), parameters.userGivenRevision(), resolvedSessionCommit, parameters.username());
        return this.createAndStoreSession(parameters, resolvedSessionCommit, resolvedRevisionAndRepository.map(RepositoryRevisionIndex.RevisionAndRepository::revision).orElse(null), resolvedRevisionAndRepository.map(RepositoryRevisionIndex.RevisionAndRepository::repositoryIdentifier).orElse(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalAnalysisSessionInfo createAndStoreSession(SessionCreationParameters parameters, CommitDescriptor resolvedSessionCommit, @Nullable String revision, @Nullable String repository) throws StorageException {
        Class<ExternalAnalysisSessionInfo> clazz = ExternalAnalysisSessionInfo.class;
        synchronized (ExternalAnalysisSessionInfo.class) {
            ExternalAnalysisSessionInfo session = this.buildSessionInfo(parameters, resolvedSessionCommit, revision, repository);
            this.sessionIndex.storeSessionInfo(session);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return (ExternalAnalysisSessionInfo)LOGGER.traceExit((Object)session);
        }
    }

    private ExternalAnalysisSessionInfo buildSessionInfo(SessionCreationParameters parameters, CommitDescriptor commit, @Nullable String revision, @Nullable String repository) throws StorageException {
        return ExternalAnalysisSessionInfo.builder().withSessionId(UUID.randomUUID().toString()).withUsername(parameters.username()).withMessage(parameters.uploadMessage()).withCommit(this.getUniqueSessionCommit(commit, parameters.targetStorage() != null)).withPartition(parameters.partition()).withUploadTimestamp(DateTimeUtils.millisNow()).withRevision(revision).withRepository(repository).withTargetStorage(parameters.targetStorage()).withIsMigrated(this.isMigrating).build();
    }

    private CommitDescriptor getUniqueSessionCommit(CommitDescriptor commit, boolean targetsExternalStorage) throws StorageException {
        LOGGER.traceEntry("Resolving unique session commit from '{}'.", new Object[]{commit.toString()});
        if (targetsExternalStorage) {
            return (CommitDescriptor)LOGGER.traceExit("Using '{}' without uniqueness check as external storage supports multiple sessions on same commit descriptor.", (Object)commit);
        }
        while (this.sessionIndex.hasDataForCommit(commit)) {
            commit = commit.cloneWithIncrementedTimestamp();
        }
        return (CommitDescriptor)LOGGER.traceExit("Found unique commit '{}'.", (Object)commit);
    }

    private Optional<RepositoryRevisionIndex.RevisionAndRepository> resolveRevisionAndRepository(@Nullable String userGivenRepositoryId, @Nullable String userGivenRevision, CommitDescriptor resolvedSessionCommit, String username) throws StorageException {
        if (userGivenRevision == null) {
            return this.resolveRevision(resolvedSessionCommit);
        }
        if (userGivenRepositoryId == null) {
            List cached = (List)this.knownRevisionsByCommitDescriptor.getCollectionOrEmpty((Object)resolvedSessionCommit);
            for (RepositoryRevisionIndex.RevisionAndRepository entry : cached) {
                if (!entry.revision().equals(userGivenRevision)) continue;
                return Optional.of(entry);
            }
            return Optional.of(new RepositoryRevisionIndex.RevisionAndRepository(userGivenRevision, this.resolveRepositoryWithKnownRevision(userGivenRevision, username)));
        }
        return Optional.of(new RepositoryRevisionIndex.RevisionAndRepository(userGivenRevision, userGivenRepositoryId));
    }

    private @Nullable String resolveRepositoryWithKnownRevision(String revision, String username) throws StorageException {
        Optional<Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository>> revisionAndRepository = RevisionResolver.resolveRevisionAndRepository(revision, null, username, this.projectId, this.indexLayer);
        return revisionAndRepository.map(commitDescriptorRevisionAndRepositoryPair -> ((RepositoryRevisionIndex.RevisionAndRepository)commitDescriptorRevisionAndRepositoryPair.getSecond()).repositoryIdentifier()).orElse(null);
    }

    private Optional<RepositoryRevisionIndex.RevisionAndRepository> resolveRevision(CommitDescriptor targetCommit) {
        List matchingRevisions = (List)this.knownRevisionsByCommitDescriptor.getCollectionOrEmpty((Object)targetCommit);
        if (matchingRevisions.size() != 1) {
            LOGGER.warn("Teamscale knows multiple revisions for this commit descriptor ({}). It cannot decide for any of them, so the migration will keep the upload timestamp-based. If it would choose one at random, we would risk randomly losing the data if the revision we've chosen is removed, even though the data might have been for a different revision.", (Object)matchingRevisions);
            return (Optional)LOGGER.traceExit(Optional.empty());
        }
        return (Optional)LOGGER.traceExit(Optional.of((RepositoryRevisionIndex.RevisionAndRepository)matchingRevisions.getFirst()));
    }

    private static ListMap<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> readKnownRevisionsByCommitDescriptor(RepositoryRevisionIndex repositoryRevisionIndex) throws StorageException {
        PairList<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> knownRevisionsFromIndex = repositoryRevisionIndex.getAllKnownRepositoryRevisions();
        ListMap revisionsByCommitDescriptors = new ListMap();
        for (Pair revisionsFromIndex : knownRevisionsFromIndex) {
            revisionsByCommitDescriptors.add((Object)((CommitDescriptor)revisionsFromIndex.getFirst()), (Object)((RepositoryRevisionIndex.RevisionAndRepository)revisionsFromIndex.getSecond()));
        }
        return revisionsByCommitDescriptors;
    }

    public Optional<ExternalAnalysisSessionInfo> getSessionInfo(String sessionId) throws StorageException {
        return this.sessionIndex.getSessionInfo(sessionId);
    }

    public void deleteSession(String sessionId) throws StorageException {
        this.sessionIndex.deleteSession(sessionId);
    }

    public void storeImportInfosForSession(ExternalAnalysisSessionInfo session, ExternalAnalysisImportInfos importInfos) throws StorageException {
        this.sessionModifier.storeImportInfosForSession(session, importInfos);
    }

    public void storeNewImportInfosForSession(ExternalAnalysisSessionInfo session, ExternalAnalysisImportInfos additionalImportInfos) throws StorageException {
        this.sessionModifier.storeNewImportInfosForSession(session, additionalImportInfos);
    }

    public boolean markSessionAsScheduled(String sessionId) throws StorageException {
        return this.sessionModifier.markSessionAsScheduled(sessionId);
    }

    private CommitDescriptor resolveSessionCommit(UnresolvedCommitDescriptor commit, @Nullable String revision, @Nullable String connectorId, String username, boolean targetsExternalStorage) throws StorageException {
        LOGGER.trace("Resolving session commit from {}", (Object)commit);
        if (targetsExternalStorage) {
            commit = ExternalAnalysisImportSessionManager.roundTimestampToRelatedCodeCommit(commit);
        }
        CommitDescriptor resolvedSessionCommit = RevisionResolver.resolveRevisionOrCommit(commit, revision, connectorId, username, this.projectId, this.indexLayer);
        if (targetsExternalStorage) {
            LOGGER.trace("Skipping timestamp adjustment for external storage backend for {}.", (Object)commit);
            return resolvedSessionCommit;
        }
        LOGGER.trace("Resolving corrected commit from {}", (Object)resolvedSessionCommit.toString());
        return this.getAdjustedCommit(resolvedSessionCommit);
    }

    private static void checkBranchExists(String branchName, IndexLayer indexLayer, InternalProjectId projectId, boolean targetsExternalStorage) throws StorageException {
        ProjectRepositoryChangeIndex projectRepositoryChangeIndex = (ProjectRepositoryChangeIndex)indexLayer.openProjectIndex((IProjectId)projectId, ProjectRepositoryChangeIndex.class, null);
        ProjectRepositoryChangeIndex.ProjectRepositoryStatus repositoryStatus = projectRepositoryChangeIndex.getRepositoryStatus();
        if (!branchName.equals(repositoryStatus.getDefaultBranchName()) && !repositoryStatus.getBranchNames().contains(branchName)) {
            Level logLevel = targetsExternalStorage ? Level.DEBUG : Level.WARN;
            LOGGER.log(logLevel, "Branch {} does not exist in Teamscale.", (Object)branchName);
        }
    }

    private CommitDescriptor getAdjustedCommit(CommitDescriptor proposedCommit) throws StorageException {
        return ExternalUploadUtils.getAdjustedCommit(proposedCommit, this.openExternalResultBranchingLayer(), true);
    }

    private CommitLayeringBranchingLayer openExternalResultBranchingLayer() throws StorageException {
        return new CommitLayeringBranchingLayer(this.projectStorage.openStoreChecked("external-analysis-results", ExternalAnalysisResultIndex.class, (IStorageSystem)this.projectStorage, true, null), (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout());
    }

    private static UnresolvedCommitDescriptor roundTimestampToRelatedCodeCommit(UnresolvedCommitDescriptor commit) {
        return new UnresolvedCommitDescriptor(commit.getBranchName(), ExternalAnalysisImportSessionManager.roundTimestampToRelatedCodeCommit(commit.getTimestamp()));
    }

    private static long roundTimestampToRelatedCodeCommit(long timestamp) {
        long timestampOffset = timestamp % 1000L;
        if (timestampOffset == 0L) {
            return timestamp;
        }
        if (timestampOffset > 500L) {
            return timestamp;
        }
        return timestamp - timestampOffset;
    }

    public record SessionCreationParameters(@Nullable ExternalStorageBackend targetStorage, String partition, String uploadMessage, @Nullable String userGivenConnectorId, String username, UnresolvedCommitDescriptor commit, @Nullable String userGivenRevision) {
    }
}

