/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.tools;

import com.google.common.collect.Lists;
import com.teamscale.core.analysis.IndexDelta;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.runtime.impl.worker.RecordingStore;
import com.teamscale.index.external.ExternalAnalysisCommitInfo;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.InconsistentCommitException;
import com.teamscale.index.external.input.IntegrateImportedAnalysisResultsTrigger;
import com.teamscale.index.external.result.ExternalAnalysisResultFindings;
import com.teamscale.index.external.result.ExternalAnalysisResultIssues;
import com.teamscale.index.external.result.ExternalAnalysisResultLineCoverage;
import com.teamscale.index.external.result.ExternalAnalysisResultProbeCoverage;
import com.teamscale.index.external.result.ExternalAnalysisResultProcessStepInfo;
import com.teamscale.index.external.result.ExternalAnalysisResults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.core.pattern.StringTransformation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.ECommitStatus;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;

public final class ExternalAnalysisResultIndexUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> EXTERNAL_ANALYSIS_RESULTS_CLASSES_THAT_ALLOW_PATH_TRANSFORMATION = new HashSet<String>(CollectionUtils.map(Arrays.asList(ExternalAnalysisResultIssues.class, ExternalAnalysisResultProbeCoverage.class, ExternalAnalysisResultProcessStepInfo.class, ExternalAnalysisResultLineCoverage.class), Class::getCanonicalName));
    private static final SchemaEntry EXTERNAL_ANALYSIS_RESULT_INDEX_SCHEMA = new SchemaEntry(ExternalAnalysisResultIndex.class);
    private static final int MAX_BATCH_UNIFORM_KEY_COUNT = 1000;

    public static ExternalAnalysisCommitInfo copyCommit(ParentedCommitDescriptor commitDescriptor, IStore inputStore, IStore outputStore) throws StorageException, InconsistentCommitException {
        return ExternalAnalysisResultIndexUtils.copyCommit(commitDescriptor, inputStore, outputStore, new IncludeExcludeAntPatternSupport(), new HashSet<String>(), Function.identity(), new StringTransformation());
    }

    public static ExternalAnalysisCommitInfo copyCommit(ParentedCommitDescriptor commitDescriptor, IStore inputStore, IStore outputStore, IncludeExcludeAntPatternSupport includeExclude, Set<String> findingCategoriesToRemove, Function<String, String> pathTransformationFunction, StringTransformation partitionRename) throws StorageException, InconsistentCommitException {
        ExternalAnalysisResultIndex inputIndex = ExternalAnalysisResultIndexUtils.createInputIndex(commitDescriptor.getCommit(), inputStore);
        ExternalAnalysisCommitInfo inputCommitInfo = (ExternalAnalysisCommitInfo)((Object)inputIndex.getCommitInfo());
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> ((ParentedCommitDescriptor)commitDescriptor).toString();
        supplierArray[1] = inputCommitInfo::getPartition;
        supplierArray[2] = () -> Optional.ofNullable(inputCommitInfo.getFileDelta()).map(IndexDelta::size).orElse(0);
        LOGGER.debug("copyCommit: commitDescriptor={}, partition={}, deltaSize={}", supplierArray);
        if (!inputCommitInfo.getCommit().equals((Object)commitDescriptor.getCommit())) {
            throw new InconsistentCommitException(String.format("Unexpected commit info read from store: got '%s', but should be '%s'. Possibly inconsistent head commit on branch '%s'.", inputCommitInfo.getCommit(), commitDescriptor, commitDescriptor.getBranchName()));
        }
        String originalPartition = inputCommitInfo.getPartition();
        String renamedPartition = partitionRename.apply(originalPartition);
        List originalPaths = CollectionUtils.filter(inputIndex.getAllElementPaths(originalPartition), arg_0 -> ((IncludeExcludeAntPatternSupport)includeExclude).isIncluded(arg_0));
        List transformedPaths = CollectionUtils.map((Collection)originalPaths, pathTransformationFunction);
        commitDescriptor = ExternalAnalysisResultIndexUtils.removeDanglingFirstParentIfNecessary(commitDescriptor, inputStore);
        RecordingStore recordingStore = ExternalAnalysisResultIndexUtils.createRecordingOutputStore(commitDescriptor, outputStore);
        ExternalAnalysisResultIndex resultIndex = new ExternalAnalysisResultIndex((IStore)recordingStore);
        ExternalAnalysisResultIndexUtils.removeNoLongerExistingElementResults(resultIndex, originalPartition, transformedPaths);
        List originalPathChunks = Lists.partition((List)originalPaths, (int)1000);
        List transformedPathChunks = Lists.partition((List)transformedPaths, (int)1000);
        CollectionUtils.forEachWithException((Collection)originalPathChunks, (Collection)transformedPathChunks, (originalPathChunk, transformedPathChunk) -> {
            List<ExternalAnalysisResults> elementResults = inputIndex.getAnalysisResults(originalPartition, (List<String>)originalPathChunk);
            ExternalAnalysisResultIndexUtils.storeElementResults(renamedPartition, originalPathChunk, transformedPathChunk, elementResults, resultIndex, findingCategoriesToRemove);
        });
        KeyDelta uniformPathDelta = IntegrateImportedAnalysisResultsTrigger.stripPartitionPrefix(recordingStore.obtainDelta(), originalPartition);
        ExternalAnalysisCommitInfo outputCommit = new ExternalAnalysisCommitInfo(inputCommitInfo, uniformPathDelta, renamedPartition);
        resultIndex.setCommitInfo(outputCommit);
        return outputCommit;
    }

    private static @NonNull ParentedCommitDescriptor removeDanglingFirstParentIfNecessary(ParentedCommitDescriptor commitDescriptor, IStore inputStore) throws StorageException {
        CommitDescriptor firstParentCommit;
        CommitLayeringBranchingLayer branchingLayer;
        if (!(commitDescriptor.getParentCommits().isEmpty() || (branchingLayer = new CommitLayeringBranchingLayer(inputStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout())).commitExists((firstParentCommit = commitDescriptor.getFirstParentCommit()).getBranchName(), firstParentCommit.getTimestamp()) || commitDescriptor.getCommit().isOnSameBranchAs(firstParentCommit))) {
            LOGGER.warn("Parent for commit {} ({}) does not exist (parent: {} ({})). Removing link to parent.", (Object)commitDescriptor.getBranchName(), (Object)commitDescriptor.getTimestamp(), (Object)firstParentCommit.getBranchName(), (Object)firstParentCommit.getTimestamp());
            UnmodifiableList newParents = Collections.emptyList();
            if (commitDescriptor.getParentCommits().size() > 1) {
                newParents = commitDescriptor.getParentCommits().subList(1, commitDescriptor.getParentCommits().size());
            }
            commitDescriptor = new ParentedCommitDescriptor(commitDescriptor.getCommit(), newParents);
        }
        return commitDescriptor;
    }

    public static ExternalAnalysisResultIndex createInputIndex(CommitDescriptor commitDescriptor, IStore inputStore) throws StorageException {
        IStore historizedInputStore = HistoryAccessOption.readTimestamp((String)commitDescriptor.getBranchName(), (long)commitDescriptor.getTimestamp()).createStore(inputStore, EXTERNAL_ANALYSIS_RESULT_INDEX_SCHEMA);
        return new ExternalAnalysisResultIndex(historizedInputStore);
    }

    static RecordingStore createRecordingOutputStore(ParentedCommitDescriptor commitDescriptor, IStore outputStore) throws StorageException {
        ExternalAnalysisResultIndexUtils.debugCheckForSealedCommit(commitDescriptor.getCommit(), outputStore);
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readHeadWriteTimestamp((String)commitDescriptor.getBranchName(), (long)commitDescriptor.getTimestamp());
        if (!commitDescriptor.getParentCommits().isEmpty()) {
            CommitDescriptor parentCommit = (CommitDescriptor)commitDescriptor.getParentCommits().getFirst();
            historyAccessOption.setExplicitParentCommit(parentCommit.getBranchName(), parentCommit.getTimestamp());
        }
        IStore historizedOutputStore = historyAccessOption.createStore(outputStore, EXTERNAL_ANALYSIS_RESULT_INDEX_SCHEMA);
        return new RecordingStore(historizedOutputStore);
    }

    private static void debugCheckForSealedCommit(CommitDescriptor commitDescriptor, IStore outputStore) throws StorageException {
        CommitLayeringBranchingLayer branchingLayer = new CommitLayeringBranchingLayer(outputStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout());
        if (!branchingLayer.commitExists(commitDescriptor.getBranchName(), commitDescriptor.getTimestamp())) {
            return;
        }
        IBranchCommitInfo commitInfo = branchingLayer.readCommit(commitDescriptor.getBranchName(), commitDescriptor.getTimestamp());
        if (commitInfo != null && commitInfo.getStatus() != ECommitStatus.WRITEABLE) {
            LOGGER.error("createRecordingOutputStore: Attempt to create output store on existing SEALED commit - commitDescriptor={}\n This will lead to an unrecoverable error down the line. Increase the logging level to DEBUG or TRACE for the components involved in backup imports to obtain more detailed information.", (Object)commitDescriptor);
        }
    }

    static void storeElementResults(String partition, List<String> originalPaths, List<String> transformedPaths, List<ExternalAnalysisResults> elementResults, ExternalAnalysisResultIndex resultIndex, Set<String> findingCategoriesToRemove) throws StorageException {
        PairList pathToResultValues = new PairList();
        for (int i = 0; i < transformedPaths.size(); ++i) {
            ExternalAnalysisResults elementResult = elementResults.get(i);
            if (elementResult == null) {
                LOGGER.error("Missing external analysis data for path {} in partition {}. Skipping.", (Object)originalPaths.get(i), (Object)partition);
                continue;
            }
            elementResult.executeOnType(ExternalAnalysisResultFindings.class, ExternalAnalysisResultIndexUtils::removeAnalysisTimestamp);
            elementResult.executeOnType(ExternalAnalysisResultFindings.class, findings -> ExternalAnalysisResultIndexUtils.removeFindingsOfCategory(findings, findingCategoriesToRemove));
            elementResult.removeIfType(ExternalAnalysisResultFindings.class, findings -> findings.getData().isEmpty());
            if (elementResult.isEmpty()) continue;
            if (!originalPaths.get(i).equals(transformedPaths.get(i))) {
                ExternalAnalysisResultIndexUtils.assertAllExternalDataIsPathMappable(elementResult);
            }
            pathToResultValues.add((Object)transformedPaths.get(i), (Object)elementResult);
        }
        resultIndex.setAnalysisResults(partition, (PairList<String, ExternalAnalysisResults>)pathToResultValues);
    }

    private static void removeNoLongerExistingElementResults(ExternalAnalysisResultIndex resultIndex, String partition, List<String> mappedPaths) throws StorageException {
        HashSet<String> pathsToRemove = new HashSet<String>(resultIndex.getAllElementPaths(partition));
        CollectionUtils.removeAll(pathsToRemove, mappedPaths);
        resultIndex.removeElementResults(partition, new ArrayList<String>(pathsToRemove));
    }

    private static void removeFindingsOfCategory(ExternalAnalysisResultFindings findings, Set<String> findingCategoriesToRemove) {
        findings.removeIf(finding -> findingCategoriesToRemove.contains(finding.getCategoryName()));
    }

    private static void assertAllExternalDataIsPathMappable(ExternalAnalysisResults elementResults) {
        Set unsupportedResults = CollectionUtils.subtract(elementResults.getCanonicalTypeNames(), EXTERNAL_ANALYSIS_RESULTS_CLASSES_THAT_ALLOW_PATH_TRANSFORMATION);
        if (!unsupportedResults.isEmpty()) {
            throw new AssertionError((Object)("Store contains external analysis data that don't support path transformation: " + String.valueOf(unsupportedResults)));
        }
    }

    static ExternalAnalysisCommitInfo writeCommit(ExternalAnalysisCommitInfo commit, RecordingStore recordingStore, ExternalAnalysisResultIndex resultIndex) throws StorageException {
        KeyDelta delta = IntegrateImportedAnalysisResultsTrigger.stripPartitionPrefix(recordingStore.obtainDelta(), commit.getPartition());
        ExternalAnalysisCommitInfo outputCommit = new ExternalAnalysisCommitInfo(commit, delta);
        resultIndex.setCommitInfo(outputCommit);
        return outputCommit;
    }

    private static void removeAnalysisTimestamp(ExternalAnalysisResultFindings externalAnalysisResult) {
        Iterator iterator = externalAnalysisResult.getData().iterator();
        while (iterator.hasNext()) {
            IndexFinding finding = (IndexFinding)iterator.next();
            finding.setAnalysisTimestamp(1L);
        }
    }

    private ExternalAnalysisResultIndexUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

