/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.configuration.LanguageAdjustmentConfiguration;
import com.teamscale.index.findings.CppToolAnalysisTokenElementDetails;
import com.teamscale.index.findings.clangtidy.ShallowCodeFileRepresentation;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.CompilationCommand;
import com.teamscale.index.resource.CompileCommandIndex;
import com.teamscale.index.resource.CppSystemIncludeDirectories;
import com.teamscale.index.resource.FileIncludeLookup;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.IncludePathDetail;
import com.teamscale.index.resource.element_details.InitialMacroDefinitionsDetail;
import com.teamscale.index.resource.element_details.TargetTripleElementDetail;
import eu.cqse.check.framework.preprocessor.c.IncludeDirective;
import eu.cqse.check.framework.preprocessor.c.MacroDefinition;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class CppIncludeHandler {
    private final BasicTokenElementIndex basicTokenElementIndex;
    private final CompileCommandIndex compileCommandIndex;
    private final FileIncludeLookup includeLookup;
    private final Map<String, ShallowCodeFileRepresentation> cachedIncludeContent = new HashMap<String, ShallowCodeFileRepresentation>();
    private final ILockProvider lockProvider;
    private final ConcurrentHashMap<String, List<IncludeDirective>> includeDirectivesCache = new ConcurrentHashMap();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> NULL_ATTRIBUTES = Set.of("__nullable", "__nonnull", "__null_unspecified", "__nullable_result", "_Nullable", "_Nonnull", "_Null_unspecified", "_Nullable_result");

    public CppIncludeHandler(BasicTokenElementIndex basicTokenElementIndex, CompileCommandIndex compileCommandIndex, FileIncludeLookup includeLookup, ILockProvider lockProvider) {
        this.basicTokenElementIndex = basicTokenElementIndex;
        this.compileCommandIndex = compileCommandIndex;
        this.includeLookup = includeLookup;
        this.lockProvider = lockProvider;
    }

    public Set<IncludeFile> determineRelevantIncludeFiles(BasicTokenElementInfo element, Set<String> seenIncludes, List<String> resolvedIncludeSearchPaths) throws StorageException {
        this.cacheIncludeDirectivesFromElement(element);
        ShallowCodeFileRepresentation shallowCodeRepresentation = ShallowCodeFileRepresentation.fromBasicTokenElementInfo(element);
        return this.determineRelevantIncludeFiles(shallowCodeRepresentation, seenIncludes, resolvedIncludeSearchPaths);
    }

    private Set<IncludeFile> determineRelevantIncludeFiles(ShallowCodeFileRepresentation element, Set<String> seenIncludes, List<String> resolvedIncludeSearchPaths) throws StorageException {
        HashSet<IncludeFile> relevantFiles = new HashSet<IncludeFile>();
        List<IncludeDirective> includeDirectives = this.getIncludeDirectivesFromElement(element);
        for (IncludeDirective includeDirective : includeDirectives) {
            String includeUniformPath;
            ShallowCodeFileRepresentation includeElement;
            Optional<IncludeFile> includeFile;
            if (!seenIncludes.add(includeDirective.getIncludedFilePath()) || !(includeFile = this.resolveIncludeFile(includeDirective, element.uniformPath(), resolvedIncludeSearchPaths, true)).isPresent() || (includeElement = this.loadIncludeElement(includeUniformPath = includeFile.get().uniformPath)) == null) continue;
            relevantFiles.add(includeFile.get());
            relevantFiles.addAll(this.determineRelevantIncludeFiles(includeElement, seenIncludes, resolvedIncludeSearchPaths));
        }
        return relevantFiles;
    }

    private List<IncludeDirective> getIncludeDirectivesFromElement(ShallowCodeFileRepresentation element) {
        return this.includeDirectivesCache.computeIfAbsent(element.uniformPath(), path -> IncludeDirective.createFromTokens(CppIncludeHandler.getTokens(element)));
    }

    private void cacheIncludeDirectivesFromElement(BasicTokenElementInfo element) {
        this.includeDirectivesCache.computeIfAbsent(element.getUniformPath(), path -> IncludeDirective.createFromTokens((List)ScannerUtils.getTokens((String)element.getText(), (ELanguage)element.getLanguage(), (String)element.getUniformPath())));
    }

    @VisibleForTesting
    Optional<IncludeFile> resolveIncludeFile(IncludeDirective includeDirective, String includingUniformPath, List<String> includeSearchPaths, boolean ignoreIncludeNext) {
        String includeUniformPath;
        IncludeDirective finalIncludeDirective = includeDirective;
        if (ignoreIncludeNext && includeDirective.isIncludeNext()) {
            finalIncludeDirective = includeDirective.createCopyIgnoringIncludeNext();
        }
        if ((includeUniformPath = (String)this.includeLookup.resolveIncludeToUniformPathWithCStandardLookup(finalIncludeDirective, includingUniformPath, includeSearchPaths, false).orElse(null)) != null) {
            return Optional.of(new IncludeFile(includeUniformPath, null));
        }
        includeUniformPath = this.includeLookup.resolveIncludeToUniformPathWithHeuristic(finalIncludeDirective, includingUniformPath).orElse(null);
        if (includeUniformPath != null) {
            return Optional.of(new IncludeFile(includeUniformPath, CppIncludeHandler.determineNecessaryIncludePath(finalIncludeDirective.getIncludedFilePath(), includeUniformPath)));
        }
        return Optional.empty();
    }

    private static String determineNecessaryIncludePath(String includedName, String actualIncludedFilePath) {
        String cleanIncludedName = UniformPathUtils.cleanPath((String)includedName);
        if (actualIncludedFilePath.endsWith(cleanIncludedName)) {
            return StringUtils.stripSuffix((String)actualIncludedFilePath, (String)cleanIncludedName);
        }
        return UniformPathUtils.getParentPath((String)actualIncludedFilePath);
    }

    private static List<IToken> getTokens(ShallowCodeFileRepresentation element) {
        return ScannerUtils.getTokens((String)element.textContent(), (ELanguage)element.language(), (String)element.uniformPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ShallowCodeFileRepresentation loadIncludeElement(String includeUniformPath) throws StorageException {
        ShallowCodeFileRepresentation includeElement = this.cachedIncludeContent.get(includeUniformPath);
        if (includeElement != null) {
            return includeElement;
        }
        Lock lock = this.lockProvider.obtainLock(includeUniformPath);
        lock.lock();
        try {
            includeElement = this.cachedIncludeContent.get(includeUniformPath);
            if (includeElement != null) {
                ShallowCodeFileRepresentation shallowCodeFileRepresentation = includeElement;
                return shallowCodeFileRepresentation;
            }
            BasicTokenElementInfo includedElement = this.basicTokenElementIndex.getTokenElement(includeUniformPath);
            if (includedElement != null) {
                includeElement = ShallowCodeFileRepresentation.fromBasicTokenElementInfo(includedElement);
            }
            this.cachedIncludeContent.put(includeUniformPath, includeElement);
            ShallowCodeFileRepresentation shallowCodeFileRepresentation = includeElement;
            return shallowCodeFileRepresentation;
        }
        finally {
            lock.unlock();
        }
    }

    public List<String> determineCompilerCommands(BasicTokenElementInfo element, Set<IncludeFile> relevantIncludeFiles, CppToolAnalysisTokenElementDetails tokenElementDetails, boolean analysisToolIsCppcheck) throws StorageException {
        ArrayList<String> localCompilerArguments = new ArrayList<String>();
        String uniformPath = element.getUniformPath();
        CompilationCommand compilationCommand = this.compileCommandIndex.getCommands(List.of(uniformPath)).stream().filter(Objects::nonNull).findAny().orElse(CompilationCommand.getDefaultCompilationCommand());
        localCompilerArguments.add(compilationCommand.getCompilerCommand());
        localCompilerArguments.addAll(compilationCommand.getOtherOptions());
        CppIncludeHandler.addTargetTripleIfMissing(localCompilerArguments, tokenElementDetails, uniformPath);
        CppIncludeHandler.getLanguageArgument(element).ifPresent(localCompilerArguments::addLast);
        localCompilerArguments.addAll(CppIncludeHandler.getArgumentsFromCompilationDatabase(tokenElementDetails.getIncludePathDetail(uniformPath)));
        InitialMacroDefinitionsDetail initialMacroDefinitions = tokenElementDetails.getInitialMacroDefinitionsDetail(uniformPath);
        localCompilerArguments.addAll(CppIncludeHandler.getArgumentsFromMacroDefinitions(initialMacroDefinitions, analysisToolIsCppcheck));
        HashSet<String> heuristicResolutionIncludePaths = new HashSet<String>();
        for (IncludeFile includeFile : relevantIncludeFiles) {
            if (includeFile.requiredIncludePathForHeuristicInclude == null) continue;
            heuristicResolutionIncludePaths.add(includeFile.requiredIncludePathForHeuristicInclude);
        }
        for (String heuristicResolutionIncludePath : heuristicResolutionIncludePaths) {
            String additionalIncludePath = "-I." + UniformPathUtils.SEPARATOR + heuristicResolutionIncludePath;
            if (localCompilerArguments.contains(additionalIncludePath)) continue;
            localCompilerArguments.add(additionalIncludePath);
        }
        return localCompilerArguments;
    }

    private static void addTargetTripleIfMissing(List<String> args, CppToolAnalysisTokenElementDetails tokenElementDetails, String uniformPath) {
        TargetTripleElementDetail targetTripleElementDetail = tokenElementDetails.getTargetTripleDetail(uniformPath);
        String targetTriple = null;
        if (targetTripleElementDetail != null) {
            targetTriple = targetTripleElementDetail.getTargetTriple();
        }
        if (targetTriple != null && !targetTriple.isEmpty()) {
            if (args.contains("-target ") || args.contains("--target=")) {
                LOGGER.warn("Skipping target defined in the profile/code scope, since there's a target argument already defined in the compilation database for uniform path {}", (Object)uniformPath);
            } else {
                args.addLast(targetTriple);
            }
        }
    }

    private static Optional<String> getLanguageArgument(BasicTokenElementInfo element) {
        ELanguage detectedLanguage = element.getLanguage();
        if (!detectedLanguage.isCppOrC() && !detectedLanguage.isObjectiveCOrObjectiveCpp()) {
            LOGGER.error("Running cppcheck or clang-tidy on file that is not detected as C/C++/Objective-C/Objective-C++. Uniform path: {}", (Object)element.getUniformPath());
            return Optional.empty();
        }
        return Optional.of("-x " + detectedLanguage.getReadableName().toLowerCase());
    }

    private static List<String> getArgumentsFromCompilationDatabase(@Nullable IncludePathDetail includePathDetail) {
        if (includePathDetail != null) {
            return includePathDetail.getIncludePathOptions();
        }
        return Collections.emptyList();
    }

    public static Optional<IncludePathDetail> getIncludePathDetail(TokenElementInfo element) {
        return element.getFirstDetailOfType(IncludePathDetail.class);
    }

    private static List<String> getArgumentsFromMacroDefinitions(InitialMacroDefinitionsDetail globalMacroDefinitions, boolean analysisToolIsCppcheck) {
        if (globalMacroDefinitions == null) {
            return CollectionUtils.emptyList();
        }
        ArrayList<String> arguments = new ArrayList<String>();
        for (MacroDefinition definition : globalMacroDefinitions.definitions) {
            if ("__cplusplus".equals(definition.macroName) || LanguageAdjustmentConfiguration.isTeamscaleAssertMacro(definition) || NULL_ATTRIBUTES.contains(definition.macroName) && definition.replacementList.isEmpty()) continue;
            String compilerParameter = definition.formatAsDCompilerParameter();
            if (analysisToolIsCppcheck && compilerParameter.contains(";")) continue;
            arguments.add(compilerParameter);
        }
        return arguments;
    }

    public static void writeCompilationDb(File directory, File compilationDatabase, List<String> compilerCommandAndArguments, String mainFile, Charset encoding) throws IOException {
        JsonNodeFactory factory = new JsonNodeFactory(false);
        ArrayNode jsonRoot = factory.arrayNode();
        ObjectNode fileNode = factory.objectNode();
        jsonRoot.add((JsonNode)fileNode);
        fileNode.set("directory", (JsonNode)factory.textNode(directory.getAbsolutePath()));
        String command = StringUtils.concat(compilerCommandAndArguments, (String)" ") + " " + mainFile;
        fileNode.set("command", (JsonNode)factory.textNode(command));
        fileNode.set("file", (JsonNode)factory.textNode(mainFile));
        FileSystemUtils.writeFile((Path)compilationDatabase.toPath(), (String)jsonRoot.toPrettyString(), (Charset)encoding);
    }

    public static CodeScopeAware<List<String>> determineGlobalCompilerIncludeDirArguments(MetaIndex metaIndex, Set<CodeScopeName> relevantCodeScopeNames) throws StorageException {
        CodeScopeAware compilerArgumentsPerCodeScope = CodeScopeAware.empty();
        CppSystemIncludeDirectories systemIncludeDirectoriesForAllCodeScopes = (CppSystemIncludeDirectories)metaIndex.getValue(CppSystemIncludeDirectories.class);
        for (CodeScopeName codeScopeName : relevantCodeScopeNames) {
            if (systemIncludeDirectoriesForAllCodeScopes == null || !systemIncludeDirectoriesForAllCodeScopes.getDirectoriesForAllCodeScopes().contains(codeScopeName)) {
                compilerArgumentsPerCodeScope.setValue(codeScopeName, Collections.singletonList("-I."));
                continue;
            }
            List systemIncludeDirectories = (List)systemIncludeDirectoriesForAllCodeScopes.getDirectoriesForAllCodeScopes().getValue(codeScopeName);
            ArrayList<Object> compilerArguments = new ArrayList<Object>();
            compilerArguments.add("-I.");
            for (String directory : systemIncludeDirectories) {
                compilerArguments.add("-I" + directory);
            }
            compilerArgumentsPerCodeScope.setValue(codeScopeName, compilerArguments);
        }
        return compilerArgumentsPerCodeScope;
    }

    @IndexValueClass
    public record IncludeFile(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="requiredIncludePathForHeuristicInclude") @Nullable String requiredIncludePathForHeuristicInclude) implements Serializable
    {
    }
}

