/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.findings.FindingsDeletionFilterUtils;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.findings.FindingsSchema;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.index.configuration.CodeScopeUtils;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class FindingsSynchronizingAnalyzingStepBase
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected FindingsIndex findingsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected FindingsSchemaIndex findingsSchemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected PathLookupIndex pathLookupIndex;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="content")
    protected TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected TokenElementLineInfoIndex tokenElementLineInfoIndex;
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    protected KeyDelta contentDelta;
    private TokenElementIndexCache contentIndexCache = null;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected BasicTokenElementIndex basicTokenElementIndex;

    public TokenElementIndexCache getContentIndexCache() throws StorageException {
        if (this.contentIndexCache == null) {
            this.contentIndexCache = new TokenElementIndexCache(this.contentIndex, (List<UniformPath>)CollectionUtils.emptyList());
        }
        return this.contentIndexCache;
    }

    @Deprecated
    protected CodeScopeAware<CounterSet<String>> synchronizeFindingsForTokenElementIndexDelta(ListMap<String, IndexFinding> findings, String findingIndexPartition) throws StorageException {
        return this.synchronizeFindings((CodeScopeAware<ListMap<String, IndexFinding>>)CodeScopeAware.defaultCodeScopeWithValue(findings), findingIndexPartition, new HashSet<String>(this.contentDelta.getAddedOrChangedKeysAsStrings()));
    }

    protected void synchronizeFindings(CodeScopeAware<ListMap<String, IndexFinding>> findingsByPathPerCodeScope, String findingPartition) throws StorageException {
        CodeScopeAware<CounterSet<String>> droppedFindingTypes = this.synchronizeFindingsForTokenElementIndexDelta(findingsByPathPerCodeScope, findingPartition);
        List<CodeScopeName> codeScopeNamesWithDroppedFindings = droppedFindingTypes.getCodeScopeNames().stream().filter(codeScopeName -> !((CounterSet)droppedFindingTypes.getValue(codeScopeName)).isEmpty()).toList();
        if (!codeScopeNamesWithDroppedFindings.isEmpty()) {
            LOGGER.error("Had findings for following finding types which are not activated in the analysis profile. This indicates inconsistencies between finding creation and the finding schema:\n{}", (Object)codeScopeNamesWithDroppedFindings.stream().map(codeScopeName -> "\tcode scope '" + String.valueOf(codeScopeName) + "':" + String.valueOf(droppedFindingTypes.getValue(codeScopeName))).collect(Collectors.joining("\n")));
        }
    }

    protected CodeScopeAware<CounterSet<String>> synchronizeFindingsForTokenElementIndexDelta(CodeScopeAware<ListMap<String, IndexFinding>> findings, String findingIndexPartition) throws StorageException {
        return this.synchronizeFindings(findings, findingIndexPartition, new HashSet<String>(this.contentDelta.getAddedOrChangedKeysAsStrings()));
    }

    protected CodeScopeAware<CounterSet<String>> synchronizeFindings(CodeScopeAware<ListMap<String, IndexFinding>> findingsPerCodeScope, String findingIndexPartition, Collection<String> allAnalyzedPaths) throws StorageException {
        this.findingsIndex.removeFindingsForPartitionsAndPaths(findingIndexPartition, this.contentDelta.getDeletedKeysAsStrings());
        if (allAnalyzedPaths.isEmpty()) {
            return CodeScopeAware.empty();
        }
        Set<String> analyzedPathsWithFindings = FindingsSynchronizingAnalyzingStepBase.determineAnalyzedPathsWithFindings(findingsPerCodeScope, allAnalyzedPaths);
        Map<String, List<IndexFinding>> filteredFindings = FindingsSynchronizingAnalyzingStepBase.initializeEmptyFindingsListsForPathsWithoutFindings(allAnalyzedPaths, analyzedPathsWithFindings);
        Map<String, BasicTokenElementInfo> tokenElements = this.loadBasicTokenElements(analyzedPathsWithFindings);
        HashMap uniformPathToCodeScopeMapping = new HashMap();
        CodeScopeAware codeScopeToFindingSchemaMapping = CodeScopeAware.empty();
        for (Map.Entry findingsInCodeScope : findingsPerCodeScope) {
            CodeScopeName codeScopeName = (CodeScopeName)findingsInCodeScope.getKey();
            PairList<String, List<IndexFinding>> filteredFindingsForCodeScope = FindingsSynchronizingAnalyzingStepBase.filterFindingsAndFillOffsets((ListMap<String, IndexFinding>)((ListMap)findingsInCodeScope.getValue()), tokenElements);
            for (Pair filteredFindingsInPath : filteredFindingsForCodeScope) {
                filteredFindings.computeIfAbsent((String)filteredFindingsInPath.getFirst(), k -> new ArrayList()).addAll((Collection)filteredFindingsInPath.getSecond());
            }
            FindingsSchema findingsSchema = this.findingsSchemaIndex.getFindingsSchema(codeScopeName);
            codeScopeToFindingSchemaMapping.setValue(codeScopeName, (Object)findingsSchema);
            ((ListMap)findingsInCodeScope.getValue()).getKeys().forEach(path -> uniformPathToCodeScopeMapping.put(path, codeScopeName));
        }
        return this.findingsIndex.setFindings(findingIndexPartition, PairList.fromMap(filteredFindings), codeScopeToFindingSchemaMapping, uniformPathToCodeScopeMapping);
    }

    private static @NonNull Set<String> determineAnalyzedPathsWithFindings(CodeScopeAware<ListMap<String, IndexFinding>> findingsPerCodeScope, Collection<String> allAnalyzedPaths) {
        HashSet<String> analyzedPathsWithFindings = new HashSet<String>();
        for (CodeScopeName codeScopeName : findingsPerCodeScope.getCodeScopeNames()) {
            ListMap findingsInCodeScope = (ListMap)findingsPerCodeScope.getValue(codeScopeName);
            for (Map.Entry findingsInPath : findingsInCodeScope.entrySet()) {
                if (!allAnalyzedPaths.contains(findingsInPath.getKey()) || ((List)findingsInPath.getValue()).isEmpty()) continue;
                analyzedPathsWithFindings.add((String)findingsInPath.getKey());
            }
        }
        return analyzedPathsWithFindings;
    }

    private static @NonNull Map<String, List<IndexFinding>> initializeEmptyFindingsListsForPathsWithoutFindings(Collection<String> allAnalyzedPaths, Set<String> analyzedPathsWithFindings) {
        HashMap<String, List<IndexFinding>> filteredFindings = new HashMap<String, List<IndexFinding>>();
        for (String uniformPath : allAnalyzedPaths) {
            if (analyzedPathsWithFindings.contains(uniformPath)) continue;
            filteredFindings.put(uniformPath, new ArrayList(0));
        }
        return filteredFindings;
    }

    private static PairList<String, List<IndexFinding>> filterFindingsAndFillOffsets(ListMap<String, IndexFinding> findings, Map<String, BasicTokenElementInfo> tokenElementsWithFindings) {
        PairList filteredFindings = new PairList();
        for (Map.Entry entry : findings) {
            String uniformPath = (String)entry.getKey();
            List findingsInFile = (List)entry.getValue();
            if (findingsInFile.isEmpty()) continue;
            BasicTokenElementInfo elementInfo = tokenElementsWithFindings.get(uniformPath);
            if (elementInfo == null) {
                LOGGER.error("Could not find token element for findings adjustment. Keeping these findings without adjustment: {}", (Object)uniformPath);
                filteredFindings.add((Object)uniformPath, (Object)findingsInFile);
                continue;
            }
            LineOffsetConverter converter = new LineOffsetConverter(elementInfo.getText());
            for (IndexFinding indexFinding : findingsInFile) {
                try {
                    String fileContent = tokenElementsWithFindings.get(indexFinding.getLocation().getUniformPath()).getText();
                    IndexFindingUtils.fillInMissingOffsets((IndexFinding)indexFinding, (String)fileContent, (LineOffsetConverter)converter);
                }
                catch (IllegalArgumentException exception) {
                    LOGGER.error("Could not adjust offsets for {}", (Object)uniformPath, (Object)exception);
                }
            }
            filteredFindings.add((Object)uniformPath, (Object)FindingsDeletionFilterUtils.filterFindings((List)findingsInFile, (List)elementInfo.getFilterDeletions(), (int)elementInfo.getText().length()));
        }
        return filteredFindings;
    }

    protected Optional<BasicTokenElementInfo> overrideBasicTokenElementInfoForOffsetAndDeletions(String uniformPath) throws StorageException {
        return Optional.empty();
    }

    protected List<TokenElementInfo> getAddedOrChangedTokenElements(Set<ELanguage> languages) throws StorageException {
        return CollectionUtils.filter(this.getContentIndexCache().getValues(this.contentDelta.getAddedOrChangedKeysAsStrings()), element -> languages.contains(element.getLanguage()));
    }

    protected CodeScopeAware<List<TokenElementInfo>> getAddedOrChangedTokenElementsByCodeScope(Set<ELanguage> languages) throws StorageException {
        List elements = CollectionUtils.filter(this.getContentIndexCache().getValues(this.contentDelta.getAddedOrChangedKeysAsStrings()), element -> languages.contains(element.getLanguage()));
        return CodeScopeUtils.groupElementsByCodeScope(elements);
    }

    private Map<String, BasicTokenElementInfo> loadBasicTokenElements(Set<String> uniformPaths) throws StorageException {
        ArrayList<String> missingPaths = new ArrayList<String>(uniformPaths);
        Map<String, BasicTokenElementInfo> newElements = this.loadMissingElementsFromSubclasses(missingPaths);
        missingPaths.removeAll(newElements.keySet());
        HashMap<String, BasicTokenElementInfo> result = new HashMap<String, BasicTokenElementInfo>(newElements);
        newElements = this.loadPresentElementsFromContentIndexCache(missingPaths);
        missingPaths.removeAll(newElements.keySet());
        result.putAll(newElements);
        newElements = this.loadElementsFromBasicTokenIndex(missingPaths);
        missingPaths.removeAll(newElements.keySet());
        result.putAll(newElements);
        newElements = this.loadElementsFromTokenIndex(missingPaths);
        missingPaths.removeAll(newElements.keySet());
        result.putAll(newElements);
        if (!missingPaths.isEmpty()) {
            LOGGER.error("Could not find basic token elements for paths. Ignored findings for these paths. {}", missingPaths);
        }
        return result;
    }

    private Map<String, BasicTokenElementInfo> loadMissingElementsFromSubclasses(List<String> missingPaths) throws StorageException {
        HashMap<String, BasicTokenElementInfo> newElements = new HashMap<String, BasicTokenElementInfo>();
        for (String uniformPath : missingPaths) {
            Optional<BasicTokenElementInfo> overrideElement = this.overrideBasicTokenElementInfoForOffsetAndDeletions(uniformPath);
            if (!overrideElement.isPresent()) continue;
            newElements.put(uniformPath, overrideElement.get());
        }
        return newElements;
    }

    private Map<String, BasicTokenElementInfo> loadPresentElementsFromContentIndexCache(List<String> missingPaths) throws StorageException {
        if (this.contentIndexCache == null) {
            return Map.of();
        }
        HashMap<String, BasicTokenElementInfo> cachedElements = new HashMap<String, BasicTokenElementInfo>();
        for (String uniformPath : missingPaths) {
            Optional<TokenElementInfo> cachedElement = this.contentIndexCache.getElementIfPresentInCache(uniformPath);
            if (!cachedElement.isPresent()) continue;
            cachedElements.put(uniformPath, cachedElement.get());
        }
        return cachedElements;
    }

    private Map<String, BasicTokenElementInfo> loadElementsFromBasicTokenIndex(List<String> missingPaths) throws StorageException {
        HashMap<String, BasicTokenElementInfo> newElements = new HashMap<String, BasicTokenElementInfo>();
        List<@Nullable BasicTokenElementInfo> basicElements = this.basicTokenElementIndex.getTokenElements(missingPaths);
        for (int i = 0; i < missingPaths.size(); ++i) {
            String uniformPath = missingPaths.get(i);
            BasicTokenElementInfo basicElement = basicElements.get(i);
            if (basicElement == null) continue;
            newElements.put(uniformPath, basicElement);
        }
        return newElements;
    }

    private Map<String, BasicTokenElementInfo> loadElementsFromTokenIndex(List<String> missingPaths) throws StorageException {
        HashMap<String, BasicTokenElementInfo> newElements = new HashMap<String, BasicTokenElementInfo>();
        List<@Nullable TokenElementInfo> tokenElements = this.getContentIndexCache().getValues(missingPaths);
        for (int i = 0; i < missingPaths.size(); ++i) {
            String uniformPath = missingPaths.get(i);
            BasicTokenElementInfo tokenElement = tokenElements.get(i);
            if (tokenElement == null) continue;
            newElements.put(uniformPath, tokenElement);
        }
        return newElements;
    }

    protected static @NonNull IndexFinding createIndexFindingWithGuidelineMapping(String message, String uniformPath, String checkId, String findingCategory, int startLine, int endLine, LineOffsetConverter offsetConverter, UnmodifiableSet<ELanguage> languages) {
        int rawStartOffset = offsetConverter.getOffset(startLine);
        int rawEndOffset = offsetConverter.getOffset(endLine + 1) - 1;
        TextRegionLocation textLocation = new TextRegionLocation(uniformPath, rawStartOffset, rawEndOffset, startLine, endLine);
        IndexFinding indexFinding = new IndexFinding(checkId, findingCategory, message, (ElementLocation)textLocation);
        IndexFindingUtils.setGuidelineMapping((IndexFinding)indexFinding, (String)checkId, languages);
        return indexFinding;
    }
}

