/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import com.teamscale.core.utils.TempFileFactory;
import com.teamscale.index.findings.FileToDiskWriter;
import com.teamscale.index.findings.raex.RaexFindingsSynchronizer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.util.NativeLibUtil;
import org.conqat.engine.dotnet.DotnetExecutorBase;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class RaexExecutor
extends DotnetExecutorBase {
    protected CanonicalFile outputFile;
    private static final Logger LOGGER = LogManager.getLogger();
    protected final FileToDiskWriter fileToDiskWriter;
    private final Set<BasicTokenElementInfo> input = new HashSet<BasicTokenElementInfo>();
    private final TempFileFactory tempFileFactory;
    private String reportFileContent;
    private final CanonicalFile rulesFile;
    private static final String RAEX_EXECUTABLE = "raex.dll";

    public RaexExecutor(TempFileFactory tempFileFactory, Collection<BasicTokenElementInfo> input, FileToDiskWriter fileToDiskWriter, CanonicalFile rulesFile) {
        this.tempFileFactory = tempFileFactory;
        this.input.addAll(input);
        this.fileToDiskWriter = fileToDiskWriter;
        this.outputFile = tempFileFactory.getTempFile("", "tmp-raex-result.txt");
        this.rulesFile = rulesFile;
    }

    protected CanonicalFile writeFilesListing(String analyzerName) throws IOException {
        PairList uniformPathsAndContents = new PairList();
        for (BasicTokenElementInfo element : this.input) {
            uniformPathsAndContents.add((Object)element.getUniformPath(), (Object)element.getText());
        }
        List<String> fileNames = this.fileToDiskWriter.writeFilesToTemporaryLocation((PairList<String, String>)uniformPathsAndContents);
        LOGGER.info("Analyzing " + fileNames.size() + " source files with " + analyzerName);
        CanonicalFile sources = this.tempFileFactory.getTempFile("sources", ".lst");
        FileSystemUtils.writeLines((File)sources, fileNames, (Charset)RaexFindingsSynchronizer.ENCODING);
        return sources;
    }

    private String analyzeFiles() throws ConQATException {
        if (this.input.isEmpty()) {
            return "";
        }
        try {
            return this.analyzeFilesUnsafe();
        }
        catch (IOException e) {
            throw new ConQATException("I/O Error while executing Dotnet Tool " + String.join((CharSequence)" ", this.getCommand()), (Throwable)e);
        }
    }

    public String analyzeFilesUnsafe() throws IOException, ConQATException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("analyze");
        if (this.rulesFile != null) {
            arguments.add("--rule-file");
            arguments.add(this.rulesFile.getCanonicalPath());
        }
        arguments.add("-o");
        arguments.add(this.outputFile.getCanonicalPath());
        CanonicalFile sources = this.writeFilesListing("RA\u00cbX");
        arguments.add(sources.getCanonicalPath());
        this.execute(arguments);
        String reportPathPrefix = StringUtils.ensureEndsWith((String)this.fileToDiskWriter.getTempDirectory().getCanonicalPath(), (String)"/");
        return FileSystemUtils.readFile((File)this.outputFile, (Charset)RaexFindingsSynchronizer.ENCODING).replace(reportPathPrefix, "");
    }

    public void execute() throws IOException, ConQATException {
        File raexNatives = NativeLibUtil.getNativeLib((String)"raex");
        this.setExecutable(new File(raexNatives, RAEX_EXECUTABLE).getAbsolutePath(), false);
        this.reportFileContent = this.analyzeFiles();
    }

    public String getReportFileContent() {
        return this.reportFileContent;
    }
}

