/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlLinterConfigurationFileGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<String> selectedChecks;
    private final List<String> selectedOptions;
    private final List<String> checkOptionValues;
    private final List<String> checkOptionTypes;
    private Yaml yaml;
    private final String checkSectionName;
    private final Map<String, Object> yamlRoot = new LinkedHashMap<String, Object>();
    public static final String YAML_CONFIG_OPTION_ID = "yaml_config";

    public YamlLinterConfigurationFileGenerator(String checkSectionName, List<String> selectedChecks, List<String> selectedOptions, List<String> checkOptionValues, List<String> checkOptionTypes) {
        this.checkSectionName = checkSectionName;
        this.selectedChecks = selectedChecks;
        this.selectedOptions = selectedOptions;
        this.checkOptionValues = checkOptionValues;
        this.checkOptionTypes = checkOptionTypes;
    }

    public String generateConfiguration() {
        List sections = StringUtils.splitToList((String)this.checkSectionName, (String)"\\.");
        CCSMAssert.isTrue((sections.size() <= 2 ? 1 : 0) != 0, (String)"Section nesting of more than two levels isn't supported");
        if (sections.size() == 1) {
            this.yamlRoot.put(this.checkSectionName, this.selectedChecks);
        } else {
            HashMap<String, List<String>> innerSection = new HashMap<String, List<String>>();
            innerSection.put((String)sections.get(1), this.selectedChecks);
            this.yamlRoot.put((String)sections.get(0), innerSection);
        }
        this.yaml = YamlLinterConfigurationFileGenerator.initializeYaml();
        for (int optionIndex = 0; optionIndex < this.selectedOptions.size(); ++optionIndex) {
            this.addCheckYamlEntry(optionIndex);
        }
        return this.yaml.dump(this.yamlRoot);
    }

    private static Yaml initializeYaml() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setIndentWithIndicator(true);
        options.setIndicatorIndent(2);
        return new Yaml(options);
    }

    private void addCheckYamlEntry(int optionIndex) {
        List<String> separatedOptionId = this.getSeparatedOptionId(optionIndex);
        String checkId = separatedOptionId.get(0);
        String optionId = separatedOptionId.get(1);
        Map<String, Object> checkOptionsByOptionId = this.getCheckRootEntry(checkId);
        checkOptionsByOptionId.putIfAbsent(optionId, new LinkedHashMap());
        Map<String, Object> currentEntry = checkOptionsByOptionId;
        String lastKey = optionId;
        for (int idIndex = 1; idIndex < separatedOptionId.size(); ++idIndex) {
            String key = separatedOptionId.get(idIndex);
            if (idIndex > 1) {
                currentEntry = YamlLinterConfigurationFileGenerator.uncheckedCast(checkOptionsByOptionId.getOrDefault(lastKey, new LinkedHashMap()));
            }
            if (idIndex == separatedOptionId.size() - 1) {
                this.insertValue(checkId, currentEntry, key, this.checkOptionValues.get(optionIndex), this.checkOptionTypes.get(optionIndex));
                if (currentEntry.containsKey(YAML_CONFIG_OPTION_ID)) {
                    checkOptionsByOptionId.put(lastKey, currentEntry.get(YAML_CONFIG_OPTION_ID));
                }
            }
            lastKey = key;
        }
        if (!checkOptionsByOptionId.isEmpty()) {
            this.yamlRoot.put(checkId, checkOptionsByOptionId);
        }
    }

    private Map<String, Object> getCheckRootEntry(String checkId) {
        return YamlLinterConfigurationFileGenerator.uncheckedCast(this.yamlRoot.getOrDefault(checkId, new LinkedHashMap()));
    }

    private static Map<String, Object> uncheckedCast(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        return (Map)CCSMAssert.fail((String)"YAML configuration file could not be created.");
    }

    private void insertValue(String checkId, Map<String, Object> currentEntry, String optionId, String value, String valueType) {
        switch (valueType) {
            case "List": {
                YamlLinterConfigurationFileGenerator.addListEntry(currentEntry, optionId, value, String::valueOf);
                break;
            }
            case "List:Double": {
                YamlLinterConfigurationFileGenerator.addListEntry(currentEntry, optionId, value, Double::valueOf);
                break;
            }
            case "List:Integer": {
                YamlLinterConfigurationFileGenerator.addListEntry(currentEntry, optionId, value, Integer::valueOf);
                break;
            }
            case "Integer": {
                YamlLinterConfigurationFileGenerator.addIntegerEntry(currentEntry, optionId, value);
                break;
            }
            case "Double": {
                currentEntry.put(optionId, Double.valueOf(value));
                break;
            }
            case "Boolean": {
                currentEntry.put(optionId, Boolean.valueOf(value));
                break;
            }
            case "String": {
                this.addStringEntry(currentEntry, checkId, optionId, value);
                break;
            }
            default: {
                LOGGER.error("Unknown type '{}' for check option '{}' will be ignored: {}", (Object)valueType, (Object)optionId, (Object)value);
            }
        }
    }

    private static void addListEntry(Map<String, Object> currentEntry, String optionId, String value, Function<String, ?> mapper) {
        List elements = CollectionUtils.parseMultiValueStringToList((String)value, (boolean)false);
        List<?> mappedElements = elements.stream().map(mapper).toList();
        currentEntry.put(optionId, mappedElements);
    }

    private static void addIntegerEntry(Map<String, Object> currentEntry, String optionId, String value) {
        if (StringUtils.isInteger((String)value)) {
            currentEntry.put(optionId, Integer.valueOf(value));
        } else {
            currentEntry.remove(optionId);
        }
    }

    private void addStringEntry(Map<String, Object> currentEntry, String checkId, String optionId, String value) {
        if (YAML_CONFIG_OPTION_ID.equals(optionId)) {
            this.addStringEntryAsYaml(currentEntry, checkId, value);
        } else {
            currentEntry.put(optionId, value);
        }
    }

    private void addStringEntryAsYaml(Map<String, Object> currentEntry, String checkId, String value) {
        Object parsedYamlValue;
        if (value == null) {
            currentEntry.remove(YAML_CONFIG_OPTION_ID);
            return;
        }
        try {
            parsedYamlValue = this.yaml.load(value);
        }
        catch (YAMLException e) {
            LOGGER.error("Malformed YAML configuration option for check '{}' will be ignored: {}", (Object)checkId, (Object)value, (Object)e);
            currentEntry.remove(YAML_CONFIG_OPTION_ID);
            return;
        }
        if (parsedYamlValue != null) {
            if (parsedYamlValue instanceof Map) {
                Map parsedOptionRoot = (Map)parsedYamlValue;
                Object potentialWholeCheckOptionRoot = parsedOptionRoot.get(checkId);
                Map<String, Object> parsedCheckOption = YamlLinterConfigurationFileGenerator.uncheckedCast(potentialWholeCheckOptionRoot != null ? potentialWholeCheckOptionRoot : parsedOptionRoot);
                currentEntry.putAll(parsedCheckOption);
            } else if (parsedYamlValue instanceof List) {
                List parsedOptionRoot = (List)parsedYamlValue;
                currentEntry.put(YAML_CONFIG_OPTION_ID, parsedOptionRoot);
                return;
            }
        }
        currentEntry.remove(YAML_CONFIG_OPTION_ID);
    }

    private List<String> getSeparatedOptionId(int optionIndex) {
        String optionId = this.selectedOptions.get(optionIndex);
        return StringUtils.splitToList((String)optionId, (String)"\\.");
    }
}

