/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.bandit;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.findings.PythonLintingUtils;
import com.teamscale.index.findings.bandit.BanditRunner;
import com.teamscale.index.findings.bandit.FindingInfo;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

public class BanditSynchronizer
extends FindingsSynchronizingAnalyzingStepBase {
    private static final String TEMP_DIR_NAME = "TeamscaleBandit";
    public static final String CHECKS_PARAMETER = "checks";
    public static final String CHECK_OPTIONS_PARAMETER = "check-options";
    public static final String CHECK_OPTIONS_VALUES_PARAMETER = "check-option-values";
    public static final String CHECK_OPTIONS_TYPES_PARAMETER = "check-option-types";
    @VisibleForTesting
    public static final String FINDING_PARTITION = "bandit";
    @StepParameter(value="check-options", optional=true)
    private final CodeScopeAware<List<String>> selectedOptions = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    @StepParameter(value="check-option-values", optional=true)
    private final CodeScopeAware<List<String>> checkOptionValues = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    @StepParameter(value="check-option-types", optional=true)
    private final CodeScopeAware<List<String>> checkOptionTypes = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    @StepParameter(value="checks")
    private final CodeScopeAware<List<String>> selectedChecks = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    private final Set<String> selectedChecksSet = new HashSet<String>();
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws Exception {
        CodeScopeAware<List<TokenElementInfo>> elementsByCodeScope = this.getAddedOrChangedTokenElementsByCodeScope(Set.of(ELanguage.PYTHON));
        CodeScopeAware findingsByCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : elementsByCodeScope.getCodeScopeNames()) {
            if (((List)elementsByCodeScope.getValue(codeScopeName)).isEmpty()) {
                LOGGER.debug("No Python files in change set. Skipping Bandit execution.");
                findingsByCodeScope.setValue(codeScopeName, (Object)new ListMap());
                continue;
            }
            TemporaryDirectory tmpDir = BanditSynchronizer.getTempDirectory((String)TEMP_DIR_NAME);
            try {
                CanonicalFile tempDirectory = new CanonicalFile(tmpDir.getPath().toFile());
                LOGGER.debug("Processing {} files with {} enabled checks in temporary directory {}", (Object)((List)elementsByCodeScope.getValue(codeScopeName)).size(), (Object)((List)this.selectedChecks.getValue(codeScopeName)).size(), (Object)tempDirectory.getCanonicalPath());
                BanditRunner.prepareWorkingDirAndConfig(tempDirectory, (List)this.selectedChecks.getValue(codeScopeName), (List)this.selectedOptions.getValue(codeScopeName), (List)this.checkOptionValues.getValue(codeScopeName), (List)this.checkOptionTypes.getValue(codeScopeName));
                Map<String, TokenElementInfo> generatedFilenameToElement = PythonLintingUtils.prepareFilesForAnalysis((List)elementsByCodeScope.getValue(codeScopeName), tempDirectory);
                List<FindingInfo> reportedResults = BanditRunner.executeAnalysis(tempDirectory);
                findingsByCodeScope.setValue(codeScopeName, this.processResults(reportedResults, generatedFilenameToElement, codeScopeName));
                LOGGER.debug("Cleaning up temporary directory: {}", (Object)tempDirectory);
            }
            finally {
                if (tmpDir == null) continue;
                tmpDir.close();
            }
        }
        this.synchronizeFindingsForTokenElementIndexDelta((CodeScopeAware<ListMap<String, IndexFinding>>)findingsByCodeScope, FINDING_PARTITION);
    }

    private ListMap<String, IndexFinding> processResults(@NonNull List<FindingInfo> reportedResults, @NonNull Map<String, TokenElementInfo> generatedFilenameToElement, CodeScopeName codeScopeName) {
        Map<String, List<FindingInfo>> groupedResults = reportedResults.stream().collect(Collectors.groupingBy(FindingInfo::path));
        ListMap indexFindings = new ListMap();
        this.selectedChecksSet.addAll((Collection)this.selectedChecks.getValue(codeScopeName));
        for (Map.Entry<String, List<FindingInfo>> resultsPerFile : groupedResults.entrySet()) {
            CCSMAssert.isFalse((StringUtils.isEmpty((String)resultsPerFile.getKey()) || CollectionUtils.isNullOrEmpty((Collection)resultsPerFile.getValue()) ? 1 : 0) != 0, (String)"Result group must not be empty");
            String fileName = FileSystemUtils.getLastPathSegment((String)resultsPerFile.getKey());
            TokenElementInfo tokenElement = generatedFilenameToElement.get(fileName);
            if (tokenElement == null) {
                LOGGER.error("Unmapped file '{}' in Bandit results. Skipping file.", (Object)fileName);
                continue;
            }
            LineOffsetConverter offsetConverter = new LineOffsetConverter(tokenElement.getText());
            List<FindingInfo> fileResults = resultsPerFile.getValue();
            this.convertResultsToIndexFindings(fileResults, offsetConverter, tokenElement, (ListMap<String, IndexFinding>)indexFindings);
        }
        return indexFindings;
    }

    private void convertResultsToIndexFindings(@NonNull List<FindingInfo> fileResults, @NonNull LineOffsetConverter offsetConverter, @NonNull TokenElementInfo tokenElement, @NonNull ListMap<String, IndexFinding> indexFindings) {
        for (FindingInfo finding : fileResults) {
            if (!this.selectedChecksSet.contains(finding.checkId())) {
                LOGGER.error("Bandit result with unknown checkID '{}' in file '{}'. Skipping finding.", (Object)finding.checkId(), (Object)tokenElement.getUniformPath());
                continue;
            }
            int lineNumberStart = finding.rowStart();
            int lineNumberEnd = finding.rowEnd();
            indexFindings.add((Object)tokenElement.getUniformPath(), (Object)BanditSynchronizer.createIndexFindingWithGuidelineMapping(finding.message(), tokenElement.getUniformPath(), finding.checkId(), "Bandit", lineNumberStart, lineNumberEnd, offsetConverter, (UnmodifiableSet<ELanguage>)EAnalysisTool.BANDIT.getSupportedLanguages()));
        }
    }

    public static void verifyVersion() throws ConQATException {
        BanditRunner.verifyVersion();
    }
}

