/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy.outsourced_analysis;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyOutsourcedAnalysisRequestParameters;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyResultsTransport;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.EClangTidyOutsourcedAnalysisStatus;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.jspecify.annotations.NonNull;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

public interface IClangTidyOutsourcedAnalysisExecutionServerAPI
extends IRetrofitApi {
    public static final String CLANG_TIDY_ANALYSIS_API_ENDPOINT = "api/analysis/clangtidy-execution";
    public static final String CLANG_TIDY_ANALYSIS_API_STATUS_SUB_PATH = "status";
    public static final String CLANG_TIDY_ANALYSIS_API_STATUS_ENDPOINT = "api/analysis/clangtidy-execution/status";
    public static final String PROJECT_ID_PARAMETER_NAME = "projectId";
    public static final String COMMIT_PARAMETER_NAME = "commitDescriptor";
    public static final String RETURN_ADDRESS_PARAMETER_NAME = "returnAddress";
    public static final String SESSION_KEY_PARAMETER_NAME = "sessionKey";
    public static final String CLANGTIDY_CLEAR_RESULTS_CACHE_SUB_PATH = "clearResultsCache";

    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    @POST(value="api/analysis/clangtidy-execution")
    public String requestAnalysisAndOpenSession(@Query(value="projectId") @NonNull IProjectId var1, @Query(value="commitDescriptor") @NonNull UnresolvedCommitDescriptor var2, @Query(value="returnAddress") @NonNull String var3, @Body ClangTidyOutsourcedAnalysisRequestParameters var4) throws ServiceCallException;

    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    @GET(value="api/analysis/clangtidy-execution/status")
    public EClangTidyOutsourcedAnalysisStatus getAnalysisStatus(@Query(value="sessionKey") String var1) throws ServiceCallException;

    @GET(value="api/analysis/clangtidy-execution")
    public List<ClangTidyResultsTransport> getAnalysisResultsByPath(@Query(value="sessionKey") String var1) throws ServiceCallException;

    @DELETE(value="api/analysis/clangtidy-execution/clearResultsCache")
    public Void clearResultsCache() throws ServiceCallException;

    public static @NonNull IClangTidyOutsourcedAnalysisExecutionServerAPI generateServiceClient(ExternalCredentials executionServerCredentials, Logger logger) {
        return (IClangTidyOutsourcedAnalysisExecutionServerAPI)Retrofit.builder((String)executionServerCredentials.uri).withBasicNTLMAuthentication(executionServerCredentials.username, executionServerCredentials.password).withInteractionLogger(logger).create(IClangTidyOutsourcedAnalysisExecutionServerAPI.class);
    }
}

