/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.dart_lint;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.findings.bandit.FindingInfo;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class DartLintReportParser {
    public static List<FindingInfo> parse(@Nullable String report) throws ConQATException {
        if (StringUtils.isEmpty((String)report)) {
            return Collections.emptyList();
        }
        try {
            DartLintOutputReport reportObject = (DartLintOutputReport)JsonUtils.deserializeFromJson((String)report, DartLintOutputReport.class);
            return reportObject.diagnostics.stream().map(Diagnostic::toFinding).toList();
        }
        catch (JsonSerializationException e) {
            throw new ConQATException("Unable to parse dart lint output report.", (Throwable)e);
        }
    }

    private static class DartLintOutputReport {
        @JsonProperty
        private int version;
        @JsonProperty
        private List<Diagnostic> diagnostics;

        private DartLintOutputReport() {
        }
    }

    public static class Position {
        @JsonProperty
        private int offset;
        @JsonProperty
        private int line;
        @JsonProperty
        private int column;
    }

    public static class Range {
        @JsonProperty
        private Position start;
        @JsonProperty
        private Position end;
    }

    public static class Location {
        @JsonProperty
        private String file;
        @JsonProperty
        private Range range;
    }

    public static class Diagnostic {
        @JsonProperty
        private String code;
        @JsonProperty
        private String severity;
        @JsonProperty
        private String type;
        @JsonProperty
        private Location location;
        @JsonProperty
        private String problemMessage;
        @JsonProperty
        private String correctionMessage;
        @JsonProperty
        private String documentation;

        private FindingInfo toFinding() {
            return new FindingInfo("dart." + this.code, this.location.range.start.line, this.location.range.end.line, this.location.range.start.offset, this.location.range.end.offset, this.problemMessage, this.location.file);
        }
    }
}

