/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.eslint;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.index.findings.ECheckstyleReportAttributes;
import com.teamscale.index.findings.ECheckstyleReportElements;
import com.teamscale.index.findings.FindingReportAnalyzerBase;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.util.XMLReaderBase;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.xml.IXMLElementProcessor;

public class ESLintReportReader
extends FindingReportAnalyzerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public ESLintReportReader(IMatchingPathsLookup matchingPathsLookup) {
        super(matchingPathsLookup);
    }

    public ListMap<String, IndexFinding> parseReport(String content) throws ConQATException {
        return new CheckstyleReportReader(this, content).load();
    }

    private static String getCategory() {
        return "ESLint";
    }

    private static String getCheckID(String message) {
        int typeBegin = message.lastIndexOf(40) + 1;
        int typeEnd = message.indexOf(41, typeBegin);
        if (typeEnd < 0) {
            return message;
        }
        return message.substring(typeBegin, typeEnd);
    }

    private static String getMessageForFinding(String message) {
        int parenthesisStart = message.lastIndexOf(40);
        if (parenthesisStart < 0) {
            return message;
        }
        return message.substring(0, parenthesisStart);
    }

    private final class CheckstyleReportReader
    extends XMLReaderBase<ECheckstyleReportElements, ECheckstyleReportAttributes, ConQATException> {
        private final ListMap<String, IndexFinding> findings;
        final /* synthetic */ ESLintReportReader this$0;

        private CheckstyleReportReader(ESLintReportReader eSLintReportReader, String content) {
            ESLintReportReader eSLintReportReader2 = eSLintReportReader;
            Objects.requireNonNull(eSLintReportReader2);
            this.this$0 = eSLintReportReader2;
            super(content, ECheckstyleReportAttributes.class);
            this.findings = new ListMap();
        }

        public ListMap<String, IndexFinding> load() throws ConQATException {
            this.parseAndWrapExceptions();
            this.processChildElements(new FileInstanceProcessor(this));
            return this.findings;
        }

        protected String getLocation() {
            return "report";
        }

        private final class FileInstanceProcessor
        implements IXMLElementProcessor<ECheckstyleReportElements, ConQATException> {
            final /* synthetic */ CheckstyleReportReader this$1;

            private FileInstanceProcessor(CheckstyleReportReader checkstyleReportReader) {
                CheckstyleReportReader checkstyleReportReader2 = checkstyleReportReader;
                Objects.requireNonNull(checkstyleReportReader2);
                this.this$1 = checkstyleReportReader2;
            }

            public ECheckstyleReportElements getTargetElement() {
                return ECheckstyleReportElements.file;
            }

            public void process() throws ConQATException {
                String fileName = this.this$1.getStringAttribute(ECheckstyleReportAttributes.name);
                this.this$1.processChildElements(new ErrorInstanceProcessor(this.this$1, fileName));
            }
        }

        private final class ErrorInstanceProcessor
        implements IXMLElementProcessor<ECheckstyleReportElements, ConQATException> {
            private final String fileName;
            final /* synthetic */ CheckstyleReportReader this$1;

            public ErrorInstanceProcessor(CheckstyleReportReader checkstyleReportReader, String fileName) {
                CheckstyleReportReader checkstyleReportReader2 = checkstyleReportReader;
                Objects.requireNonNull(checkstyleReportReader2);
                this.this$1 = checkstyleReportReader2;
                this.fileName = fileName;
            }

            public ECheckstyleReportElements getTargetElement() {
                return ECheckstyleReportElements.error;
            }

            public void process() {
                Optional<String> uniformPath;
                String message = this.this$1.getStringAttribute(ECheckstyleReportAttributes.message);
                String lineStr = this.this$1.getStringAttribute(ECheckstyleReportAttributes.line);
                if ("undefined".equals(lineStr)) {
                    return;
                }
                int line = this.this$1.getIntAttribute(ECheckstyleReportAttributes.line);
                if (line == 0) {
                    LOGGER.error(message);
                    return;
                }
                Path workingDir = FileSystemUtils.getJvmWorkingDirOrTempForDevMode().toPath();
                Path reportPath = Paths.get(this.fileName, new String[0]);
                if (reportPath.startsWith(workingDir)) {
                    reportPath = workingDir.relativize(reportPath);
                }
                if ((uniformPath = this.this$1.this$0.matchingPathsLookup.lookupBestPath(reportPath.toString(), PathLookupOptions.defaults())).isEmpty()) {
                    return;
                }
                String checkID = ESLintReportReader.getCheckID(message);
                IndexFinding finding = new IndexFinding(checkID, ESLintReportReader.getCategory(), ESLintReportReader.getMessageForFinding(message), (ElementLocation)new TextRegionLocation(uniformPath.get(), -1, -1, line, line));
                IndexFindingUtils.setGuidelineMapping((IndexFinding)finding, (String)checkID, (Set)EAnalysisTool.ESLINT.getSupportedLanguages());
                this.this$1.findings.add((Object)uniformPath.get(), (Object)finding);
            }
        }
    }
}

