/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.golangcilint;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.index.configuration.tools.GoLangCILintConfiguration;
import com.teamscale.index.findings.golangcilint.GoLangCILintException;
import com.teamscale.index.findings.golangcilint.GoLangCILintRunner;
import com.teamscale.index.findings.golangcilint.GoLangCILintUtils;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import eu.cqse.check.framework.core.registry.CheckMapping;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;

public class GoLangCILintUpdater {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String LINTERS_SETTINGS_JSON_SCHEMA_FILE = "golangci-lint/golangci.v1.60.jsonschema.json";
    private static final String GOLANGCI_LINT_TOOLS_FOLDER = "server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/";
    private static final String PLUGIN_LINTER_MAPPINGS_TSV = "server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/golangci-lint/check-mappings.tsv";
    private static final String PLUGIN_LINTER_OPTIONS_TSV = "server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/golangci-lint/check-options.tsv";
    private static final String PLUGIN_LINTER_DESCRIPTIONS_DIRECTORY = "server/com.teamscale.index/check-descriptions/golangci-lint/";
    private static final String CUSTOM_CHECK_ID = GoLangCILintUtils.createUniqueCheckId("custom-golangci-lint");
    private static final String CUSTOM_CHECK_OPTION_ID = GoLangCILintUtils.createUniqueOptionId(CUSTOM_CHECK_ID, "option");
    private static final String JSON_PROPERTIES_KEY = "properties";
    private static final String JSON_DEFAULT_KEY = "default";
    private static final String JSON_TYPE_KEY = "type";
    private static final String JSON_ITEMS_KEY = "items";
    private static final String JSON_OBJECT_KEY = "object";

    public static void main(String[] args) throws IOException, JsonSerializationException, GoLangCILintException {
        List<PluginLinterMapping> pluginLinterMappings = GoLangCILintUpdater.writePluginLinterMappings(Path.of(PLUGIN_LINTER_MAPPINGS_TSV, new String[0]));
        GoLangCILintUpdater.writePluginLinterOptions(pluginLinterMappings, Path.of(PLUGIN_LINTER_OPTIONS_TSV, new String[0]));
        GoLangCILintUpdater.writeDescriptions(pluginLinterMappings);
    }

    private static void writeDescriptions(List<PluginLinterMapping> pluginLinterMappings) throws IOException {
        for (PluginLinterMapping pluginLinter : pluginLinterMappings) {
            Path descriptionPath = Path.of(PLUGIN_LINTER_DESCRIPTIONS_DIRECTORY, pluginLinter.checkMapping.checkId + ".md");
            if (descriptionPath.toFile().exists()) continue;
            String comments = "";
            if (pluginLinter.checkMapping.comments != null) {
                comments = pluginLinter.checkMapping.comments;
            }
            if (!pluginLinter.isPluginFast) continue;
            Files.writeString(descriptionPath, (CharSequence)comments, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
    }

    private static void writePluginLinterOptions(List<PluginLinterMapping> pluginLinterMappings, Path pluginLinterOptionsFile) throws IOException, JsonSerializationException {
        Resource resource = Resource.of(GoLangCILintConfiguration.class, (String)LINTERS_SETTINGS_JSON_SCHEMA_FILE);
        JsonNode schema = JsonUtils.deserializeFromJson((String)resource.getContent());
        JsonNode checksNodes = schema.get(JSON_PROPERTIES_KEY).get("linters-settings").get(JSON_PROPERTIES_KEY);
        Set newCheckIds = pluginLinterMappings.stream().map(c -> c.checkMapping.checkId).collect(Collectors.toSet());
        ArrayList<ToolCheckOption> checkOptions = new ArrayList<ToolCheckOption>();
        Iterator itCheckNode = checksNodes.fields();
        while (itCheckNode.hasNext()) {
            Map.Entry checkNode = (Map.Entry)itCheckNode.next();
            String checkIdFromJsonSchema = (String)checkNode.getKey();
            String uniqueCheckId = GoLangCILintUtils.createUniqueCheckId(checkIdFromJsonSchema);
            if (!newCheckIds.contains(uniqueCheckId) && !"custom".equals(checkIdFromJsonSchema)) {
                LOGGER.warn("Check with ID: {} has options but no mapping.", (Object)checkIdFromJsonSchema);
                continue;
            }
            JsonNode checkOptionsNode = (JsonNode)checkNode.getValue();
            if (!checkOptionsNode.has(JSON_PROPERTIES_KEY)) {
                if (!"custom".equals(checkIdFromJsonSchema)) continue;
                checkOptions.add(new ToolCheckOption(CUSTOM_CHECK_ID, CUSTOM_CHECK_OPTION_ID, "Custom check option", "Custom check option", EToolCheckOptionType.JSON, null));
                continue;
            }
            Iterator itCheckOption = ((JsonNode)checkNode.getValue()).get(JSON_PROPERTIES_KEY).fields();
            while (itCheckOption.hasNext()) {
                GoLangCILintUpdater.createCheckOption(uniqueCheckId, (Map.Entry)itCheckOption.next()).ifPresent(checkOptions::add);
            }
        }
        CheckMappingAndCheckOptionTSVUtils.writeCheckOptionsToFile((Path)pluginLinterOptionsFile, checkOptions);
    }

    private static Optional<ToolCheckOption> createCheckOption(String checkId, Map.Entry<String, JsonNode> optionsNodeEntry) {
        String optionId = optionsNodeEntry.getKey();
        JsonNode optionNode = optionsNodeEntry.getValue();
        String description = "";
        if (optionNode.has("description")) {
            description = optionNode.get("description").asText().replace("\n", " ").trim();
        }
        if (GoLangCILintUpdater.isFiltered(checkId, optionId, description)) {
            return Optional.empty();
        }
        String uniqueOptionId = GoLangCILintUtils.createUniqueOptionId(checkId, optionId);
        EToolCheckOptionType type = GoLangCILintUpdater.getOptionsType(checkId, optionId, optionNode);
        String defaultValue = GoLangCILintUpdater.getDefaultValue(checkId, optionId, optionNode);
        return Optional.of(new ToolCheckOption(checkId, uniqueOptionId, uniqueOptionId, description, type, defaultValue));
    }

    private static String getDefaultValue(String checkId, String optionId, JsonNode optionNode) {
        if ("revive".equals(checkId) && "max-open-files".equals(optionId)) {
            return String.valueOf(Integer.MAX_VALUE);
        }
        if ("misspell".equals(checkId)) {
            if ("locale".equals(optionId)) {
                return "US";
            }
            if ("mode".equals(optionId)) {
                return "";
            }
        }
        if (optionNode.has(JSON_DEFAULT_KEY)) {
            String result = optionNode.get(JSON_DEFAULT_KEY).toPrettyString();
            result = result.replace("[ [", "[").replace("] ]", "]");
            result = result.replace('\"', ' ');
            return result.trim();
        }
        JsonNode itemsNode = optionNode.get(JSON_ITEMS_KEY);
        if (itemsNode != null && itemsNode.has(JSON_DEFAULT_KEY)) {
            String result = itemsNode.get(JSON_DEFAULT_KEY).toPrettyString();
            result = result.replace("[ [", "[").replace("] ]", "]");
            result = result.replace('\"', ' ');
            return result.trim();
        }
        return null;
    }

    private static boolean isFiltered(String checkId, String optionId, String description) {
        return "severity".equals(optionId) || description.startsWith("DEPRECATED:") || "promlinter".equals(checkId) && "strict".equals(optionId);
    }

    private static EToolCheckOptionType getOptionsType(String checkId, String optionId, JsonNode optionsNode) {
        Optional<EToolCheckOptionType> optionType = GoLangCILintUpdater.provideTypeForOptionWithoutTypeInfos(checkId, optionId);
        if (optionType.isPresent()) {
            return optionType.get();
        }
        if (!optionsNode.has(JSON_TYPE_KEY)) {
            return EToolCheckOptionType.STRING;
        }
        return switch (optionsNode.get(JSON_TYPE_KEY).asText()) {
            case "array" -> GoLangCILintUpdater.getArrayType(optionsNode);
            case "boolean" -> EToolCheckOptionType.BOOLEAN;
            case "number", "integer" -> EToolCheckOptionType.INTEGER;
            case JSON_OBJECT_KEY -> EToolCheckOptionType.JSON;
            default -> EToolCheckOptionType.STRING;
        };
    }

    private static Optional<EToolCheckOptionType> provideTypeForOptionWithoutTypeInfos(String checkId, String optionId) {
        if ("godot".equals(checkId) && "scope".equals(optionId)) {
            return Optional.of(EToolCheckOptionType.STRING);
        }
        if ("misspell".equals(checkId) && Set.of("locale", "mode").contains(optionId) || "sloglint".equals(checkId) && Set.of("no-global", "context", "key-naming-case").contains(optionId)) {
            return Optional.of(EToolCheckOptionType.STRING);
        }
        return Optional.empty();
    }

    private static EToolCheckOptionType getArrayType(JsonNode optionsNode) {
        JsonNode typeNode;
        JsonNode itemsNode = optionsNode.get(JSON_ITEMS_KEY);
        if (itemsNode != null && (typeNode = itemsNode.get(JSON_TYPE_KEY)) != null && JSON_OBJECT_KEY.equals(typeNode.asText())) {
            return EToolCheckOptionType.JSON;
        }
        return EToolCheckOptionType.STRING_LIST;
    }

    public static List<PluginLinterMapping> writePluginLinterMappings(Path pluginLinterMappingsFile) throws IOException, GoLangCILintException {
        GoLangCILintRunner.ExecutionResult response = GoLangCILintRunner.getLintersListCommandLineOutput();
        if (!response.succeeded()) {
            throw new GoLangCILintException("Could not run GoLangCI-Lint to get list of plugin linters: " + response.errorsAndWarnings());
        }
        List<PluginLinterMapping> newPluginLinterMappings = GoLangCILintUpdater.createNewPluginLinterMappings(response.output());
        newPluginLinterMappings.add(new PluginLinterMapping(new CheckMapping(CUSTOM_CHECK_ID, "Custom linter", "Comprehensibility", "Bad Practice", EFindingEnablement.OFF, "The custom section can be used to define linter plugins to be loaded at runtime. See README of golangci-lint for more information.\\nEach custom linter should have a unique name.", "https://golangci-lint.run/usage/linters#custom", false), false));
        ArrayList<PluginLinterMapping> updatedPluginLinterMappings = new ArrayList<PluginLinterMapping>();
        Resource resource = Resource.of(GoLangCILintConfiguration.class, (String)"golangci-lint/check-mappings.tsv");
        Map oldCheckMappings = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)resource, (boolean)true, (boolean)true);
        Iterator<PluginLinterMapping> iterator = newPluginLinterMappings.iterator();
        while (iterator.hasNext()) {
            PluginLinterMapping pluginLinterMapping;
            PluginLinterMapping newPluginLinterMapping = pluginLinterMapping = iterator.next();
            if (oldCheckMappings.containsKey(pluginLinterMapping.checkMapping.checkId)) {
                CheckMapping existingMapping = (CheckMapping)oldCheckMappings.get(pluginLinterMapping.checkMapping.checkId);
                newPluginLinterMapping = new PluginLinterMapping(new CheckMapping(existingMapping.checkId, existingMapping.getReadableCheckName(), existingMapping.category, existingMapping.group, existingMapping.defaultEnablement, existingMapping.comments, existingMapping.upstreamURL, existingMapping.autoAllowed), newPluginLinterMapping.isPluginFast);
            }
            updatedPluginLinterMappings.add(newPluginLinterMapping);
        }
        CheckMappingAndCheckOptionTSVUtils.writeCheckMappingsToFile((Path)pluginLinterMappingsFile, (Collection)updatedPluginLinterMappings.stream().map(t -> t.checkMapping).collect(Collectors.toList()));
        return updatedPluginLinterMappings;
    }

    private static List<PluginLinterMapping> createNewPluginLinterMappings(String commandLineOutput) {
        List linterLines = StringUtils.splitLinesAsList((String)commandLineOutput);
        ArrayList<PluginLinterMapping> pluginLinterMappings = new ArrayList<PluginLinterMapping>();
        for (String linterLine : linterLines) {
            if (linterLine.contains("[deprecated]") || !linterLine.endsWith("]")) continue;
            pluginLinterMappings.add(GoLangCILintUpdater.createNewPluginLinterMappingFromLine(linterLine));
        }
        return pluginLinterMappings;
    }

    private static PluginLinterMapping createNewPluginLinterMappingFromLine(String linterLine) {
        int indexOfLastOpeningSquareBracket = linterLine.lastIndexOf("[");
        String linterWithoutSettings = linterLine.substring(0, indexOfLastOpeningSquareBracket);
        int indexOfFirstColon = linterWithoutSettings.indexOf(":");
        String checkId = linterWithoutSettings.substring(0, indexOfFirstColon);
        checkId = GoLangCILintUtils.createUniqueCheckId(checkId);
        String comment = linterWithoutSettings.substring(indexOfFirstColon + 1).trim();
        String upstreamUrl = "https://golangci-lint.run/usage/linters/#" + checkId;
        String linterSettings = linterLine.substring(indexOfLastOpeningSquareBracket + 1);
        String fastKeyAndValue = StringUtils.getFirstPart((String)linterSettings, (String)",");
        String fastValue = StringUtils.getFirstPart((String)fastKeyAndValue, (String)":").trim();
        boolean isPluginLinterFast = "true".equals(fastValue);
        return new PluginLinterMapping(new CheckMapping(checkId, "TODO", "TODO", "TODO", null, comment, upstreamUrl, false), isPluginLinterFast);
    }

    public record PluginLinterMapping(CheckMapping checkMapping, boolean isPluginFast) {
    }
}

