/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.phpstan;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.index.configuration.tools.PHPStanConfiguration;
import com.teamscale.index.findings.phpstan.ComposerExecutor;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementInfo;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;

class ComposerDependencyExtractor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Path COMPOSER_CACHE_DIR = Path.of("composer-cache", new String[0]);
    static final String COMPOSER_FILE_NAME = "composer.json";
    private final TokenElementIndexCache indexCache;

    public ComposerDependencyExtractor(TokenElementIndexCache indexCache) {
        this.indexCache = indexCache;
    }

    public Optional<Path> prepareComposerDependencies(Path rootPath, Collection<TokenElementInfo> tokenElementsToAnalyze) throws StorageException {
        List<TokenElementInfo> composerFiles = this.findComposerJsonFiles(tokenElementsToAnalyze);
        if (composerFiles.isEmpty()) {
            return Optional.empty();
        }
        LOGGER.info("Found the following composer file locations: {}", new Supplier[]{() -> composerFiles.stream().map(BasicTokenElementInfo::getUniformPath).collect(Collectors.joining(", "))});
        if (!PHPStanConfiguration.isComposerAvailable()) {
            LOGGER.warn("Skipping composer execution, as composer is not available on system");
            return Optional.empty();
        }
        for (TokenElementInfo composerElementInfo : composerFiles) {
            try {
                JsonNode composerRootNode = JsonUtils.getObjectMapper().readTree(composerElementInfo.getText());
                Path composerFile = rootPath.resolve(composerElementInfo.getUniformPath());
                LOGGER.info("Preparing composer for: {}", (Object)composerElementInfo.getUniformPath());
                ComposerDependencyExtractor.runComposer(composerRootNode, composerFile);
            }
            catch (IOException | ConQATException e) {
                LOGGER.error("Failed to execute composer on: {}", (Object)composerElementInfo.getUniformPath(), (Object)e);
            }
        }
        return Optional.of(ComposerDependencyExtractor.findBestRootComposerFiler(tokenElementsToAnalyze, composerFiles)).map(BasicTokenElementInfo::getUniformPath).map(rootPath::resolve);
    }

    private static TokenElementInfo findBestRootComposerFiler(Collection<TokenElementInfo> tokenElementsToAnalyze, List<TokenElementInfo> composerFiles) {
        if (composerFiles.size() == 1) {
            return composerFiles.getFirst();
        }
        HashMap<TokenElementInfo, Long> rootMapping = new HashMap<TokenElementInfo, Long>();
        for (TokenElementInfo composerFile : composerFiles) {
            UniformPath composerPath = UniformPathCompatibilityUtil.convert((String)composerFile.getUniformPath()).getParent();
            rootMapping.put(composerFile, tokenElementsToAnalyze.stream().filter(tokenElementInfo -> composerPath.hasDescendant(UniformPathCompatibilityUtil.convert((String)tokenElementInfo.getUniformPath()))).count());
        }
        return rootMapping.entrySet().stream().max(Comparator.comparingLong(Map.Entry::getValue)).map(Map.Entry::getKey).orElseThrow();
    }

    private List<TokenElementInfo> findComposerJsonFiles(Collection<TokenElementInfo> tokenElementsToAnalyze) throws StorageException {
        List<UniformPath> possibleComposerLocations = Stream.concat(Stream.of(UniformPath.ofSegments((String[])new String[]{COMPOSER_FILE_NAME})), tokenElementsToAnalyze.stream().map(BasicTokenElementInfo::getUniformPath).map(UniformPathCompatibilityUtil::convert).map(UniformPath::getParent).mapMulti((path, downstream) -> {
            while (!path.isRoot()) {
                downstream.accept(path);
                path = path.getParent();
            }
        }).map(path -> path.resolve(COMPOSER_FILE_NAME))).distinct().toList();
        return this.indexCache.getTokenElementInfos(possibleComposerLocations).stream().filter(Objects::nonNull).toList();
    }

    private static void runComposer(JsonNode rootNode, Path filePath) throws ConQATException, IOException {
        boolean bl;
        boolean shouldTryAgain;
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        do {
            ComposerExecutor.IComposerInstallResult iComposerInstallResult;
            Files.writeString(filePath, (CharSequence)rootNode.toString(), new OpenOption[0]);
            ComposerExecutor.IComposerInstallResult result = ComposerExecutor.runComposerInstall(filePath.getParent(), COMPOSER_CACHE_DIR);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((JsonNode)rootNode).toPrettyString();
            supplierArray[1] = () -> result;
            LOGGER.debug("Executed composer using composer.json:\n{}\n\nwith result: {}", supplierArray);
            Objects.requireNonNull(result);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ComposerExecutor.IComposerInstallResult.Success.class, ComposerExecutor.IComposerInstallResult.Failure.class}, (ComposerExecutor.IComposerInstallResult)iComposerInstallResult, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ComposerExecutor.IComposerInstallResult.Success success = (ComposerExecutor.IComposerInstallResult.Success)iComposerInstallResult;
                    bl = false;
                    break;
                }
                case 1: {
                    ComposerExecutor.IComposerInstallResult.Failure failure = (ComposerExecutor.IComposerInstallResult.Failure)iComposerInstallResult;
                    bl = ComposerDependencyExtractor.handleComposerFailure(failure, rootNode);
                }
            }
        } while (shouldTryAgain = bl);
    }

    @VisibleForTesting
    static boolean handleComposerFailure(ComposerExecutor.IComposerInstallResult.Failure failure, JsonNode composerRootNode) {
        boolean hasChanges = false;
        hasChanges |= ComposerDependencyExtractor.handleFailedDependencies(composerRootNode, failure.failingDependencies());
        if (!(hasChanges |= ComposerDependencyExtractor.handleFailedRepositories(composerRootNode, failure.invalidRepositories()))) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = failure::toString;
            supplierArray[1] = () -> ((JsonNode)composerRootNode).toPrettyString();
            LOGGER.warn("Failed to get a working composer setup.\nLast failure: {}\nLast composer.json:\n{}", supplierArray);
        }
        return hasChanges;
    }

    private static boolean handleFailedDependencies(JsonNode composerRootNode, Set<String> failingDependencies) {
        if (failingDependencies.isEmpty()) {
            return false;
        }
        LinkedHashSet<String> deletedDependencies = new LinkedHashSet<String>();
        for (String requireDirective : List.of("require", "require-dev")) {
            ObjectNode requireNode = composerRootNode.withObject(requireDirective);
            if (requireNode == null) continue;
            for (String failingDependency : failingDependencies) {
                JsonNode dependencyNode = requireNode.remove(failingDependency);
                if (dependencyNode == null) continue;
                deletedDependencies.add(failingDependency);
            }
        }
        LOGGER.info("Removed failing dependencies: {}", deletedDependencies);
        return !deletedDependencies.isEmpty();
    }

    private static boolean handleFailedRepositories(JsonNode composerRootNode, Set<String> invalidRepositories) {
        if (invalidRepositories.isEmpty()) {
            return false;
        }
        LinkedHashSet<String> removedRepositories = new LinkedHashSet<String>();
        Iterator iter = composerRootNode.withArray("repositories").iterator();
        while (iter.hasNext()) {
            JsonNode repositoryNode = (JsonNode)iter.next();
            String repositoryUrl = repositoryNode.get("url").asText();
            if (!invalidRepositories.contains(repositoryUrl)) continue;
            iter.remove();
            removedRepositories.add(repositoryUrl);
        }
        LOGGER.info("Removed failing repositories: {}", removedRepositories);
        return !removedRepositories.isEmpty();
    }
}

