/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.raex;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.findings.FindingsSchema;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.core.utils.TempFileFactory;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoFindings;
import com.teamscale.index.findings.FileToDiskWriter;
import com.teamscale.index.findings.LintFindingsSynchronizerBase;
import com.teamscale.index.findings.RaexExecutor;
import com.teamscale.index.report.parser.RaexWarningsParser;
import com.teamscale.reportparser.parser.ReportParserException;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;

public class RaexFindingsSynchronizer
extends LintFindingsSynchronizerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Charset ENCODING = StandardCharsets.UTF_8;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TypeIndex typeIndex;

    public RaexFindingsSynchronizer() {
        super("RA\u00cbX", EnumSet.copyOf(EAnalysisTool.RAEX.getSupportedLanguages()));
    }

    @Override
    protected Collection<BasicTokenElementInfo> getAdditionalRelevantElements(UnmodifiableCollection<BasicTokenElementInfo> elements) throws StorageException {
        Set paths = elements.stream().map(BasicTokenElementInfo::getUniformPath).collect(Collectors.toSet());
        List<String> changedTypes = this.typeIndex.getTypeNamesForFiles(new ArrayList<String>(paths)).stream().flatMap(Collection::stream).distinct().toList();
        List<String> filesForChangedTypes = this.typeIndex.getFilesForTypes(changedTypes).stream().flatMap(Collection::stream).distinct().filter(Predicate.not(paths::contains)).toList();
        return CollectionUtils.filterWithException(this.basicTokenElementIndex.getTokenElements(filesForChangedTypes), (FunctionWithException)this.tokenElementFilter);
    }

    @Override
    protected Optional<String> executeLint(Collection<BasicTokenElementInfo> changedFiles, CodeScopeName codeScopeName) throws ConQATException {
        try {
            return Optional.of(this.executeRaex(changedFiles, codeScopeName));
        }
        catch (IOException | ConQATException e) {
            throw new ConQATException(RaexFindingsSynchronizer.getErrorMessage(changedFiles), e);
        }
    }

    private static String getErrorMessage(Collection<BasicTokenElementInfo> tokenElementInfos) {
        List elementPaths = CollectionUtils.map(tokenElementInfos, BasicTokenElementInfo::getUniformPath);
        elementPaths.sort(Comparator.naturalOrder());
        return "Failed to execute RA\u00cbX for " + String.valueOf(elementPaths);
    }

    private String executeRaex(Collection<BasicTokenElementInfo> tokenElements, CodeScopeName codeScopeName) throws ConQATException, IOException {
        TempFileFactory tempFileFactory = this.getTempFileFactory();
        FileToDiskWriter fileToDiskWriter = new FileToDiskWriter(tempFileFactory);
        RaexExecutor raexExecutor = new RaexExecutor(tempFileFactory, tokenElements, fileToDiskWriter, this.writeRuleFile(tempFileFactory, codeScopeName));
        raexExecutor.execute();
        return raexExecutor.getReportFileContent();
    }

    @Override
    protected ListMap<String, IndexFinding> parseReport(String report) throws ConQATException {
        RaexWarningsParser raexWarningsParser = new RaexWarningsParser(EnumSet.of(EAnalysisTool.SONAR_LINT, EAnalysisTool.STYLECOP));
        RaexFindingsSynchronizer raexFindingsSynchronizer = this;
        raexWarningsParser.init(this.basicTokenElementIndex, this.getContentIndexCache(), this.tokenElementLineInfoIndex, null, this.pathLookupIndex, this.typeIndex, null, null, null, false, (x$0, x$1, x$2) -> raexFindingsSynchronizer.executeInParallelBatches(x$0, x$1, x$2), null);
        ListMap findings = new ListMap();
        try {
            raexWarningsParser.parseStringReport(report, null);
            List<ExternalAnalysisImportInfoFindings> analysisImportInfos = raexWarningsParser.getInfos().filterByType(ExternalAnalysisImportInfoFindings.class);
            for (ExternalAnalysisImportInfoFindings analysisImportInfo : analysisImportInfos) {
                findings.addAll((Object)analysisImportInfo.getUniformPath(), (Collection)analysisImportInfo.getData().stream().map(IndexFinding::asRealtimeFinding).collect(Collectors.toList()));
            }
        }
        catch (ReportParserException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        for (IndexFinding finding : (List)findings.getValues()) {
            String ruleID = (String)finding.getProperty("Rule ID");
            IndexFindingUtils.setGuidelineMapping((IndexFinding)finding, (String)ruleID, (ELanguage)ELanguage.CS);
        }
        return findings;
    }

    private CanonicalFile writeRuleFile(TempFileFactory tempFileFactory, CodeScopeName codeScopeName) {
        try {
            FindingsSchema findingsSchema = this.findingsSchemaIndex.getFindingsSchema(codeScopeName);
            if (findingsSchema == null) {
                return null;
            }
            String enabledRules = findingsSchema.getEnabledFindingTypeIds().stream().map(RaexFindingsSynchronizer::getToolIdFromFindingTypeId).collect(Collectors.joining("\n"));
            CanonicalFile rulesFile = tempFileFactory.getTempFile("", "rules.txt");
            FileSystemUtils.writeFile((Path)rulesFile.toPath(), (String)enabledRules, (Charset)ENCODING);
            return rulesFile;
        }
        catch (IOException | StorageException e) {
            LOGGER.warn("Could not write a rules file for RA\u00cbX", e);
            return null;
        }
    }

    private static String getToolIdFromFindingTypeId(String findingTypeId) {
        String raexRulePrefix = "RA\u00cbX/";
        if (StringUtils.startsWithOneOf((String)findingTypeId, (String[])new String[]{raexRulePrefix})) {
            return StringUtils.stripPrefix((String)findingTypeId, (String)raexRulePrefix);
        }
        return null;
    }
}

