/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint;

import com.google.common.html.HtmlEscapers;
import com.google.common.net.UrlEscapers;
import com.teamscale.index.configuration.tools.Rule;
import com.teamscale.index.configuration.tools.SonarLintConfiguration;
import com.teamscale.index.findings.sonarlint.SonarLintEnginePool;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.registry.CheckMapping;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.resources.Resource;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneRuleDetails;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.RuleKey;

public class SonarLintRulesExtractor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern RULE_LINK = Pattern.compile("\\{rule:([a-z]+):(S[0-9]+)}");
    private static final Pattern HTML_CODE_BLOCK_PATTERN = Pattern.compile("<pre[^>]*>(.*?)</pre>", 32);
    private static final Path SONAR_LINT_CHECK_MAPPINGS = Path.of("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/", "message/sonarlint/check-mappings.tsv");
    private static final File SONAR_LINT_DESCRIPTIONS_DIRECTORY = new File("server/com.teamscale.index/check-descriptions/sonarlint");
    private final StandaloneSonarLintEngine engine;

    public SonarLintRulesExtractor(StandaloneSonarLintEngine engine) {
        this.engine = engine;
    }

    public void execute() throws IOException {
        Map<String, CheckMapping> existingRules = SonarLintRulesExtractor.getExistingSonarLintRulesBySonarID();
        Map<String, CheckMapping> availableChecks = SonarLintRulesExtractor.getAvailableSonarLintChecks(this.engine);
        CheckMappingAndCheckOptionTSVUtils.updateCheckMapping(existingRules, availableChecks);
        SonarLintRulesExtractor.checkSameMappingAcrossLanguages(existingRules);
        this.verifyEnablementWithSonarLintSeverity(existingRules);
        CheckMappingAndCheckOptionTSVUtils.writeCheckMappingsToFile((Path)SONAR_LINT_CHECK_MAPPINGS, existingRules.values().stream().toList());
        LOGGER.info("New mappings TSV file has been written to " + String.valueOf(SONAR_LINT_CHECK_MAPPINGS));
        this.extractCheckDescriptions(existingRules);
    }

    private void verifyEnablementWithSonarLintSeverity(Map<String, CheckMapping> existingRules) {
        for (RuleDetails sonarLintRule : this.engine.getAllRuleDetails()) {
            CheckMapping checkMapping = existingRules.get(sonarLintRule.getKey());
            if (checkMapping.comments.contains("IgnoreSonarLintSeverity")) continue;
            if (sonarLintRule.getDefaultSeverity() == IssueSeverity.BLOCKER && checkMapping.defaultEnablement != EFindingEnablement.RED) {
                LOGGER.warn("BLOCKER should probably have RED enablement: " + String.valueOf(checkMapping));
            }
            if (sonarLintRule.getDefaultSeverity() != IssueSeverity.CRITICAL || checkMapping.defaultEnablement == EFindingEnablement.YELLOW || checkMapping.defaultEnablement == EFindingEnablement.RED) continue;
            LOGGER.warn("CRITICAL should probably have YELLOW or RED enablement: " + String.valueOf(checkMapping));
        }
    }

    private static void checkSameMappingAcrossLanguages(Map<String, CheckMapping> existingRules) {
        Map<String, List<Map.Entry>> groupedRules = existingRules.entrySet().stream().collect(Collectors.groupingBy(elem -> ((String)elem.getKey()).split(":")[1]));
        for (List<Map.Entry> entry : groupedRules.values()) {
            List<Map.Entry> distinctCategorization = entry.stream().filter(element -> {
                CheckMapping other = (CheckMapping)((Map.Entry)entry.get(0)).getValue();
                return !((CheckMapping)element.getValue()).comments.contains("IgnoreDifferentClassification") && (!((CheckMapping)element.getValue()).category.equals(other.category) || !((CheckMapping)element.getValue()).group.equals(other.group));
            }).toList();
            if (distinctCategorization.isEmpty()) continue;
            LOGGER.warn("Found mismatched check categorization across languages: " + String.valueOf(entry));
        }
        for (List<Map.Entry> entry : groupedRules.values()) {
            List<Map.Entry> distinctEnablement = entry.stream().filter(element -> {
                CheckMapping other = (CheckMapping)((Map.Entry)entry.get(0)).getValue();
                return !((CheckMapping)element.getValue()).comments.contains("IgnoreDifferentEnablement") && ((CheckMapping)element.getValue()).defaultEnablement != other.defaultEnablement;
            }).toList();
            if (distinctEnablement.isEmpty()) continue;
            LOGGER.warn("Found mismatched check enablement across languages: " + String.valueOf(entry));
        }
    }

    private void extractCheckDescriptions(Map<String, CheckMapping> rules) throws IOException {
        for (RuleDetails sonarLintRule : this.engine.getAllRuleDetails()) {
            File file = new File(SONAR_LINT_DESCRIPTIONS_DIRECTORY, sonarLintRule.getKey().replace(':', '_') + ".md");
            if (SonarLintRulesExtractor.isRuleIgnored(rules, sonarLintRule)) {
                Files.deleteIfExists(file.toPath());
                continue;
            }
            String htmlDescription = RULE_LINK.matcher(sonarLintRule.getHtmlDescription()).replaceAll(matchResult -> this.renderRuleLink((MatchResult)matchResult, rules));
            htmlDescription = SonarLintRulesExtractor.convertHtmlPreTags(htmlDescription, sonarLintRule);
            FileSystemUtils.writeFileUTF8((Path)file.toPath(), (String)htmlDescription);
        }
    }

    private static boolean isRuleIgnored(Map<String, CheckMapping> rules, RuleDetails sonarLintRule) {
        return rules.get((Object)sonarLintRule.getKey()).defaultEnablement == null;
    }

    private static String convertHtmlPreTags(String htmlDescription, RuleDetails sonarLintRule) {
        Matcher matcher = HTML_CODE_BLOCK_PATTERN.matcher(htmlDescription);
        StringBuilder html = new StringBuilder();
        while (matcher.find()) {
            Object codeBlockUnescaped = StringEscapeUtils.unescapeHtml4((String)matcher.group(1));
            codeBlockUnescaped = "\n```" + sonarLintRule.getLanguage().getLanguageKey() + (String)codeBlockUnescaped + "```";
            matcher.appendReplacement(html, Matcher.quoteReplacement((String)codeBlockUnescaped));
        }
        matcher.appendTail(html);
        return html.toString();
    }

    private String renderRuleLink(MatchResult matchResult, Map<String, CheckMapping> rules) {
        String language = matchResult.group(1);
        String ruleId = matchResult.group(2);
        String ruleKey = String.format("%s:%s", language, ruleId);
        if (rules.containsKey(ruleKey)) {
            return String.format("<a href='checks/checks/?languages=%s&tools=SONAR_LINT&rule=%s'>%s</a>", language.toUpperCase(Locale.ROOT), UrlEscapers.urlFragmentEscaper().escape(ruleKey), HtmlEscapers.htmlEscaper().escape(ruleKey));
        }
        LOGGER.warn("Could not generate link to SonarLint rule {}", (Object)ruleKey);
        return HtmlEscapers.htmlEscaper().escape(ruleKey);
    }

    public static Map<String, CheckMapping> getExistingSonarLintRulesBySonarID() {
        Resource mappingsFile = Resource.of(SonarLintConfiguration.class, (String)"message/sonarlint/check-mappings.tsv");
        return new TreeMap<String, CheckMapping>(CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)mappingsFile, (boolean)true, (boolean)true));
    }

    private static @NonNull List<Rule> getAvailableSonarLintRules(StandaloneSonarLintEngine engine) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (RuleDetails sonarLintRule : engine.getAllRuleDetails()) {
            rules.add(SonarLintRulesExtractor.createRule(sonarLintRule));
        }
        return rules;
    }

    @VisibleForTesting
    public static Map<String, CheckMapping> getAvailableSonarLintChecks(StandaloneSonarLintEngine engine) {
        List<Rule> availableRules = SonarLintRulesExtractor.getAvailableSonarLintRules(engine);
        HashMap<String, CheckMapping> availableChecks = new HashMap<String, CheckMapping>();
        availableRules.forEach(rule -> availableChecks.put(rule.id, new CheckMapping(rule.id, rule.message, "TODO", "TODO", null)));
        return availableChecks;
    }

    private static Rule createRule(RuleDetails sonarLintRule) {
        Rule result = new Rule();
        result.id = sonarLintRule.getKey();
        result.message = sonarLintRule.getName() + " (" + sonarLintRule.getKey() + ")";
        return result;
    }

    public static Map<String, String> getDeprecatedRuleKeysMapping() throws ConQATException {
        HashMap<String, String> mapping = new HashMap<String, String>();
        StandaloneSonarLintEngine engine = null;
        try {
            engine = SonarLintEnginePool.createEngine();
            for (RuleDetails sonarLintRule : engine.getAllRuleDetails()) {
                if (!(sonarLintRule instanceof StandaloneRuleDetails)) continue;
                StandaloneRuleDetails ruleDetails = (StandaloneRuleDetails)sonarLintRule;
                SonarLintRulesExtractor.addDeprecatedRules(mapping, ruleDetails);
            }
        }
        catch (IOException e) {
            throw new ConQATException((Throwable)e);
        }
        finally {
            SonarLintEnginePool.returnEngine(engine);
        }
        return mapping;
    }

    private static void addDeprecatedRules(Map<String, String> mapping, StandaloneRuleDetails sonarLintRule) {
        for (RuleKey deprecatedKey : sonarLintRule.getDeprecatedKeys()) {
            mapping.put(deprecatedKey.toString(), sonarLintRule.getKey());
        }
    }
}

