/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap;

import com.teamscale.index.gitbridge.GitBridgeException;
import com.teamscale.index.testgap.abap.AbapTableDumpXmlHandler;
import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Map;
import java.util.TimeZone;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.xml.sax.SAXException;

public abstract class AbapExportXmlTableReaderBase<E extends Enum<E>> {
    private Map<E, String> currentRecord;
    private final Class<E> clazz;

    protected AbapExportXmlTableReaderBase(Class<E> clazz) {
        this.clazz = clazz;
    }

    protected void readRecords(String rawZipFileContent) throws GitBridgeException {
        AbapTableDumpXmlHandler<E> handler = new AbapTableDumpXmlHandler<E>(this.clazz, ((Enum)this.getRecordElement()).name());
        try {
            String zipFileContent = XMLUtils.fixIllegalXmlChars((String)rawZipFileContent);
            XMLUtils.parseSAX((String)zipFileContent, handler);
        }
        catch (IOException | SAXException e) {
            throw new GitBridgeException("Unable to parse content.", e);
        }
        for (Map<E, String> record : handler.getRecords()) {
            this.currentRecord = record;
            this.processRecord();
        }
    }

    protected abstract E getRecordElement();

    protected abstract void processRecord() throws GitBridgeException;

    protected UniqueAbapElementName readElementName(E objectNameField, E objectTypeField) {
        String objectName = this.getChildText(objectNameField);
        EAbapObjectType objectType = EAbapObjectType.getValue((String)this.getChildText(objectTypeField));
        if (objectType == EAbapObjectType.UNKNOWN) {
            return new UniqueAbapElementName(objectName, objectType, this.getChildText(objectTypeField));
        }
        return new UniqueAbapElementName(objectName, objectType);
    }

    protected UniqueAbapElementName readElementName(E objectNameField, E objectTypeField, E ddicTypeField) {
        String ddicTypeName = this.getChildText(ddicTypeField);
        if (StringUtils.isEmpty((String)ddicTypeName)) {
            return this.readElementName(objectNameField, objectTypeField);
        }
        EAbapObjectType ddicType = EAbapObjectType.valueOf((String)ddicTypeName);
        String objectName = this.getChildText(objectNameField);
        return new UniqueAbapElementName(objectName, ddicType);
    }

    protected String getChildText(E field) {
        return this.currentRecord.get(field);
    }

    protected boolean hasChild(E field) {
        return this.currentRecord.containsKey(field);
    }

    protected Instant readDateAndTime(E dateField, E timeField, ZoneId sapTimeZone) {
        try {
            return AbapUtils.buildUpdateDate((String)this.getChildText(dateField), (String)this.getChildText(timeField), (TimeZone)TimeZone.getTimeZone(sapTimeZone)).toInstant();
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected boolean readBoolean(E field, boolean defaultForNull) {
        String valueStr = this.getChildText(field);
        if (valueStr == null) {
            return defaultForNull;
        }
        if ((valueStr = valueStr.trim()).equals("X")) {
            return true;
        }
        return Boolean.parseBoolean(valueStr);
    }
}

