/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap.metadata;

import com.teamscale.index.gitbridge.abap.metadata.IAbapGitMetaDataWriter;
import com.teamscale.index.metadata.abap.AbapFileMetadata;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.lib.commons.string.StringUtils;

abstract class AbapGitMetaDataWriterBase
implements IAbapGitMetaDataWriter {
    protected static final Logger LOGGER = LogManager.getLogger();
    private final String serializer;

    protected AbapGitMetaDataWriterBase() {
        this.serializer = null;
    }

    protected AbapGitMetaDataWriterBase(String serializer) {
        this.serializer = serializer;
    }

    protected AbapGitMetaDataWriterBase(EAbapObjectType objectType) {
        this(String.format("LCL_OBJECT_%s", objectType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(AbapFileMetadata metadata, OutputStream outputStream) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try (XMLStreamWriter writer = outputFactory.createXMLStreamWriter(outputStream);){
            writer.writeStartDocument();
            writer.writeStartElement("abapGit");
            writer.writeAttribute("version", "v1.0.0");
            if (this.serializer != null) {
                writer.writeAttribute("serializer", this.serializer);
                writer.writeAttribute("serializer_version", "v1.0.0");
            }
            writer.writeStartElement("asx:abap");
            writer.writeAttribute("xmlns:asx", "http://www.sap.com/abapxml");
            writer.writeAttribute("version", "1.0");
            writer.writeStartElement("asx:values");
            this.write(metadata, writer);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
    }

    protected abstract void write(AbapFileMetadata var1, XMLStreamWriter var2) throws XMLStreamException;

    protected static void writeLeaf(XMLStreamWriter writer, String field, String content) throws XMLStreamException {
        if (content == null) {
            LOGGER.debug("Could not write meta data for {} field because content was null", (Object)field);
            return;
        }
        writer.writeStartElement(field);
        writer.writeCharacters(content);
        writer.writeEndElement();
    }

    protected static String extractFileName(AbapFileMetadata metadata) {
        return StringUtils.getFirstPart((String)StringUtils.getLastPart((String)metadata.getFilePath(), (String)"/"), (String)".").replace("!", "/").toUpperCase();
    }
}

