/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.cleanup;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.issues.cleanup.IWorkItemCleanupStrategy;
import com.teamscale.index.issues.cleanup.WorkItemCleanupIndex;
import java.time.Instant;
import java.time.LocalDate;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;

public class OnceEveryDayCleanupStrategy
implements IWorkItemCleanupStrategy {
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    private WorkItemCleanupIndex index;
    private static final String CLEANUP_INDEX_KEY = OnceEveryDayCleanupStrategy.class.getSimpleName() + "-last-cleanup-date";

    @Override
    public boolean shouldPerformCleanup(Instant timestamp) throws StorageException {
        Instant lastCleanup = this.index.getValue(CLEANUP_INDEX_KEY, Instant.class).orElse(Instant.EPOCH);
        return OnceEveryDayCleanupStrategy.shouldPerformCleanup(timestamp, lastCleanup);
    }

    public static boolean shouldPerformCleanup(Instant currentTimestamp, Instant lastCleanupTimestamp) {
        LocalDate lastCleanupDate = LocalDate.ofInstant(lastCleanupTimestamp, DateTimeUtils.getZone());
        LocalDate currentDate = LocalDate.ofInstant(currentTimestamp, DateTimeUtils.getZone());
        return currentDate.isAfter(lastCleanupDate);
    }

    @Override
    public void cleanupPerformed(Instant timestamp) throws StorageException {
        this.index.setValue(CLEANUP_INDEX_KEY, timestamp);
    }
}

