/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.gitlab.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum EGitLabIssueState {
    OPEN,
    CLOSED,
    UNKNOWN;

    private static final Logger LOGGER;

    @JsonCreator
    public static EGitLabIssueState fromJsonString(String value) {
        return switch (value) {
            case "opened", "reopened" -> OPEN;
            case "closed" -> CLOSED;
            default -> {
                LOGGER.warn("Unknown Issue State: {}", (Object)value);
                yield UNKNOWN;
            }
        };
    }

    public String getHumanReadable() {
        return this.name();
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

