/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.updater;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.issues.updater.IssueTrackerContentUpdaterBase;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.List;
import java.util.function.Function;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS, EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class SpecItemIndexUpdateTrigger
extends IssueTrackerContentUpdaterBase<SpecItem> {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SpecItemIndex workItemIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SpecItemHistoryIndex historyIndex;

    @Override
    protected void handleWorkItemUpdates(List<SpecItem> updatedItems, List<TeamscaleIssueId> deletedItemIds) throws StorageException {
        long timestamp = this.getSchedulingCommit().getTimestamp();
        if (!deletedItemIds.isEmpty()) {
            this.historyIndex.remove(deletedItemIds, timestamp);
            this.workItemIndex.removeIssues(deletedItemIds);
        }
        if (!updatedItems.isEmpty()) {
            this.workItemIndex.setIssues(updatedItems);
            PairList itemsWithTimestamp = (PairList)updatedItems.stream().collect(PairList.toPairList(ignored -> timestamp, Function.identity()));
            this.historyIndex.store(itemsWithTimestamp);
        }
        this.workItemIndex.setLastChange(this.getConnectorIdentifier(), timestamp);
    }
}

