/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.updater;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.impl.rollback.PostRevisionAnalysisTriggerBase;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.requirements_tracing.index.TempWorkItemIndex;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.store.StorageException;

public class TempWorkItemIndexCleaner
extends PostRevisionAnalysisTriggerBase {
    public void execute() throws Exception {
        CommitDescriptor schedulingCommit = this.getSchedulingCommit();
        String connectorId = this.getConnectorId(schedulingCommit);
        if (connectorId == null) {
            return;
        }
        TempWorkItemIndex tempWorkItemIndex = (TempWorkItemIndex)this.openNamedIndexInProject(TempWorkItemIndex.getIndexNameForRepository(connectorId), TempWorkItemIndex.class, null);
        tempWorkItemIndex.removeChangesForCommit(schedulingCommit);
    }

    private String getConnectorId(CommitDescriptor schedulingCommit) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)this.getProjectId(), (IndexLayer)this.indexLayer);
        List requirementConnectors = ProjectConfigurationUtils.getRequirementConnectors((ProjectConfiguration)projectConfiguration);
        for (ConnectorConfiguration requirementConnector : requirementConnectors) {
            String requirementConnectorBranchName = SpecItemIndex.matchRequirementsManagementConnectorIdToBranchName(requirementConnector.getIdentifier());
            if (!schedulingCommit.getBranchName().equals(requirementConnectorBranchName)) continue;
            return requirementConnector.getIdentifier();
        }
        return null;
    }

    public ETriggerCost getExpectedCost() {
        return ETriggerCost.CHEAP;
    }

    public boolean canCauseSchedulingConflicts() {
        return false;
    }
}

