/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.updater;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.issues.updater.IssueTrackerContentUpdaterBase;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.TeamscaleIssueTypeInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

public abstract class TypeSpecificIssueTrackerContentUpdaterBase
extends IssueTrackerContentUpdaterBase<SpecItem> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String INCLUDED_TYPES_STEP_PARAMETER_NAME = "includedTypes";
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    protected SpecItemIndex previousIssueIndex;
    @StepParameter(value="includedTypes", optional=true)
    private final Set<String> includedTypes = new HashSet<String>();

    @Override
    protected final void handleWorkItemUpdates(List<SpecItem> updatedItems, List<TeamscaleIssueId> deletedItemIds) throws StorageException {
        List<TeamscaleIssueId> typeFilteredDeletedItemIds;
        List<SpecItem> typeFilteredUpdatedItems;
        if (this.includedTypes.isEmpty()) {
            typeFilteredUpdatedItems = updatedItems;
            typeFilteredDeletedItemIds = deletedItemIds;
        } else {
            typeFilteredUpdatedItems = updatedItems.stream().filter(this::isTypeIncluded).toList();
            typeFilteredDeletedItemIds = new ArrayList<TeamscaleIssueId>(deletedItemIds.size());
            for (TeamscaleIssueId deletedItemId : deletedItemIds) {
                SpecItem issue = (SpecItem)this.previousIssueIndex.getIssue(deletedItemId);
                if (issue == null) {
                    LOGGER.warn("Could not find previous item for deleted item id {}", (Object)deletedItemId);
                    continue;
                }
                if (!this.isTypeIncluded(issue)) continue;
                typeFilteredDeletedItemIds.add(deletedItemId);
            }
        }
        this.handleTypeFilteredWorkItemUpdates(typeFilteredUpdatedItems, typeFilteredDeletedItemIds);
    }

    protected abstract void handleTypeFilteredWorkItemUpdates(List<SpecItem> var1, List<TeamscaleIssueId> var2) throws StorageException;

    private boolean isTypeIncluded(SpecItem item) {
        TeamscaleIssueTypeInfo typeInfo = item.getTypeInfo();
        if (typeInfo == null) {
            return false;
        }
        return this.includedTypes.contains(typeInfo.getType()) || this.includedTypes.contains(typeInfo.getTypeAbbreviation());
    }
}

