/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.google.common.base.Preconditions;
import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.commons.links.TeamscaleLinkProvider;
import com.teamscale.commons.links.TeamscaleProjectLinkProvider;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.critical_change.CriticalChangeBadgesConfigurationEntry;
import com.teamscale.index.commit_alert.CommitAlerts;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestTestGapInfo;
import com.teamscale.index.merge_request.commit_alerts.CommitAlertsInfo;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChange;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChangeInfo;
import com.teamscale.index.merge_request.metrics.IMergeRequestMetricEvaluationResult;
import com.teamscale.index.merge_request.metrics.MergeRequestMetricThresholdsInfo;
import com.teamscale.index.merge_request.testcoverage.TestCoverageDeltaInfo;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.IVotingInput;
import com.teamscale.index.requirements_tracing.merge_request.ImpactedSpecItemsDelta;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.FindingDelta;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class MergeRequestAnnotationInput
implements IVotingInput {
    private static final int METRIC_BADGES_PER_LINE_LIMIT = 3;
    private final FindingDelta findingsDelta;
    private final FindingDelta relevantFindingsDelta;
    public final boolean ignoreYellowFindingsForVotes;
    private final boolean ignoreYellowFindingsForComments;
    private final boolean isFindingsBadgeEnabled;
    private final boolean isTestGapBadgeEnabled;
    private final boolean isMetricThresholdBadgesEnabled;
    public final CommitDescriptor sourceCommit;
    public final CommitDescriptor targetCommit;
    public final MergeBaseInfo mergeBase;
    public final MergeRequest mergeRequest;
    public final ImpactedSpecItemsDelta impactedSpecItemsDelta;
    public final @Nullable MergeRequestTestGapInfo testGapInfo;
    public final @Nullable TestCoverageDeltaInfo testCoverageDeltaInfo;
    public final MergeRequestMetricThresholdsInfo metricThresholdsInfo;
    public final @Nullable MergeRequestCriticalChangeInfo criticalChangeInfo;
    public final List<CommitAlerts> commitAlerts;
    private final String connectorType;
    private final int totalCommitAlertsFromAllCommits;

    private MergeRequestAnnotationInput(FindingDelta findingsDelta, FindingDelta relevantFindingsDelta, boolean ignoreYellowFindingsForVotes, boolean ignoreYellowFindingsForComments, boolean isFindingsBadgeEnabled, boolean isTestGapBadgeEnabled, boolean isMetricThresholdBadgesEnabled, CommitDescriptor sourceCommit, CommitDescriptor targetCommit, MergeBaseInfo mergeBase, MergeRequest mergeRequest, ImpactedSpecItemsDelta impactedSpecItemsDelta, @Nullable MergeRequestTestGapInfo testGapInfo, @Nullable TestCoverageDeltaInfo testCoverageDeltaInfo, @Nullable MergeRequestMetricThresholdsInfo metricThresholdsInfo, @Nullable MergeRequestCriticalChangeInfo criticalChangeInfo, String connectorType, List<CommitAlerts> commitAlerts, int totalCommitAlertsFromAllCommits) {
        this.findingsDelta = findingsDelta;
        this.relevantFindingsDelta = relevantFindingsDelta;
        this.ignoreYellowFindingsForVotes = ignoreYellowFindingsForVotes;
        this.ignoreYellowFindingsForComments = ignoreYellowFindingsForComments;
        this.isFindingsBadgeEnabled = isFindingsBadgeEnabled;
        this.isTestGapBadgeEnabled = isTestGapBadgeEnabled;
        this.isMetricThresholdBadgesEnabled = isMetricThresholdBadgesEnabled;
        this.sourceCommit = sourceCommit;
        this.targetCommit = targetCommit;
        this.mergeBase = mergeBase;
        this.mergeRequest = mergeRequest;
        this.impactedSpecItemsDelta = impactedSpecItemsDelta;
        this.testGapInfo = testGapInfo;
        this.testCoverageDeltaInfo = testCoverageDeltaInfo;
        this.metricThresholdsInfo = metricThresholdsInfo;
        this.criticalChangeInfo = criticalChangeInfo;
        this.commitAlerts = commitAlerts;
        this.connectorType = connectorType;
        this.totalCommitAlertsFromAllCommits = totalCommitAlertsFromAllCommits;
    }

    public static Builder builder() {
        return new Builder();
    }

    public FindingDelta getFindingsDelta() {
        return this.findingsDelta;
    }

    public FindingDelta getRelevantFindingsDelta() {
        return this.relevantFindingsDelta;
    }

    public List<TrackedFinding> getAddedFindings() {
        return new ArrayList<TrackedFinding>(this.relevantFindingsDelta.getAddedFindings());
    }

    public List<TrackedFinding> getAddedFindingsForVoting() {
        return this.getRelevantAddedFindings(this.ignoreYellowFindingsForVotes);
    }

    public List<TrackedFinding> getAddedFindingsForLineComments() {
        return this.getRelevantAddedFindings(this.ignoreYellowFindingsForComments);
    }

    public List<TrackedFinding> getAddedRedFindings() {
        List relevantAddedFindings = this.relevantFindingsDelta.getAddedFindings();
        return CollectionUtils.filter((Collection)relevantAddedFindings, finding -> finding.getAssessment() == ETrafficLightColor.RED);
    }

    public List<TrackedFinding> getAddedYellowFindings() {
        List relevantAddedFindings = this.relevantFindingsDelta.getAddedFindings();
        return CollectionUtils.filter((Collection)relevantAddedFindings, finding -> finding.getAssessment() != ETrafficLightColor.RED);
    }

    private List<TrackedFinding> getRelevantAddedFindings(boolean ignoreYellowFindings) {
        if (ignoreYellowFindings) {
            return this.getAddedRedFindings();
        }
        return this.relevantFindingsDelta.getAddedFindings();
    }

    public String buildMergeBadgesAsMarkdown(TeamscaleProjectLinkProvider linkProvider, boolean showRequirementsBadge, boolean includeTestGapBadge, boolean includeCriticalChangeBadges, boolean shouldAppendSizeValues, boolean omitTitle) {
        StringBuilder builder = new StringBuilder();
        String mergeRequestLink = linkProvider.createMergeRequestDetailsLink(this.mergeRequest.identifier);
        this.appendTeamscaleLogo(builder, linkProvider, mergeRequestLink, shouldAppendSizeValues);
        this.appendFindingsBadge(builder, linkProvider, mergeRequestLink, shouldAppendSizeValues);
        this.appendCommitAlertsBadge(builder, linkProvider, mergeRequestLink, shouldAppendSizeValues);
        if (includeTestGapBadge) {
            this.appendTestGapBadge(builder, linkProvider, mergeRequestLink, shouldAppendSizeValues);
        }
        if (showRequirementsBadge) {
            MergeRequestAnnotationInput.appendMarkdownImage(builder, MergeRequestAnnotationInput.getAltText(this.impactedSpecItemsDelta), linkProvider.createStaticSpecItemsBadgeUrl(this.impactedSpecItemsDelta.size()), mergeRequestLink, shouldAppendSizeValues);
        }
        if (includeCriticalChangeBadges) {
            this.appendCriticalChangeBadgesSection(builder, linkProvider, mergeRequestLink, shouldAppendSizeValues, omitTitle);
        }
        if (this.isMetricThresholdBadgesEnabled) {
            this.appendMetricBadgesSection(linkProvider, shouldAppendSizeValues, omitTitle, builder, mergeRequestLink);
        }
        return builder.toString();
    }

    private void appendCriticalChangeBadgesSection(StringBuilder builder, TeamscaleProjectLinkProvider linkProvider, String mergeRequestLink, boolean shouldAppendSizeValues, boolean omitTitle) {
        if (this.criticalChangeInfo == null || this.criticalChangeInfo.criticalChanges().isEmpty()) {
            return;
        }
        if (this.criticalChangeInfo.criticalChanges().size() > 3) {
            MergeRequestAnnotationInput.appendEmptyLine(builder);
        }
        int appendedBadges = 0;
        for (MergeRequestCriticalChange criticalChange : this.criticalChangeInfo.criticalChanges()) {
            if (appendedBadges > 0 && appendedBadges % 3 == 0) {
                MergeRequestAnnotationInput.appendEmptyLine(builder);
            }
            MergeRequestAnnotationInput.appendCriticalChangeBadge(builder, linkProvider, mergeRequestLink, shouldAppendSizeValues, omitTitle, criticalChange.criticalChangeBadgeConfigurationEntry());
            ++appendedBadges;
        }
        if (this.criticalChangeInfo.criticalChanges().size() > 3) {
            MergeRequestAnnotationInput.appendEmptyLine(builder);
        }
    }

    private static void appendCriticalChangeBadge(StringBuilder builder, TeamscaleProjectLinkProvider linkProvider, String mergeRequestLink, boolean shouldAppendSizeValues, boolean omitTitle, CriticalChangeBadgesConfigurationEntry configuredBadge) {
        String textDescription = configuredBadge.badgeHoverText();
        if (textDescription == null) {
            textDescription = "";
        }
        Object linkTextWithTooltip = mergeRequestLink;
        if (!StringUtils.isEmpty((String)configuredBadge.badgeLink())) {
            linkTextWithTooltip = configuredBadge.badgeLink();
        }
        if (!omitTitle) {
            linkTextWithTooltip = (String)linkTextWithTooltip + " \"%s\"".formatted(MergeRequestAnnotationInput.escapeQuotes(textDescription));
        }
        MergeRequestAnnotationInput.appendMarkdownImage(builder, textDescription, linkProvider.createStaticCriticalChangeBadgeUrl(configuredBadge.badgeTitle(), configuredBadge.badgeText(), configuredBadge.badgeColor(), configuredBadge.badgeHoverText()), (String)linkTextWithTooltip, shouldAppendSizeValues);
    }

    public String buildTestGapBadgeAsMarkdown(TeamscaleProjectLinkProvider linkProvider, boolean shouldAppendSizeValues) {
        StringBuilder builder = new StringBuilder();
        String linkText = linkProvider.createMergeRequestDetailsLink(this.mergeRequest.identifier);
        this.appendTeamscaleLogo(builder, linkProvider, linkText, shouldAppendSizeValues);
        this.appendTestGapBadge(builder, linkProvider, linkText, shouldAppendSizeValues);
        return builder.toString();
    }

    public String buildCriticalChangeBadgeAsMarkdown(CriticalChangeBadgesConfigurationEntry badgeConfiguration, TeamscaleProjectLinkProvider linkProvider) {
        StringBuilder builder = new StringBuilder();
        String linkText = linkProvider.createMergeRequestDetailsLink(this.mergeRequest.identifier);
        this.appendTeamscaleLogo(builder, linkProvider, linkText, false);
        MergeRequestAnnotationInput.appendCriticalChangeBadge(builder, linkProvider, linkText, false, false, badgeConfiguration);
        return builder.toString();
    }

    private void appendMetricBadgesSection(TeamscaleProjectLinkProvider linkProvider, boolean shouldAppendSizeValues, boolean omitTitle, StringBuilder builder, String mergeRequestLink) {
        Preconditions.checkState((boolean)this.isMetricThresholdBadgesEnabled, (Object)"Attempting to add metric badges section even though it is disabled.");
        Preconditions.checkArgument((this.metricThresholdsInfo != null ? 1 : 0) != 0, (Object)"Metric threshold info was not provided even though metric badges are enabled.");
        this.appendMetricBadgesSection(this.metricThresholdsInfo.evaluatedMetricGroups(), linkProvider, shouldAppendSizeValues, omitTitle, builder, mergeRequestLink);
        this.appendMetricBadgesSection(this.metricThresholdsInfo.evaluatedMetrics(), linkProvider, shouldAppendSizeValues, omitTitle, builder, mergeRequestLink);
    }

    private <MetricEvaluationResult extends IMergeRequestMetricEvaluationResult> void appendMetricBadgesSection(Set<MetricEvaluationResult> metrics, TeamscaleProjectLinkProvider linkProvider, boolean shouldAppendSizeValues, boolean omitTitle, StringBuilder builder, String mergeRequestLink) {
        ArrayList evaluationResults = CollectionUtils.sort(metrics);
        if (evaluationResults.isEmpty()) {
            return;
        }
        if (evaluationResults.size() > 3) {
            MergeRequestAnnotationInput.appendEmptyLine(builder);
        }
        int appendedBadges = 0;
        for (IMergeRequestMetricEvaluationResult evaluationResult : evaluationResults) {
            if (appendedBadges > 0 && appendedBadges % 3 == 0) {
                MergeRequestAnnotationInput.appendEmptyLine(builder);
            }
            String textDescription = evaluationResult.getTextDescription();
            Object linkTextWithTooltip = mergeRequestLink;
            if (!omitTitle) {
                linkTextWithTooltip = (String)linkTextWithTooltip + " \"%s\"".formatted(MergeRequestAnnotationInput.escapeQuotes(textDescription));
            }
            MergeRequestAnnotationInput.appendMarkdownImage(builder, textDescription, evaluationResult.getBadgeLink((TeamscaleLinkProvider)linkProvider, this.getIncompleteBuildWarningText()), (String)linkTextWithTooltip, shouldAppendSizeValues);
            ++appendedBadges;
        }
        if (evaluationResults.size() > 3) {
            MergeRequestAnnotationInput.appendEmptyLine(builder);
        }
    }

    private static String escapeQuotes(String textDescription) {
        return textDescription.replace("\"", "\\\"");
    }

    private static void appendEmptyLine(StringBuilder builder) {
        builder.append("  \n");
    }

    protected String getIncompleteBuildWarningText() {
        if (this.isBuildIncomplete()) {
            return this.mergeRequest.buildPipelineInfo.getIncompleteWarningTextForTgaBadge();
        }
        return null;
    }

    public String buildMergeBadgesAsMarkdownTableBitbucketCloud(TeamscaleProjectLinkProvider linkProvider, boolean showRequirementsBadge) {
        StringBuilder builder = new StringBuilder();
        builder.append("- ![Teamscale](").append(linkProvider.createTeamscaleLogoLink()).append(") \n");
        if (this.isFindingsBadgeEnabled) {
            String findingsBadgeUrl = linkProvider.createStaticFindingsBadgeUrl(this.relevantFindingsDelta.getNumberOfAddedFindings(), this.relevantFindingsDelta.getNumberOfFindingsInChangedCode(), this.relevantFindingsDelta.getNumberOfRemovedFindings());
            builder.append("- ![Findings](").append(findingsBadgeUrl).append(") \n");
        }
        if (this.commitAlerts != null && this.totalCommitAlertsFromAllCommits > 0) {
            String commitAlertsBadgeUrl = linkProvider.createStaticCommitAlertsBadgeUrl(this.totalCommitAlertsFromAllCommits);
            builder.append("- ![Commit Alerts](").append(commitAlertsBadgeUrl).append(") \n");
        }
        if (this.testGapInfo != null && this.isTestGapBadgeEnabled) {
            double ratio = TgaAggregationUtils.calculateRatio(ETgaAssessmentType.TEST_GAP, this.testGapInfo.testGapStates());
            String tgaBadgeUrl = linkProvider.createStaticTgaBadgeUrl(ratio, this.testGapInfo.testGapStates().getValue((Object)ETestGapState.TESTED_CHURN), this.testGapInfo.testGapStates().getValue((Object)ETestGapState.UNTESTED_CHANGE), this.testGapInfo.testGapStates().getValue((Object)ETestGapState.UNTESTED_ADDITION), null);
            builder.append("- ![Test Gap Analysis](").append(tgaBadgeUrl).append(") \n");
        }
        if (showRequirementsBadge) {
            String specItemsUrl = linkProvider.createStaticSpecItemsBadgeUrl(this.impactedSpecItemsDelta.size());
            builder.append("- ![Requirements](").append(specItemsUrl).append(") \n");
        }
        String linkText = linkProvider.createMergeRequestDetailsLink(this.mergeRequest.identifier);
        builder.append("- [(Open in Teamscale)](").append(linkText).append(") \n");
        return builder.toString();
    }

    private void appendTeamscaleLogo(StringBuilder builder, TeamscaleProjectLinkProvider linkProvider, String mergeRequestLink, boolean shouldAppendSizeValues) {
        String teamscaleLogoLink = linkProvider.createTeamscaleLogoLink();
        if (ERepositoryConnector.BITBUCKET_SERVER.getReadableName().equals(this.connectorType)) {
            teamscaleLogoLink = linkProvider.createTeamscaleLogoLinkForBitbucketServer();
        }
        MergeRequestAnnotationInput.appendMarkdownImage(builder, "Teamscale's logo", teamscaleLogoLink, mergeRequestLink, shouldAppendSizeValues);
    }

    private void appendFindingsBadge(StringBuilder builder, TeamscaleProjectLinkProvider linkProvider, String mergeRequestLink, boolean shouldAppendSizeValues) {
        if (this.isFindingsBadgeEnabled) {
            String findingsBadgeUrl = linkProvider.createStaticFindingsBadgeUrl(this.relevantFindingsDelta.getNumberOfAddedFindings(), this.relevantFindingsDelta.getNumberOfFindingsInChangedCode(), this.relevantFindingsDelta.getNumberOfRemovedFindings());
            MergeRequestAnnotationInput.appendMarkdownImage(builder, MergeRequestAnnotationInput.getAltText(this.relevantFindingsDelta), findingsBadgeUrl, mergeRequestLink, shouldAppendSizeValues);
        }
    }

    private void appendCommitAlertsBadge(StringBuilder builder, TeamscaleProjectLinkProvider linkProvider, String mergeRequestLink, boolean shouldAppendSizeValues) {
        if (this.commitAlerts != null && this.totalCommitAlertsFromAllCommits > 0) {
            String commitAlertsBadgeUrl = linkProvider.createStaticCommitAlertsBadgeUrl(this.totalCommitAlertsFromAllCommits);
            MergeRequestAnnotationInput.appendMarkdownImage(builder, MergeRequestAnnotationInput.getAltText(this.totalCommitAlertsFromAllCommits), commitAlertsBadgeUrl, mergeRequestLink, shouldAppendSizeValues);
        }
    }

    private void appendTestGapBadge(StringBuilder builder, TeamscaleProjectLinkProvider linkProvider, String mergeRequestLink, boolean shouldAppendSizeValues) {
        if (this.testGapInfo != null && this.isTestGapBadgeEnabled) {
            double ratio = TgaAggregationUtils.calculateRatio(ETgaAssessmentType.TEST_GAP, this.testGapInfo.testGapStates());
            String tgaBadgeUrl = linkProvider.createStaticTgaBadgeUrl(ratio, this.testGapInfo.testGapStates().getValue((Object)ETestGapState.TESTED_CHURN), this.testGapInfo.testGapStates().getValue((Object)ETestGapState.UNTESTED_CHANGE), this.testGapInfo.testGapStates().getValue((Object)ETestGapState.UNTESTED_ADDITION), this.getIncompleteBuildWarningText());
            MergeRequestAnnotationInput.appendMarkdownImage(builder, MergeRequestAnnotationInput.getAltText(this.testGapInfo.testGapStates()), tgaBadgeUrl, mergeRequestLink, shouldAppendSizeValues);
        }
    }

    private static void appendMarkdownImage(StringBuilder builder, String altText, String linkTarget, String linkText, boolean shouldAppendSizeValues) {
        String enclosingBrackets = ")](";
        if (shouldAppendSizeValues) {
            enclosingBrackets = "){height=100%}](";
        }
        builder.append("[![").append(altText).append("](").append(linkTarget).append(enclosingBrackets).append(linkText).append(")   ");
    }

    private static String getAltText(FindingDelta unflaggedFindings) {
        return String.format("%d added, %d in changed code, %d removed", unflaggedFindings.getNumberOfAddedFindings(), unflaggedFindings.getNumberOfFindingsInChangedCode(), unflaggedFindings.getNumberOfRemovedFindings());
    }

    private static String getAltText(ImpactedSpecItemsDelta impactedRequirementsDelta) {
        return impactedRequirementsDelta.size() + " affected specification items";
    }

    private static String getAltText(CounterSet<ETestGapState> testGapStates) {
        return TgaAggregationUtils.getTestGapsFormatted(testGapStates);
    }

    private static String getAltText(int totalCommitAlertsFromAllCommits) {
        String text = StringUtils.pluralize((String)" commit alert", (int)totalCommitAlertsFromAllCommits);
        return totalCommitAlertsFromAllCommits + text;
    }

    public String createMergeRequestDetailsLink(TeamscaleCommitLinkProvider linkProvider) {
        return linkProvider.createMergeRequestDetailsLink(this.mergeRequest.identifier);
    }

    public boolean isBuildIncomplete() {
        return !this.mergeRequest.buildPipelineInfo.isBuildComplete();
    }

    public static class Builder {
        private FindingDelta findingsDelta;
        private FindingDelta relevantFindingsDelta;
        private CommitDescriptor sourceCommit;
        private CommitDescriptor targetCommit;
        private MergeBaseInfo mergeBase;
        private MergeRequest mergeRequest;
        private ImpactedSpecItemsDelta impactedSpecItemsDelta;
        private @Nullable MergeRequestTestGapInfo testGapInfo;
        private @Nullable TestCoverageDeltaInfo testCoverageDeltaInfo;
        private @Nullable MergeRequestCriticalChangeInfo criticalChangeInfo;
        private MergeRequestMetricThresholdsInfo metricThresholdsInfo;
        private boolean ignoreYellowFindingsForVotes;
        private boolean ignoreYellowFindingsForComments;
        private boolean isFindingsBadgeEnabled;
        private boolean isTestGapBadgeEnabled;
        private boolean isMetricThresholdBadgesEnabled;
        private String connectorType;
        private List<CommitAlerts> commitAlerts;
        private int totalCommitAlertsFromAllCommits;

        private Builder() {
        }

        public MergeRequestAnnotationInput build() {
            return new MergeRequestAnnotationInput(this.findingsDelta, this.relevantFindingsDelta, this.ignoreYellowFindingsForVotes, this.ignoreYellowFindingsForComments, this.isFindingsBadgeEnabled, this.isTestGapBadgeEnabled, this.isMetricThresholdBadgesEnabled, this.sourceCommit, this.targetCommit, this.mergeBase, this.mergeRequest, this.impactedSpecItemsDelta, this.testGapInfo, this.testCoverageDeltaInfo, this.metricThresholdsInfo, this.criticalChangeInfo, this.connectorType, this.commitAlerts, this.totalCommitAlertsFromAllCommits);
        }

        public Builder setConnectorOptions(@NonNull ConnectorConfiguration connector) {
            this.ignoreYellowFindingsForVotes = CcpIntegrationFeatureEnablements.isIgnoreYellowFindingsForVotesEnabled(connector);
            this.ignoreYellowFindingsForComments = CcpIntegrationFeatureEnablements.isIgnoreYellowFindingsForCommentsEnabled(connector);
            this.isFindingsBadgeEnabled = CcpIntegrationFeatureEnablements.isFindingsBadgeEnabled(connector);
            this.isTestGapBadgeEnabled = CcpIntegrationFeatureEnablements.isTestGapBadgeEnabled(connector);
            this.isMetricThresholdBadgesEnabled = CcpIntegrationFeatureEnablements.isAnyMetricBadgeEnabled(connector);
            this.connectorType = connector.getRawType();
            return this;
        }

        public Builder setCommitAlertsInfo(CommitAlertsInfo commitAlertsInfo) {
            this.commitAlerts = commitAlertsInfo.commitAlerts();
            this.totalCommitAlertsFromAllCommits = commitAlertsInfo.totalCommitAlerts();
            return this;
        }

        public Builder setFindingsDelta(@NonNull FindingDelta findingsDelta) {
            this.findingsDelta = findingsDelta;
            return this;
        }

        public Builder setRelevantFindingsDelta(@NonNull FindingDelta relevantFindingsDelta) {
            this.relevantFindingsDelta = relevantFindingsDelta;
            return this;
        }

        public Builder setSourceCommit(@NonNull CommitDescriptor sourceCommit) {
            this.sourceCommit = sourceCommit;
            return this;
        }

        public Builder setTargetCommit(@NonNull CommitDescriptor targetCommit) {
            this.targetCommit = targetCommit;
            return this;
        }

        public Builder setMergeBase(@NonNull MergeBaseInfo mergeBase) {
            this.mergeBase = mergeBase;
            return this;
        }

        public Builder setMergeRequest(@NonNull MergeRequest mergeRequest) {
            this.mergeRequest = mergeRequest;
            return this;
        }

        public Builder setImpactedSpecItemsDelta(@NonNull ImpactedSpecItemsDelta impactedSpecItemsDelta) {
            this.impactedSpecItemsDelta = impactedSpecItemsDelta;
            return this;
        }

        public Builder setTestGapInfo(@Nullable MergeRequestTestGapInfo testGapInfo) {
            this.testGapInfo = testGapInfo;
            return this;
        }

        public Builder setTestCoverageDeltaInfo(@Nullable TestCoverageDeltaInfo testCoverageDeltaInfo) {
            this.testCoverageDeltaInfo = testCoverageDeltaInfo;
            return this;
        }

        public Builder setMetricThresholdsInfo(@NonNull MergeRequestMetricThresholdsInfo metricThresholdsInfo) {
            this.metricThresholdsInfo = metricThresholdsInfo;
            return this;
        }

        public Builder setCriticalChangeInfo(@Nullable MergeRequestCriticalChangeInfo criticalChangeInfo) {
            this.criticalChangeInfo = criticalChangeInfo;
            return this;
        }

        @TestOnly
        public Builder enableIgnoreYellowFindingsForVotes() {
            this.ignoreYellowFindingsForVotes = true;
            return this;
        }

        @TestOnly
        public Builder enableIgnoreYellowFindingsForComments() {
            this.ignoreYellowFindingsForComments = true;
            return this;
        }

        @TestOnly
        public Builder enableFindingsBadge() {
            this.isFindingsBadgeEnabled = true;
            return this;
        }

        @TestOnly
        public Builder enableTestGapBadge() {
            this.isTestGapBadgeEnabled = true;
            return this;
        }

        @TestOnly
        public Builder enableMetricThresholdBadges() {
            this.isMetricThresholdBadgesEnabled = true;
            return this;
        }
    }
}

