/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.analysis.trigger.IPostTriggerAction;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.MergeRequestProcessor;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.merge_request.voting.PostponedVotingIndex;
import com.teamscale.index.repository.RepositoryChangeRetrieverBase;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.git.common.GitRepositoryManagementConnectorDescriptorBase;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

@AnalysisStep
public abstract class MergeRequestSynchronizerBase<PROVIDER extends MergeRequestProvider<PLATFORM_SPECIFIC_MERGE_REQUEST, ?>, PLATFORM_SPECIFIC_MERGE_REQUEST>
extends ChangeRetrieverAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @StepParameter(value="Connector Identifier")
    private String connectorIdentifier;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected ServerOptionIndex serverOptionIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    @VisibleForTesting
    protected MergeRequestIndex mergeRequestIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalCredentialsIndex externalCredentialsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    @VisibleForTesting
    protected BranchAnalysisStateIndex branchAnalysisStateIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    @VisibleForTesting
    protected RepositoryRevisionIndex repositoryRevisionIndex;
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    @VisibleForTesting
    protected CrossRepositoryMergeRequestSourceBranchesIndex crossRepositoryMergeRequestSourceBranchesIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    @VisibleForTesting
    protected PostponedVotingIndex postponedVotingIndex;
    @StepParameter(value="build-job-polling-interval")
    private int buildJobPollingInterval;
    private MergeRequestProcessor<PROVIDER, PLATFORM_SPECIFIC_MERGE_REQUEST> mergeRequestProcessor;
    private final Instant synchronizerStartInstant = Instant.now();

    protected final Collection<IPostTriggerAction.IChangeRetrieverPostTriggerAction> executeChangeRetriever() throws Exception {
        try {
            PROVIDER provider = this.createMergeRequestProvider();
            this.mergeRequestProcessor = new MergeRequestProcessor(provider, this.mergeRequestIndex, this.crossRepositoryMergeRequestSourceBranchesIndex, this.postponedVotingIndex);
            ArrayList<IPostTriggerAction.IChangeRetrieverPostTriggerAction> actions = new ArrayList<IPostTriggerAction.IChangeRetrieverPostTriggerAction>();
            if (this.lastMergeRequestPollTimeExceedsInterval(((MergeRequestProvider)provider).getRepositoryPath())) {
                actions.addAll(this.synchronizeMergeRequests(provider));
            }
            if (this.shouldSynchronizeBuildJobs(provider)) {
                actions.addAll(this.synchronizeMergeRequestsAndCheckForBuildCompleteness(provider));
            }
            return actions;
        }
        catch (ServiceCallException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private boolean shouldSynchronizeBuildJobs(PROVIDER provider) throws StorageException {
        if (this.configuredBuildPatternsChanged(provider)) {
            return true;
        }
        return ((MergeRequestProvider)provider).requiresBuildCompletenessBeforeVoting() && this.lastBuildJobPollTimeExceedsInterval(((MergeRequestProvider)provider).getRepositoryPath());
    }

    @VisibleForTesting
    protected boolean configuredBuildPatternsChanged(PROVIDER provider) throws StorageException {
        IncludeExcludeRegexSupport storedBuildPatterns;
        IncludeExcludeRegexSupport configuredBuildPatterns = ((MergeRequestProvider)provider).getConfiguredBuildJobIncludeExcludePatterns();
        return !Objects.equals(configuredBuildPatterns, storedBuildPatterns = this.mergeRequestIndex.getConfiguredBuildPatterns(((MergeRequestProvider)provider).getRepositoryPath()));
    }

    private Collection<IPostTriggerAction.IChangeRetrieverPostTriggerAction> synchronizeMergeRequests(PROVIDER provider) throws ServiceCallException, StorageException {
        MergeRequestProcessor.MergeRequestSyncResult mergeRequestSyncResult = this.mergeRequestProcessor.synchronizeMergeRequests(this.repositoryRevisionIndex, this.branchAnalysisStateIndex);
        this.mergeRequestIndex.setLastMergeRequestPollTimestamp(((MergeRequestProvider)provider).getRepositoryPath(), this.synchronizerStartInstant);
        List<CommitDescriptor> reschedulePostRevisionTriggerCommits = mergeRequestSyncResult.reschedulePostRevisionTriggerCommits();
        ArrayList<IPostTriggerAction.IChangeRetrieverPostTriggerAction> actions = new ArrayList<IPostTriggerAction.IChangeRetrieverPostTriggerAction>();
        for (CommitDescriptor reschedulePostRevisionTriggerCommit : reschedulePostRevisionTriggerCommits) {
            actions.add((IPostTriggerAction.IChangeRetrieverPostTriggerAction)new IPostTriggerAction.RunPostRevisionTriggers(reschedulePostRevisionTriggerCommit));
        }
        if (mergeRequestSyncResult.hadCrossRepositoryMergeRequestUpdates()) {
            actions.add((IPostTriggerAction.IChangeRetrieverPostTriggerAction)new IPostTriggerAction.ScheduleChangeRetriever(this.buildChangeRetrieverTriggerName()));
        }
        return actions;
    }

    private String buildChangeRetrieverTriggerName() {
        return TriggerBuilder.buildTriggerName((String)this.connectorIdentifier, (String)StringUtils.getLastPart((String)this.getChangeRetrieverClass().getName(), (char)'.'));
    }

    @VisibleForTesting
    protected Collection<IPostTriggerAction.IChangeRetrieverPostTriggerAction> synchronizeMergeRequestsAndCheckForBuildCompleteness(PROVIDER provider) throws ServiceCallException, StorageException {
        ArrayList reschedulePostRevisionTriggerCommits = new ArrayList();
        List<MergeRequest> mergeRequestsToCheckForBuildCompleteness = this.determineMergeRequestsToCheckForBuildCompleteness(this.mergeRequestIndex.getAllMergeRequests(), provider);
        boolean shouldRunPostBuildCompletenessTriggers = false;
        for (MergeRequest mergeRequest : mergeRequestsToCheckForBuildCompleteness) {
            MergeRequestProcessor.ProcessMergeRequestResult processMergeRequestResult = this.mergeRequestProcessor.processMergeRequest(mergeRequest.identifier);
            MergeRequest updatedMergeRequest = processMergeRequestResult.updatedMergeRequest();
            if (updatedMergeRequest == null) continue;
            if (processMergeRequestResult.mergeRequestNeedsUpdate()) {
                Optional<CommitDescriptor> commit = MergeRequestUtils.retrieveMergeRequestHeadCommitIfLive(updatedMergeRequest, this.repositoryRevisionIndex, this.branchAnalysisStateIndex, processMergeRequestResult.crossRepositorySourceBranch());
                commit.ifPresent(reschedulePostRevisionTriggerCommits::add);
            }
            shouldRunPostBuildCompletenessTriggers |= !updatedMergeRequest.shouldBeRemovedFromIndex() && !mergeRequest.buildPipelineInfo.isBuildComplete() && updatedMergeRequest.buildPipelineInfo.isBuildComplete();
        }
        this.mergeRequestIndex.setLastBuildJobPollTimestamp(((MergeRequestProvider)provider).getRepositoryPath(), this.synchronizerStartInstant);
        ArrayList<IPostTriggerAction.IChangeRetrieverPostTriggerAction> actions = new ArrayList<IPostTriggerAction.IChangeRetrieverPostTriggerAction>();
        if (shouldRunPostBuildCompletenessTriggers) {
            actions.add((IPostTriggerAction.IChangeRetrieverPostTriggerAction)new IPostTriggerAction.RunPostBuildCompletenessTriggers());
        }
        for (CommitDescriptor reschedulePostRevisionTriggerCommit : reschedulePostRevisionTriggerCommits) {
            actions.add((IPostTriggerAction.IChangeRetrieverPostTriggerAction)new IPostTriggerAction.RunPostRevisionTriggers(reschedulePostRevisionTriggerCommit));
        }
        return actions;
    }

    @VisibleForTesting
    protected boolean lastMergeRequestPollTimeExceedsInterval(String repositoryName) throws StorageException {
        int mergeRequestPollingIntervalSeconds;
        Instant lastPollTimestamp = this.mergeRequestIndex.getLastMergeRequestPollTimestamp(repositoryName);
        return lastPollTimestamp.plusSeconds(mergeRequestPollingIntervalSeconds = GitRepositoryManagementConnectorDescriptorBase.MERGE_REQUEST_POLLING_INTERVAL_SECONDS).getEpochSecond() <= this.synchronizerStartInstant.getEpochSecond();
    }

    @VisibleForTesting
    protected boolean lastBuildJobPollTimeExceedsInterval(String repositoryPath) throws StorageException {
        Instant lastPollTimestamp = this.mergeRequestIndex.getLastBuildJobPollTimestamp(repositoryPath);
        return lastPollTimestamp.plusSeconds(this.buildJobPollingInterval).getEpochSecond() <= this.synchronizerStartInstant.getEpochSecond();
    }

    @VisibleForTesting
    protected List<MergeRequest> determineMergeRequestsToCheckForBuildCompleteness(List<MergeRequest> mergeRequests, PROVIDER provider) throws StorageException {
        List relevantMergeRequests = CollectionUtils.filter(mergeRequests, mr -> mr.getRepositoryPath().equalsIgnoreCase(provider.getRepositoryPath()));
        if (this.configuredBuildPatternsChanged(provider)) {
            this.mergeRequestIndex.setConfiguredBuildPatterns(((MergeRequestProvider)provider).getRepositoryPath(), ((MergeRequestProvider)provider).getConfiguredBuildJobIncludeExcludePatterns());
            return relevantMergeRequests;
        }
        return CollectionUtils.filter((Collection)relevantMergeRequests, mr -> mr.updatedAt != null && Instant.ofEpochMilli(mr.updatedAt).plusSeconds(GitRepositoryManagementConnectorDescriptorBase.MERGE_REQUEST_LAST_UPDATE_PERIOD_SECONDS).getEpochSecond() >= this.synchronizerStartInstant.getEpochSecond());
    }

    protected abstract PROVIDER createMergeRequestProvider() throws StorageException, ServiceCallException;

    protected ExternalCredentials getExternalCredentials(String accountIdentifier) throws StorageException {
        ExternalCredentials credentials = this.externalCredentialsIndex.getExternalCredentials(accountIdentifier);
        if (credentials == null) {
            throw new StorageException("Account doesn't exist: " + accountIdentifier);
        }
        return credentials;
    }

    protected abstract String getRepositoryPath();

    protected abstract Class<? extends RepositoryChangeRetrieverBase> getChangeRetrieverClass();
}

