/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments.comments;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.commit_alert.CommitAlert;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.markup.MarkupUtils;

public class CommitAlertReviewComment
implements IReviewComment {
    private final CommitAlert commitAlert;
    private final TeamscaleCommitLinkProvider linkProvider;
    private final CommitDescriptor commentedCommit;
    private final CommitDescriptor alertCommit;
    public static final String COMMIT_ALERT_MARKDOWN_COMMENT_START = "**[Alert]** ";

    public CommitAlertReviewComment(CommitAlert commitAlert, CommitDescriptor commentedCommit, CommitDescriptor alertCommit, TeamscaleCommitLinkProvider linkProvider) {
        this.commitAlert = commitAlert;
        this.commentedCommit = commentedCommit;
        this.alertCommit = alertCommit;
        this.linkProvider = linkProvider;
    }

    @Override
    public ETrafficLightColor getAssessment() {
        return ETrafficLightColor.RED;
    }

    @Override
    public ElementLocation getLocation() {
        if (this.alertCommit.equals((Object)this.commentedCommit)) {
            return this.commitAlert.getContext().getExpectedCloneLocation();
        }
        return new ElementLocation(this.commitAlert.getContext().getExpectedCloneLocation().getUniformPath());
    }

    @Override
    public List<ElementLocation> getSecondaryLocations() {
        return Collections.emptyList();
    }

    @Override
    public String getText() {
        return this.getTextWithoutLinks() + "\n" + this.getTeamscaleDetailsUrl();
    }

    @Override
    public String getTextWithoutLinks() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Alert] ");
        if (this.isNewFinding()) {
            sb.append("[New] ");
        }
        return sb.append(MarkupUtils.unescapeMarkdownRelevantSymbols((String)this.commitAlert.getMessage())).toString();
    }

    @Override
    public String getMarkdownText() {
        StringBuilder sb = new StringBuilder();
        sb.append(COMMIT_ALERT_MARKDOWN_COMMENT_START);
        if (this.isNewFinding()) {
            sb.append("**[New]** ");
        }
        return sb.append(this.commitAlert.getMessage()).append(" [(view in Teamscale)](").append(this.getTeamscaleDetailsUrl()).append(")").toString();
    }

    @Override
    public String getTeamscaleDetailsUrl() {
        return this.linkProvider.createCommitAlertDetailsLink(this.alertCommit.toUnresolvedCommitDescriptor());
    }

    private boolean isNewFinding() {
        return this.alertCommit.equals((Object)this.commentedCommit);
    }

    @Override
    public String getCategory() {
        return "Commit Alerts";
    }

    @Override
    public String getGroup() {
        return "";
    }
}

