/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.voting;

import java.util.List;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.KeysOnlyIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="postponed-votes", options={EStorageOption.NO_ROLLBACK}, valueClasses={String.class})
public class PostponedVotingIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "postponed-votes";
    private static final String LOCK_SUFFIX = "UPDATE";
    private final KeysOnlyIndex delegate;

    public PostponedVotingIndex(IStore store) {
        super(store);
        this.delegate = new KeysOnlyIndex(store);
    }

    public void addPostponedVote(MergeRequestIdentifier mergeRequestIdentifier) throws StorageException {
        this.delegate.runLocked(LOCK_SUFFIX, () -> this.delegate.storeKey(PostponedVotingIndex.toKey(mergeRequestIdentifier)));
    }

    public boolean hasPostponedVote(MergeRequestIdentifier mergeRequestIdentifier) throws StorageException {
        return this.delegate.hasKey(PostponedVotingIndex.toKey(mergeRequestIdentifier));
    }

    public void removePostponedVote(MergeRequestIdentifier mergeRequestIdentifier) throws StorageException {
        this.delegate.runLocked(LOCK_SUFFIX, () -> this.delegate.removeKey(PostponedVotingIndex.toKey(mergeRequestIdentifier)));
    }

    public List<String> getAllPostponedVotes() throws StorageException {
        return this.delegate.listKeys();
    }

    private static String toKey(MergeRequestIdentifier mergeRequestIdentifier) {
        return mergeRequestIdentifier.repositoryPath() + "/" + mergeRequestIdentifier.id();
    }
}

